/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j.xml;

import com.ibm.log4j.Appender;
import com.ibm.log4j.BasicConfigurator;
import com.ibm.log4j.Category;
import com.ibm.log4j.Layout;
import com.ibm.log4j.OptionHandler;
import com.ibm.log4j.Priority;
import com.ibm.log4j.helpers.LogLog;
import com.ibm.log4j.helpers.OptionConverter;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMConfigurator
extends BasicConfigurator {
    static final String LOG4J_TAG = "log4j";
    static final String APPENDER_TAG = "appender";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String PRIORITY_ATTR = "priority";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String SCFO_ATTR = "shippedCodeFlagOverride";
    static final String CONFIG_DEBUG_ATTR = "configDebug";

    private static Appender generateAppender(Element element) {
        String string = element.getAttribute(CLASS_ATTR);
        LogLog.debug("Class name: [" + string + "]");
        try {
            Object obj = Class.forName(string).newInstance();
            Appender appender = (Appender)obj;
            appender.setName(element.getAttribute(NAME_ATTR));
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    if (element2.getTagName().equals(LAYOUT_TAG)) {
                        appender.setLayout(DOMConfigurator.generateLayout(element2));
                    } else if (element2.getTagName().equals(PARAM_TAG)) {
                        DOMConfigurator.setParameters(appender, element2);
                    }
                }
                ++n2;
            }
            appender.activateOptions();
            return appender;
        }
        catch (Exception exception) {
            LogLog.error("Could not create an Appender. Reported error follows.", exception);
            return null;
        }
    }

    protected static void setParameters(OptionHandler optionHandler, Element element) {
        String string = element.getAttribute(NAME_ATTR);
        String string2 = element.getAttribute(VALUE_ATTR);
        LogLog.debug("Handling parameter \"" + string + "=" + string2 + "\"");
        if (string2 != null) {
            optionHandler.setOption(string, OptionConverter.convertSpecialChars(string2));
        }
    }

    private static void generateCategory(Element element, Hashtable hashtable) {
        Category category = Category.getInstance(element.getAttribute(NAME_ATTR));
        String string = element.getAttribute(PRIORITY_ATTR);
        if ("inherited".equals(string)) {
            category.setPriority(null);
        } else {
            category.setPriority(Priority.toPriority(string));
        }
        LogLog.debug("Category " + category.getName() + " set to " + category.getPriority());
        category.setAdditivity(OptionConverter.toBoolean(element.getAttribute(ADDITIVITY_ATTR), true));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                Appender appender = (Appender)hashtable.get(element2.getAttribute(REF_ATTR));
                category.addAppender(appender);
            }
            ++n2;
        }
    }

    private static Layout generateLayout(Element element) {
        String string = element.getAttribute(CLASS_ATTR);
        LogLog.debug("Parsing layout of class: \"" + string + "\"");
        try {
            Object obj = Class.forName(string).newInstance();
            Layout layout = (Layout)obj;
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    DOMConfigurator.setParameters(layout, (Element)node);
                }
                ++n2;
            }
            layout.activateOptions();
            return layout;
        }
        catch (Exception exception) {
            LogLog.error("Could not create the Layout. Reported error follows.", exception);
            return null;
        }
    }

    private static void generateRoot(Element element, Hashtable hashtable) {
        Category category = Category.getRoot();
        String string = element.getAttribute(PRIORITY_ATTR);
        category.setPriority(Priority.toPriority(string));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        category.removeAllAppenders();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                Appender appender = (Appender)hashtable.get(element2.getAttribute(REF_ATTR));
                category.addAppender(appender);
            }
            ++n2;
        }
    }

    public static void configure(Element element) {
        if (!element.getTagName().equals(LOG4J_TAG)) {
            LogLog.error("DOM element is not a <log4j> element");
            return;
        }
        String string = element.getAttribute(CONFIG_DEBUG_ATTR);
        LogLog.debug("configDebug attribute= \"" + string + "\".");
        if (!string.equals("") && !string.equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string, true));
        } else {
            LogLog.debug("Ignoring configDebug attribute.");
        }
        String string2 = element.getAttribute(SCFO_ATTR);
        LogLog.debug("Shipped code flag override=\"" + string2 + "\".");
        if (!string2.equals("") && !string2.equals("null")) {
            BasicConfigurator.overrideAsNeeded(string2);
        } else {
            LogLog.debug("Ignoring shippedCodeFlagOverride attribute.");
        }
        Hashtable<String, Appender> hashtable = new Hashtable<String, Appender>(11);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string3 = element2.getTagName();
                if (string3.equals(APPENDER_TAG)) {
                    String string4 = element2.getAttribute(NAME_ATTR);
                    LogLog.debug("Parsing appender named [" + string4 + "]");
                    Appender appender = DOMConfigurator.generateAppender(element2);
                    if (appender != null) {
                        hashtable.put(string4, appender);
                    }
                } else if (string3.equals(CATEGORY)) {
                    DOMConfigurator.generateCategory(element2, hashtable);
                } else if (string3.equals(ROOT_TAG)) {
                    DOMConfigurator.generateRoot(element2, hashtable);
                }
            }
            ++n2;
        }
    }

    private DOMConfigurator() {
    }
}

