/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j.net;

import com.ibm.log4j.AppenderSkeleton;
import com.ibm.log4j.Layout;
import com.ibm.log4j.LoggingEvent;
import com.ibm.log4j.helpers.OptionConverter;
import com.ibm.log4j.helpers.SyslogQuietWriter;
import com.ibm.log4j.helpers.SyslogWriter;
import com.ibm.log4j.net.SyslogTracerPrintWriter;

public class SyslogAppender
extends AppenderSkeleton {
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 72;
    public static final int LOG_AUTHPRIV = 80;
    public static final int LOG_FTP = 88;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    public static final String SYSLOG_HOST_OPTION = "SyslogHost";
    public static final String FACILITY_OPTION = "Facility";
    public static final String FACILITY_PRINTING_OPTION = "FacilityPrinting";
    protected static final int SYSLOG_HOST_OI = 0;
    protected static final int FACILITY_OI = 1;
    int syslogFacility = 8;
    String facilityStr;
    boolean facilityPrinting = false;
    SyslogTracerPrintWriter stp;
    SyslogQuietWriter sqw;
    String syslogHost;

    private void initSyslogFacilityStr(int n) {
        switch (n) {
            case 0: {
                this.facilityStr = "kern:";
                break;
            }
            case 8: {
                this.facilityStr = "user:";
                break;
            }
            case 16: {
                this.facilityStr = "mail:";
                break;
            }
            case 24: {
                this.facilityStr = "daemon:";
                break;
            }
            case 32: {
                this.facilityStr = "auth:";
                break;
            }
            case 40: {
                this.facilityStr = "syslog:";
                break;
            }
            case 48: {
                this.facilityStr = "lpr:";
                break;
            }
            case 56: {
                this.facilityStr = "news:";
                break;
            }
            case 64: {
                this.facilityStr = "uucp:";
                break;
            }
            case 72: {
                this.facilityStr = "cron:";
                break;
            }
            case 80: {
                this.facilityStr = "authpriv:";
                break;
            }
            case 88: {
                this.facilityStr = "ftp:";
                break;
            }
            case 128: {
                this.facilityStr = "local0:";
                break;
            }
            case 136: {
                this.facilityStr = "local1:";
                break;
            }
            case 144: {
                this.facilityStr = "local2:";
                break;
            }
            case 152: {
                this.facilityStr = "local3:";
                break;
            }
            case 160: {
                this.facilityStr = "local4:";
                break;
            }
            case 168: {
                this.facilityStr = "local5:";
                break;
            }
            case 176: {
                this.facilityStr = "local6:";
                break;
            }
            case 184: {
                this.facilityStr = "local7:";
                break;
            }
            default: {
                System.err.println("\"" + n + "\" is an unknown syslog facility. Defaulting to \"USER\".");
                this.syslogFacility = 8;
                this.facilityStr = "user:";
            }
        }
    }

    public synchronized void doAppend(LoggingEvent loggingEvent) {
        if (!this.isAsSevereAsThreshold(loggingEvent.priority)) {
            return;
        }
        if (this.sqw == null) {
            if (!this.emittedWarning) {
                this.emitWarning("No syslog host is set for SyslogAppedender named \"" + this.name + "\".");
            }
            return;
        }
        String string = (this.facilityPrinting ? this.facilityStr : "") + this.layout.format(loggingEvent);
        this.sqw.setPriority(loggingEvent.priority.toInt());
        this.sqw.write(string);
        if (loggingEvent.throwable != null) {
            loggingEvent.throwable.printStackTrace(this.stp);
        }
    }

    public void activateOptions() {
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{SYSLOG_HOST_OPTION, FACILITY_OPTION, FACILITY_PRINTING_OPTION});
    }

    public void setFacility(String string) {
        if (string == null) {
            return;
        }
        if ("KERN".equalsIgnoreCase(string)) {
            this.syslogFacility = 0;
        } else if ("USER".equalsIgnoreCase(string)) {
            this.syslogFacility = 8;
        } else if ("MAIL".equalsIgnoreCase(string)) {
            this.syslogFacility = 16;
        } else if ("DAEMON".equalsIgnoreCase(string)) {
            this.syslogFacility = 24;
        } else if ("AUTH".equalsIgnoreCase(string)) {
            this.syslogFacility = 32;
        } else if ("SYSLOG".equalsIgnoreCase(string)) {
            this.syslogFacility = 40;
        } else if ("LPR".equalsIgnoreCase(string)) {
            this.syslogFacility = 48;
        } else if ("NEWS".equalsIgnoreCase(string)) {
            this.syslogFacility = 56;
        } else if ("UUCP".equalsIgnoreCase(string)) {
            this.syslogFacility = 64;
        } else if ("CRON".equalsIgnoreCase(string)) {
            this.syslogFacility = 72;
        } else if ("AUTHPRIV".equalsIgnoreCase(string)) {
            this.syslogFacility = 80;
        } else if ("FTP".equalsIgnoreCase(string)) {
            this.syslogFacility = 88;
        } else if ("LOCAL0".equalsIgnoreCase(string)) {
            this.syslogFacility = 128;
        } else if ("LOCAL1".equalsIgnoreCase(string)) {
            this.syslogFacility = 136;
        } else if ("LOCAL2".equalsIgnoreCase(string)) {
            this.syslogFacility = 144;
        } else if ("LOCAL3".equalsIgnoreCase(string)) {
            this.syslogFacility = 152;
        } else if ("LOCAL4".equalsIgnoreCase(string)) {
            this.syslogFacility = 160;
        } else if ("LOCAL5".equalsIgnoreCase(string)) {
            this.syslogFacility = 168;
        } else if ("LOCAL6".equalsIgnoreCase(string)) {
            this.syslogFacility = 176;
        } else if ("LOCAL7".equalsIgnoreCase(string)) {
            this.syslogFacility = 184;
        } else {
            System.err.println(string + " is an unknown syslog facility. Defaulting to \"USER\".");
            this.syslogFacility = 8;
        }
        this.initSyslogFacilityStr(this.syslogFacility);
        if (this.sqw != null) {
            this.sqw.setSyslogFacility(this.syslogFacility);
        }
    }

    public void setOption(String string, String string2) {
        if (string2 == null) {
            return;
        }
        super.setOption(string, string2);
        if (string.equals(SYSLOG_HOST_OPTION)) {
            this.setSyslogHost(string2);
        } else if (string.equals(FACILITY_PRINTING_OPTION)) {
            this.facilityPrinting = OptionConverter.toBoolean(string2, this.facilityPrinting);
        } else if (string.equals(FACILITY_OPTION)) {
            this.setFacility(string2);
        }
    }

    public void setSyslogHost(String string) {
        this.sqw = new SyslogQuietWriter(new SyslogWriter(string), this.syslogFacility);
        this.stp = new SyslogTracerPrintWriter(this.sqw);
        this.syslogHost = string;
    }

    static /* synthetic */ Layout access$0(SyslogAppender syslogAppender) {
        return syslogAppender.layout;
    }

    public SyslogAppender() {
        this.initSyslogFacilityStr(this.syslogFacility);
    }

    public SyslogAppender(Layout layout, int n) {
        this.layout = layout;
        this.syslogFacility = n;
        this.initSyslogFacilityStr(n);
    }

    public SyslogAppender(Layout layout, String string, int n) {
        this(layout, n);
        this.setSyslogHost(string);
    }
}

