/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

import com.ibm.log4j.AppenderSkeleton;
import com.ibm.log4j.Layout;
import com.ibm.log4j.LoggingEvent;
import com.ibm.log4j.Priority;
import com.ibm.log4j.helpers.Loader;
import com.ibm.log4j.helpers.OptionConverter;
import com.ibm.log4j.helpers.QuietWriter;
import com.ibm.log4j.helpers.TracerPrintWriter;
import java.awt.Color;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TextPaneAppender
extends AppenderSkeleton {
    private static Icon[] icon = new Icon[]{new ImageIcon(Loader.getGIF_Image("icons/20x20/RedFlag.gif")), new ImageIcon(Loader.getGIF_Image("icons/20x20/RedFlag.gif")), new ImageIcon(Loader.getGIF_Image("icons/20x20/RedFlag.gif")), new ImageIcon(Loader.getGIF_Image("icons/20x20/RedFlag.gif")), new ImageIcon(Loader.getGIF_Image("icons/20x20/BlueFlag.gif")), new ImageIcon(Loader.getGIF_Image("icons/20x20/BlueFlag.gif")), new ImageIcon(Loader.getGIF_Image("icons/20x20/GreenFlag.gif")), new ImageIcon(Loader.getGIF_Image("icons/20x20/GreenFlag.gif"))};
    JTextPane textpane;
    StyledDocument doc;
    TracerPrintWriter tp;
    StringWriter sw;
    QuietWriter qw;
    MutableAttributeSet[] attributes;
    private String label;
    private boolean fancy;
    final String LABEL_OPTION;
    final String COLOR_OPTION_EMERG;
    final String COLOR_OPTION_ALERT;
    final String COLOR_OPTION_CRIT;
    final String COLOR_OPTION_ERROR;
    final String COLOR_OPTION_WARN;
    final String COLOR_OPTION_NOTICE;
    final String COLOR_OPTION_INFO;
    final String COLOR_OPTION_DEBUG;
    final String COLOR_OPTION_BACKGROUND;
    final String FANCY_OPTION;
    final String FONT_NAME_OPTION;
    final String FONT_SIZE_OPTION;
    protected String[] options = new String[]{"Label", "Color.Emerg", "Color.Alert", "Color.Crit", "Color.Error", "Color.Warn", "Color.Notice", "Color.Info", "Color.Debug", "Color.Background", "Fancy", "Font.Name", "Font.Size"};

    private void createAttributes() {
        this.attributes = new SimpleAttributeSet[8];
        int n = 0;
        while (n < this.attributes.length) {
            this.attributes[n] = new SimpleAttributeSet();
            StyleConstants.setFontSize(this.attributes[n], 14);
            ++n;
        }
        StyleConstants.setForeground(this.attributes[Priority.EMERG.toInt()], Color.cyan);
        StyleConstants.setForeground(this.attributes[Priority.ALERT.toInt()], Color.magenta);
        StyleConstants.setForeground(this.attributes[Priority.CRIT.toInt()], Color.pink);
        StyleConstants.setForeground(this.attributes[Priority.ERROR.toInt()], Color.red);
        StyleConstants.setForeground(this.attributes[Priority.WARN.toInt()], Color.orange);
        StyleConstants.setForeground(this.attributes[Priority.NOTICE.toInt()], Color.green.darker());
        StyleConstants.setForeground(this.attributes[Priority.INFO.toInt()], Color.gray);
        StyleConstants.setForeground(this.attributes[Priority.DEBUG.toInt()], Color.black);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public JTextPane getTextPane() {
        return this.textpane;
    }

    public String getLabel() {
        return this.label;
    }

    public void setTextPane(JTextPane jTextPane) {
        this.textpane = jTextPane;
        jTextPane.setEditable(false);
        jTextPane.setBackground(Color.lightGray);
        this.doc = jTextPane.getStyledDocument();
    }

    public void doAppend(LoggingEvent loggingEvent) {
        String string = this.layout.format(loggingEvent);
        String string2 = "";
        if (loggingEvent.throwable != null) {
            loggingEvent.throwable.printStackTrace(this.tp);
            int n = 0;
            while (n < this.sw.getBuffer().length()) {
                if (this.sw.getBuffer().charAt(n) == '\t') {
                    this.sw.getBuffer().replace(n, n + 1, "        ");
                }
                ++n;
            }
            string2 = this.sw.toString();
            this.sw.getBuffer().delete(0, this.sw.getBuffer().length());
        }
        try {
            if (this.fancy) {
                this.textpane.setEditable(true);
                this.textpane.insertIcon(icon[loggingEvent.priority.toInt()]);
                this.textpane.setEditable(false);
            }
            this.doc.insertString(this.doc.getLength(), string + string2, this.attributes[loggingEvent.priority.toInt()]);
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
        this.textpane.setCaretPosition(this.doc.getLength());
    }

    private Color parseColor(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[]{255, 255, 255, 255};
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        return new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    private void setColor(Priority priority, String string) {
        StyleConstants.setForeground(this.attributes[priority.toInt()], this.parseColor(string));
    }

    private void setFontSize(int n) {
        int n2 = 0;
        while (n2 < this.attributes.length) {
            StyleConstants.setFontSize(this.attributes[n2], n);
            ++n2;
        }
    }

    private void setFontName(String string) {
        int n = 0;
        while (n < this.attributes.length) {
            StyleConstants.setFontFamily(this.attributes[n], string);
            ++n;
        }
    }

    public String[] getOptionStrings() {
        return this.options;
    }

    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("Label")) {
            this.label = string2;
        }
        if (string.equalsIgnoreCase("Color.Emerg")) {
            this.setColor(Priority.EMERG, string2);
        }
        if (string.equalsIgnoreCase("Color.Alert")) {
            this.setColor(Priority.ALERT, string2);
        }
        if (string.equalsIgnoreCase("Color.Crit")) {
            this.setColor(Priority.CRIT, string2);
        }
        if (string.equalsIgnoreCase("Color.Error")) {
            this.setColor(Priority.ERROR, string2);
        }
        if (string.equalsIgnoreCase("Color.Warn")) {
            this.setColor(Priority.WARN, string2);
        }
        if (string.equalsIgnoreCase("Color.Notice")) {
            this.setColor(Priority.NOTICE, string2);
        }
        if (string.equalsIgnoreCase("Color.Info")) {
            this.setColor(Priority.INFO, string2);
        }
        if (string.equalsIgnoreCase("Color.Debug")) {
            this.setColor(Priority.DEBUG, string2);
        }
        if (string.equalsIgnoreCase("Color.Background")) {
            this.textpane.setBackground(this.parseColor(string2));
        }
        if (string.equalsIgnoreCase("Fancy")) {
            this.fancy = OptionConverter.toBoolean(string2, this.fancy);
        }
        if (string.equalsIgnoreCase("Font.Size")) {
            this.setFontSize(Integer.parseInt(string2));
        }
        if (string.equalsIgnoreCase("Font.Name")) {
            this.setFontName(string2);
        }
    }

    public TextPaneAppender(Layout layout, String string) {
        this.LABEL_OPTION = "Label";
        this.COLOR_OPTION_EMERG = "Color.Emerg";
        this.COLOR_OPTION_ALERT = "Color.Alert";
        this.COLOR_OPTION_CRIT = "Color.Crit";
        this.COLOR_OPTION_ERROR = "Color.Error";
        this.COLOR_OPTION_WARN = "Color.Warn";
        this.COLOR_OPTION_NOTICE = "Color.Notice";
        this.COLOR_OPTION_INFO = "Color.Info";
        this.COLOR_OPTION_DEBUG = "Color.Debug";
        this.COLOR_OPTION_BACKGROUND = "Color.Background";
        this.FANCY_OPTION = "Fancy";
        this.FONT_NAME_OPTION = "Font.Name";
        this.FONT_SIZE_OPTION = "Font.Size";
        this.layout = layout;
        this.name = string;
        this.setTextPane(new JTextPane());
        this.createAttributes();
    }

    public TextPaneAppender() {
        this.LABEL_OPTION = "Label";
        this.COLOR_OPTION_EMERG = "Color.Emerg";
        this.COLOR_OPTION_ALERT = "Color.Alert";
        this.COLOR_OPTION_CRIT = "Color.Crit";
        this.COLOR_OPTION_ERROR = "Color.Error";
        this.COLOR_OPTION_WARN = "Color.Warn";
        this.COLOR_OPTION_NOTICE = "Color.Notice";
        this.COLOR_OPTION_INFO = "Color.Info";
        this.COLOR_OPTION_DEBUG = "Color.Debug";
        this.COLOR_OPTION_BACKGROUND = "Color.Background";
        this.FANCY_OPTION = "Fancy";
        this.FONT_NAME_OPTION = "Font.Name";
        this.FONT_SIZE_OPTION = "Font.Size";
        this.setTextPane(new JTextPane());
        this.createAttributes();
        this.label = "";
        this.sw = new StringWriter();
        this.qw = new QuietWriter(this.sw);
        this.tp = new TracerPrintWriter(this.qw);
        this.fancy = true;
    }
}

