/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

import com.ibm.log4j.Layout;
import com.ibm.log4j.LoggingEvent;
import com.ibm.log4j.NDC;
import com.ibm.log4j.helpers.AbsoluteTimeDateFormat;
import com.ibm.log4j.helpers.DateTimeDateFormat;
import com.ibm.log4j.helpers.ISO8601DateFormat;
import com.ibm.log4j.helpers.LogLog;
import com.ibm.log4j.helpers.OptionConverter;
import com.ibm.log4j.helpers.RelativeTimeDateFormat;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.TimeZone;

public class TTCCLayout
extends Layout {
    public static final String THREAD_PRINTING_OPTION = "ThreadPrinting";
    public static final String CATEGORY_PREFIXING_OPTION = "CategoryPrefixing";
    public static final String CONTEXT_PRINTING_OPTION = "ContextPrinting";
    public static final String DATE_FORMAT_OPTION = "DateFormat";
    public static final String TIMEZONE_ID_OPTION = "TimeZone";
    public static final String NULL_DATE_FORMAT = "NULL";
    public static final String RELATIVE_TIME_DATE_FORMAT = "RELATIVE";
    private boolean threadPrinting = true;
    private boolean categoryPrefixing = true;
    private boolean contextPrinting = true;
    private String timeZoneID;
    private String dateFormatOption;
    protected final StringBuffer buf = new StringBuffer(256);
    protected DateFormat dateFormat;
    protected Date date = new Date();
    protected FieldPosition pos = new FieldPosition(0);
    private static /* synthetic */ Class class$Ljava$text$DateFormat;

    public String format(LoggingEvent loggingEvent) {
        this.buf.setLength(0);
        if (this.dateFormat != null) {
            this.date.setTime(loggingEvent.timeStamp);
            this.dateFormat.format(this.date, this.buf, this.pos);
            this.buf.append(' ');
        }
        if (this.threadPrinting) {
            this.buf.append('[');
            if (loggingEvent.threadName == null) {
                loggingEvent.threadName = Thread.currentThread().getName();
            }
            this.buf.append(loggingEvent.threadName);
            this.buf.append("] ");
        }
        this.buf.append(loggingEvent.priority.toString());
        this.buf.append(' ');
        if (this.categoryPrefixing) {
            this.buf.append(loggingEvent.category.getName());
            this.buf.append(' ');
        }
        if (this.contextPrinting) {
            if (loggingEvent.ndc == null) {
                loggingEvent.ndc = NDC.get();
            }
            if (loggingEvent.ndc != null) {
                this.buf.append(loggingEvent.ndc);
                this.buf.append(' ');
            }
        }
        this.buf.append("- ");
        this.buf.append(loggingEvent.message);
        this.buf.append(LINE_SEP);
        return this.buf.toString();
    }

    public String[] getOptionStrings() {
        return new String[]{THREAD_PRINTING_OPTION, CATEGORY_PREFIXING_OPTION, CONTEXT_PRINTING_OPTION, DATE_FORMAT_OPTION, TIMEZONE_ID_OPTION};
    }

    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase(THREAD_PRINTING_OPTION)) {
            this.threadPrinting = OptionConverter.toBoolean(string2, this.threadPrinting);
        } else if (string.equalsIgnoreCase(CATEGORY_PREFIXING_OPTION)) {
            this.categoryPrefixing = OptionConverter.toBoolean(string2, this.categoryPrefixing);
        } else if (string.equalsIgnoreCase(CONTEXT_PRINTING_OPTION)) {
            this.contextPrinting = OptionConverter.toBoolean(string2, this.contextPrinting);
        } else if (string.equalsIgnoreCase(DATE_FORMAT_OPTION)) {
            this.dateFormatOption = string2.toUpperCase();
        } else if (string.equalsIgnoreCase(TIMEZONE_ID_OPTION)) {
            this.timeZoneID = string2;
        } else {
            LogLog.error("Unknown option \"" + string + "\".");
        }
    }

    public void activateOptions() {
        this.setDateFormat(this.dateFormatOption, TimeZone.getTimeZone(this.timeZoneID));
    }

    public void setCategoryPrefixing(boolean bl) {
        this.categoryPrefixing = bl;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.setDateFormat(dateFormat, TimeZone.getDefault());
    }

    public void setDateFormat(DateFormat dateFormat, TimeZone timeZone) {
        this.dateFormat = dateFormat;
        this.dateFormat.setTimeZone(timeZone);
        this.timeZoneID = timeZone.getID();
    }

    public void setDateFormat(String string, TimeZone timeZone) {
        if (string == null) {
            this.dateFormat = null;
            return;
        }
        this.timeZoneID = timeZone.getID();
        this.dateFormat = string.equalsIgnoreCase(NULL_DATE_FORMAT) ? null : (string.equalsIgnoreCase(RELATIVE_TIME_DATE_FORMAT) ? new RelativeTimeDateFormat() : (string.equalsIgnoreCase("ABSOLUTE") ? new AbsoluteTimeDateFormat(timeZone) : (string.equalsIgnoreCase("DATE") ? new DateTimeDateFormat(timeZone) : (string.equalsIgnoreCase("ISO8601") ? new ISO8601DateFormat(timeZone) : (DateFormat)OptionConverter.instantiateByClassName(string, class$Ljava$text$DateFormat != null ? class$Ljava$text$DateFormat : (class$Ljava$text$DateFormat = TTCCLayout.class$("java.text.DateFormat")), null)))));
    }

    public void setDateFormat(String string) {
        this.setDateFormat(string, TimeZone.getDefault());
    }

    public void setThreadPrinting(boolean bl) {
        this.threadPrinting = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TTCCLayout() {
        this.setDateFormat(RELATIVE_TIME_DATE_FORMAT);
    }

    public TTCCLayout(String string) {
        this.setDateFormat(string);
    }

    public TTCCLayout(String string, TimeZone timeZone) {
        this.setDateFormat(string, timeZone);
    }

    public TTCCLayout(DateFormat dateFormat) {
        this.setDateFormat(dateFormat);
    }

    public TTCCLayout(DateFormat dateFormat, TimeZone timeZone) {
        this.setDateFormat(dateFormat, timeZone);
    }
}

