/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

import com.ibm.log4j.Appender;
import com.ibm.log4j.BasicConfigurator;
import com.ibm.log4j.Category;
import com.ibm.log4j.Layout;
import com.ibm.log4j.OptionHandler;
import com.ibm.log4j.Priority;
import com.ibm.log4j.helpers.LogLog;
import com.ibm.log4j.helpers.OptionConverter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyConfigurator
extends BasicConfigurator {
    protected static Hashtable registry = new Hashtable(11);
    static final String CATEGORY_PREFIX = "log4j.category.";
    static final String ADDITIVITY_PREFIX = "log4j.additivity.";
    static final String ROOT_CATEGORY_PREFIX = "log4j.rootCategory";
    static final String APPENDER_PREFIX = "log4j.appender.";
    private static final String INTERNAL_ROOT_NAME = "root";
    private static /* synthetic */ Class class$Lcom$ibm$log4j$Appender;
    private static /* synthetic */ Class class$Lcom$ibm$log4j$Layout;

    public static void configure(String string) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            LogLog.error("Could not read configuration file [" + string + "].", iOException);
            LogLog.error("Ignoring configuration file [" + string + "].");
            return;
        }
        PropertyConfigurator.configure(properties);
    }

    public static void configure(Properties properties) {
        String string = properties.getProperty("log4j.configDebug");
        if (string != null) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string, true));
        }
        String string2 = properties.getProperty("log4j.shippedCodeFlagOverride");
        BasicConfigurator.overrideAsNeeded(string2);
        registry.clear();
        PropertyConfigurator.configureRootCategory(properties);
        PropertyConfigurator.configureCategories(properties);
        LogLog.debug("Finished configuring.");
    }

    public static void configure(URL uRL) {
        Properties properties = new Properties();
        try {
            properties.load(uRL.openStream());
        }
        catch (IOException iOException) {
            LogLog.error("Could not read configuration file from URL [" + uRL + "].", iOException);
            LogLog.error("Ignoring configuration file [" + uRL + "].");
            return;
        }
        PropertyConfigurator.configure(properties);
    }

    static void configureOptionHandler(OptionHandler optionHandler, String string, Properties properties) {
        String[] stringArray = optionHandler.getOptionStrings();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = properties.getProperty(string + stringArray[n]);
            LogLog.debug("Option " + stringArray[n] + "=[" + (string2 == null ? "null" : string2) + "].");
            if (string2 != null) {
                optionHandler.setOption(stringArray[n], string2);
            }
            ++n;
        }
        optionHandler.activateOptions();
    }

    static void configureRootCategory(Properties properties) {
        String string = properties.getProperty(ROOT_CATEGORY_PREFIX);
        if (string == null) {
            LogLog.debug("Could not find root category information. Is this OK?");
        } else {
            PropertyConfigurator.parseCategory(properties, Category.getRoot(), ROOT_CATEGORY_PREFIX, INTERNAL_ROOT_NAME, string);
        }
    }

    protected static void configureCategories(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(CATEGORY_PREFIX)) continue;
            String string2 = string.substring(CATEGORY_PREFIX.length());
            String string3 = properties.getProperty(string);
            Category category = Category.getInstance(string2);
            PropertyConfigurator.parseCategory(properties, category, string, string2, string3);
            PropertyConfigurator.parseAdditivityForCategory(properties, category, string2);
        }
    }

    static void parseAdditivityForCategory(Properties properties, Category category, String string) {
        String string2 = properties.getProperty(ADDITIVITY_PREFIX + string);
        if (string2 != null && !string2.equals("")) {
            boolean bl = OptionConverter.toBoolean(string2, true);
            LogLog.debug("Setting additivity for \"" + string + "\" to " + bl);
            category.setAdditivity(bl);
        }
    }

    static void parseCategory(Properties properties, Category category, String string, String string2, String string3) {
        Object object;
        LogLog.debug("Parsing for [" + string2 + "] with value=[" + string3 + "].");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        if (!string3.startsWith(",") && !string3.equals("")) {
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            object = stringTokenizer.nextToken();
            LogLog.debug("Priority token is [" + (String)object + "].");
            if (((String)object).equalsIgnoreCase("inherited") && !string2.equals(INTERNAL_ROOT_NAME)) {
                category.setPriority(null);
            } else {
                category.setPriority(Priority.toPriority((String)object));
            }
            LogLog.debug("Category " + string2 + " set to " + category.getPriority());
        }
        category.removeAllAppenders();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            if (string4 == null || string4.equals(",")) continue;
            LogLog.debug("Parsing appender named \"" + string4 + "\".");
            object = PropertyConfigurator.parseAppender(properties, string4);
            if (object == null) continue;
            category.addAppender((Appender)object);
        }
    }

    static Appender parseAppender(Properties properties, String string) {
        Appender appender = PropertyConfigurator.registryGet(string);
        if (appender != null) {
            LogLog.debug("Appender \"" + string + "\" was already parsed.");
            return appender;
        }
        String string2 = APPENDER_PREFIX + string;
        String string3 = string2 + ".layout";
        appender = (Appender)OptionConverter.instantiateByKey(properties, string2, class$Lcom$ibm$log4j$Appender != null ? class$Lcom$ibm$log4j$Appender : (class$Lcom$ibm$log4j$Appender = PropertyConfigurator.class$("com.ibm.log4j.Appender")), null);
        if (appender == null) {
            LogLog.error("Could not instantiate appender named \"" + string + "\".");
            return null;
        }
        PropertyConfigurator.configureOptionHandler(appender, string2 + ".", properties);
        LogLog.debug("Parsed \"" + string + "\" options.");
        Layout layout = (Layout)OptionConverter.instantiateByKey(properties, string3, class$Lcom$ibm$log4j$Layout != null ? class$Lcom$ibm$log4j$Layout : (class$Lcom$ibm$log4j$Layout = PropertyConfigurator.class$("com.ibm.log4j.Layout")), null);
        if (layout != null) {
            appender.setLayout(layout);
            LogLog.debug("Parsing layout options for \"" + string + "\".");
            PropertyConfigurator.configureOptionHandler(layout, string3 + ".", properties);
            LogLog.debug("End of parsing for \"" + string + "\".");
        }
        appender.setName(string);
        PropertyConfigurator.registryPut(appender);
        return appender;
    }

    static void registryPut(Appender appender) {
        registry.put(appender.getName(), appender);
    }

    static Appender registryGet(String string) {
        return (Appender)registry.get(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private PropertyConfigurator() {
    }
}

