/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

public class Priority {
    private static final int EMERG_INT = 0;
    private static final int ALERT_INT = 1;
    private static final int CRIT_INT = 2;
    private static final int ERROR_INT = 3;
    private static final int WARN_INT = 4;
    private static final int NOTICE_INT = 5;
    private static final int INFO_INT = 6;
    private static final int DEBUG_INT = 7;
    private static String EMERG_STR = "EMERG";
    private static String ALERT_STR = "ALERT";
    private static String CRIT_STR = "CRIT";
    private static String ERROR_STR = "ERROR";
    private static String WARN_STR = "WARN";
    private static String NOTICE_STR = "NOTICE";
    private static String INFO_STR = "INFO";
    private static String DEBUG_STR = "DEBUG";
    public static final Priority EMERG = new Priority(0);
    public static final Priority ALERT = new Priority(1);
    public static final Priority CRIT = new Priority(2);
    public static final Priority ERROR = new Priority(3);
    public static final Priority WARN = new Priority(4);
    public static final Priority NOTICE = new Priority(5);
    public static final Priority INFO = new Priority(6);
    public static final Priority DEBUG = new Priority(7);
    private int value;
    private String strValue;

    public static final Priority[] getAllPossiblePriorities() {
        return new Priority[]{EMERG, ALERT, CRIT, ERROR, WARN, NOTICE, INFO, DEBUG};
    }

    public final int toInt() {
        return this.value;
    }

    public static Priority toPriority(String string) {
        String string2 = string.toUpperCase();
        if (string2.equalsIgnoreCase("DEBUG")) {
            return DEBUG;
        }
        if (string2.equalsIgnoreCase("INFO")) {
            return INFO;
        }
        if (string2.equalsIgnoreCase("NOTICE")) {
            return NOTICE;
        }
        if (string2.equalsIgnoreCase("WARN")) {
            return WARN;
        }
        if (string2.equalsIgnoreCase("ERROR")) {
            return ERROR;
        }
        if (string2.equalsIgnoreCase("CRIT")) {
            return CRIT;
        }
        if (string2.equalsIgnoreCase("ALERT")) {
            return ALERT;
        }
        if (string2.equalsIgnoreCase("EMERG")) {
            return EMERG;
        }
        return DEBUG;
    }

    public static Priority toPriority(int n) throws IllegalArgumentException {
        switch (n) {
            case 7: {
                return DEBUG;
            }
            case 6: {
                return INFO;
            }
            case 5: {
                return NOTICE;
            }
            case 4: {
                return WARN;
            }
            case 3: {
                return ERROR;
            }
            case 2: {
                return CRIT;
            }
            case 1: {
                return ALERT;
            }
            case 0: {
                return EMERG;
            }
        }
        throw new IllegalArgumentException(n + " is not a valid Priority integer.");
    }

    public final String toString() {
        return this.strValue;
    }

    public final boolean isAsSevereAs(Priority priority) {
        return this.value <= priority.value;
    }

    private Priority(int n) {
        this.value = n;
        switch (n) {
            case 0: {
                this.strValue = EMERG_STR;
                break;
            }
            case 1: {
                this.strValue = ALERT_STR;
                break;
            }
            case 2: {
                this.strValue = CRIT_STR;
                break;
            }
            case 3: {
                this.strValue = ERROR_STR;
                break;
            }
            case 4: {
                this.strValue = WARN_STR;
                break;
            }
            case 5: {
                this.strValue = NOTICE_STR;
                break;
            }
            case 6: {
                this.strValue = INFO_STR;
                break;
            }
            case 7: {
                this.strValue = DEBUG_STR;
                break;
            }
        }
    }
}

