/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

import com.ibm.log4j.Layout;
import com.ibm.log4j.LoggingEvent;
import com.ibm.log4j.helpers.PatternConverter;
import com.ibm.log4j.helpers.PatternParser;

public class PatternLayout
extends Layout {
    public static final String CONVERSION_PATTERN_OPTION = "ConversionPattern";
    public static final String DEFAULT_CONVERSION_PATTERN = "%m\n";
    public static final String TTCC_CONVERSION_PATTERN = "%-4r %-5p [%t] %30c - %m\n";
    private final StringBuffer sbuf = new StringBuffer(256);
    private PatternConverter head;

    public void activateOptions() {
    }

    public String format(LoggingEvent loggingEvent) {
        this.sbuf.setLength(0);
        PatternConverter patternConverter = this.head;
        while (patternConverter != null) {
            patternConverter.format(this.sbuf, loggingEvent);
            patternConverter = patternConverter.next;
        }
        return this.sbuf.toString();
    }

    public String[] getOptionStrings() {
        return new String[]{CONVERSION_PATTERN_OPTION};
    }

    public void setConversionPattern(String string) {
        this.setOption(CONVERSION_PATTERN_OPTION, string);
    }

    public void setOption(String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (string.equalsIgnoreCase(CONVERSION_PATTERN_OPTION)) {
            this.head = new PatternParser(string2).parse();
        }
    }

    public PatternLayout() {
        this(DEFAULT_CONVERSION_PATTERN);
    }

    public PatternLayout(String string) {
        this.head = new PatternParser(string == null ? DEFAULT_CONVERSION_PATTERN : string).parse();
    }
}

