/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

import java.util.Hashtable;
import java.util.Stack;

public class NDC {
    static Hashtable ht = new Hashtable();

    public static void inherit(Stack stack) {
        if (stack != null) {
            ht.put(Thread.currentThread(), stack);
        }
    }

    public static Stack cloneStack() {
        Object v = ht.get(Thread.currentThread());
        if (v == null) {
            return null;
        }
        Stack stack = (Stack)v;
        return (Stack)stack.clone();
    }

    public static String get() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && !stack.isEmpty()) {
            return ((DiagnosticContext)stack.peek()).fullMessage;
        }
        return null;
    }

    public static int getDepth() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack == null) {
            return 0;
        }
        return stack.size();
    }

    public static String pop() {
        Thread thread = Thread.currentThread();
        Stack stack = (Stack)ht.get(thread);
        if (stack != null && !stack.isEmpty()) {
            return ((DiagnosticContext)stack.pop()).message;
        }
        return "";
    }

    public static void push(String string) {
        Thread thread = Thread.currentThread();
        Stack<DiagnosticContext> stack = (Stack<DiagnosticContext>)ht.get(thread);
        if (stack == null) {
            DiagnosticContext diagnosticContext = new DiagnosticContext(string, null);
            stack = new Stack<DiagnosticContext>();
            ht.put(thread, stack);
            stack.push(diagnosticContext);
        } else if (stack.isEmpty()) {
            DiagnosticContext diagnosticContext = new DiagnosticContext(string, null);
            stack.push(diagnosticContext);
        } else {
            DiagnosticContext diagnosticContext = (DiagnosticContext)stack.peek();
            stack.push(new DiagnosticContext(string, diagnosticContext));
        }
    }

    public static void remove() {
        ht.remove(Thread.currentThread());
    }

    public static void setMaxDepth(int n) {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && n < stack.size()) {
            stack.setSize(n);
        }
    }

    private NDC() {
    }

    private static class DiagnosticContext {
        String fullMessage;
        String message;

        DiagnosticContext(String string, DiagnosticContext diagnosticContext) {
            this.message = string;
            this.fullMessage = diagnosticContext != null ? diagnosticContext.fullMessage + " " + string : string;
        }
    }
}

