/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

import com.ibm.log4j.Category;
import com.ibm.log4j.Layout;
import com.ibm.log4j.Priority;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;

public class LoggingEvent
implements Serializable {
    private static long startTime = System.currentTimeMillis();
    public static final String NA = "?";
    public Category category;
    public Priority priority;
    public String ndc;
    public String message;
    public String threadName;
    public Throwable throwable;
    public long timeStamp;
    public LocationInfo locationInfo;

    public static long getStartTime() {
        return startTime;
    }

    public LoggingEvent(Category category, Priority priority, String string, Throwable throwable) {
        this.category = category;
        this.priority = priority;
        this.message = string;
        this.throwable = throwable;
        this.timeStamp = System.currentTimeMillis();
    }

    public static class LocationInfo
    implements Serializable {
        private static StringWriter sw = new StringWriter();
        private static PrintWriter pw = new PrintWriter(sw);
        String lineNumber;
        String fileName;
        String className;
        String methodName;
        public String fullInfo;

        public String getClassName() {
            if (this.fullInfo == null) {
                return LoggingEvent.NA;
            }
            if (this.className == null) {
                int n = this.fullInfo.lastIndexOf(40);
                this.className = n == -1 ? LoggingEvent.NA : ((n = this.fullInfo.lastIndexOf(46, n)) == -1 ? LoggingEvent.NA : this.fullInfo.substring(0, n));
            }
            return this.className;
        }

        public String getFileName() {
            if (this.fullInfo == null) {
                return LoggingEvent.NA;
            }
            if (this.fileName == null) {
                int n = this.fullInfo.lastIndexOf(58);
                if (n == -1) {
                    this.fileName = LoggingEvent.NA;
                } else {
                    int n2 = this.fullInfo.lastIndexOf(40, n - 1);
                    this.fileName = this.fullInfo.substring(n2 + 1, n);
                }
            }
            return this.fileName;
        }

        public String getLineNumber() {
            if (this.fullInfo == null) {
                return LoggingEvent.NA;
            }
            if (this.lineNumber == null) {
                int n = this.fullInfo.lastIndexOf(41);
                int n2 = this.fullInfo.lastIndexOf(58, n - 1);
                this.lineNumber = n2 == -1 ? LoggingEvent.NA : this.fullInfo.substring(n2 + 1, n);
            }
            return this.lineNumber;
        }

        public String getMethodName() {
            if (this.fullInfo == null) {
                return LoggingEvent.NA;
            }
            if (this.methodName == null) {
                int n = this.fullInfo.lastIndexOf(40);
                int n2 = this.fullInfo.lastIndexOf(46, n);
                this.methodName = n2 == -1 ? LoggingEvent.NA : this.fullInfo.substring(n2 + 1, n);
            }
            return this.methodName;
        }

        public LocationInfo(Throwable throwable) {
            String string;
            StringWriter stringWriter = sw;
            synchronized (stringWriter) {
                throwable.printStackTrace(pw);
                string = sw.toString();
                sw.getBuffer().setLength(0);
            }
            int n = string.lastIndexOf("com.ibm.log4j.Category.");
            if (n == -1) {
                return;
            }
            if ((n = string.indexOf(Layout.LINE_SEP, n)) == -1) {
                return;
            }
            int n2 = string.indexOf(Layout.LINE_SEP, n += Layout.LINE_SEP_LEN);
            if (n2 == -1) {
                return;
            }
            n = string.lastIndexOf("at ", n2);
            if (n == -1) {
                return;
            }
            this.fullInfo = string.substring(n += 3, n2);
        }
    }
}

