/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

import com.ibm.log4j.AppenderSkeleton;
import com.ibm.log4j.Layout;
import com.ibm.log4j.LoggingEvent;
import com.ibm.log4j.helpers.OptionConverter;
import com.ibm.log4j.helpers.QuietWriter;
import com.ibm.log4j.helpers.TracerPrintWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FileAppender
extends AppenderSkeleton {
    public static final String FILE_OPTION = "File";
    public static final String APPEND_OPTION = "Append";
    protected static String[] options = new String[0];
    private boolean fileAppend = true;
    protected QuietWriter qw = null;
    protected TracerPrintWriter tp;
    protected String fileName = null;
    protected boolean qwIsOurs = false;

    public void activateOptions() {
        if (this.fileName != null) {
            try {
                this.setFile(this.fileName, this.fileAppend);
            }
            catch (IOException iOException) {
                System.err.println("setFile(" + this.fileName + "," + this.fileAppend + ") call failed.");
                iOException.printStackTrace();
            }
        }
    }

    protected void closeWriterIfOurs() {
        if (this.qwIsOurs) {
            try {
                this.qw.close();
            }
            catch (IOException iOException) {
                System.err.println("Could not close output stream " + this.qw);
                iOException.printStackTrace();
            }
        }
    }

    public synchronized void doAppend(LoggingEvent loggingEvent) {
        if (!this.isAsSevereAsThreshold(loggingEvent.priority)) {
            return;
        }
        if (this.qw == null) {
            if (!this.emittedWarning) {
                this.emitWarning("No output target set for appender named \"" + this.name + "\".");
            }
            return;
        }
        if (this.layout == null) {
            if (!this.emittedWarning) {
                this.emitWarning("No layout set for appender named \"" + this.name + "\".");
            }
            return;
        }
        this.qw.write(this.layout.format(loggingEvent));
        if (loggingEvent.throwable != null) {
            loggingEvent.throwable.printStackTrace(this.tp);
        }
        this.qw.flush();
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{FILE_OPTION, APPEND_OPTION});
    }

    public synchronized void setFile(String string, boolean bl) throws IOException {
        this.closeWriterIfOurs();
        this.setQWForFiles(new FileWriter(string, bl));
        this.tp = new TracerPrintWriter(this.qw);
        this.fileName = string;
        this.qwIsOurs = true;
    }

    public void setFile(String string) throws IOException {
        this.setFile(string, this.fileAppend);
    }

    public void setOption(String string, String string2) {
        super.setOption(string, string2);
        if (string.equalsIgnoreCase(FILE_OPTION)) {
            if (string2.equalsIgnoreCase("System.out")) {
                this.setWriter(new OutputStreamWriter(System.out));
            } else if (string2.equalsIgnoreCase("System.err")) {
                this.setWriter(new OutputStreamWriter(System.err));
            } else {
                this.fileName = string2;
            }
        } else if (string.equalsIgnoreCase(APPEND_OPTION)) {
            this.fileAppend = OptionConverter.toBoolean(string2, this.fileAppend);
        }
    }

    public synchronized void setWriter(Writer writer) {
        this.closeWriterIfOurs();
        this.qw = new QuietWriter(writer);
        this.tp = new TracerPrintWriter(this.qw);
        this.fileName = null;
        this.qwIsOurs = false;
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new QuietWriter(writer);
    }

    public FileAppender() {
    }

    public FileAppender(Layout layout, OutputStream outputStream) {
        this(layout, new OutputStreamWriter(outputStream));
    }

    public FileAppender(Layout layout, Writer writer) {
        this.layout = layout;
        this.setWriter(writer);
    }

    public FileAppender(Layout layout, String string, boolean bl) throws IOException {
        this.layout = layout;
        this.setFile(string, bl);
    }

    public FileAppender(Layout layout, String string) throws IOException {
        this(layout, string, true);
    }
}

