/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

import com.ibm.log4j.Category;
import com.ibm.log4j.CategoryKey;
import com.ibm.log4j.ProvisionNode;
import java.io.Serializable;
import java.util.Hashtable;

class CategoryFactory {
    static Hashtable ht = new Hashtable();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Category getInstance(String string) {
        CategoryKey categoryKey = new CategoryKey(string);
        Hashtable hashtable = ht;
        synchronized (hashtable) {
            Object v = ht.get(categoryKey);
            if (v == null) {
                Category category = new Category(string);
                ht.put(categoryKey, category);
                CategoryFactory.updateParents(category);
                return category;
            }
            if (v instanceof Category) {
                return (Category)v;
            }
            if (!(v instanceof ProvisionNode)) return null;
            Category category = new Category(string);
            ht.put(categoryKey, category);
            CategoryFactory.updateChildren((ProvisionNode)v, category);
            return category;
        }
    }

    private static final void updateParents(Category category) {
        String string = category.name;
        int n = string.length();
        boolean bl = false;
        int n2 = string.lastIndexOf(46, n - 1);
        while (n2 >= 0) {
            Serializable serializable;
            String string2 = string.substring(0, n2);
            CategoryKey categoryKey = new CategoryKey(string2);
            Object v = ht.get(categoryKey);
            if (v == null) {
                serializable = new ProvisionNode(category);
                ht.put(categoryKey, serializable);
            } else {
                if (v instanceof Category) {
                    bl = true;
                    category.parent = (Category)v;
                    break;
                }
                if (v instanceof ProvisionNode) {
                    ((ProvisionNode)v).addElement(category);
                } else {
                    serializable = new IllegalStateException("unexpected object type " + v.getClass() + " in ht.");
                    ((Throwable)serializable).printStackTrace();
                }
            }
            n2 = string.lastIndexOf(46, n2 - 1);
        }
        if (!bl) {
            category.parent = Category.root;
        }
    }

    private static final void updateChildren(ProvisionNode provisionNode, Category category) {
        String string = category.name;
        int n = provisionNode.size();
        int n2 = 0;
        while (n2 < n) {
            Category category2 = (Category)provisionNode.elementAt(n2);
            while (category2.parent != null && category2.parent.name.startsWith(string)) {
                category2 = category2.parent;
            }
            category.parent = category2.parent;
            category2.parent = category;
            ++n2;
        }
    }

    CategoryFactory() {
    }
}

