/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

import com.ibm.log4j.Appender;
import com.ibm.log4j.CategoryFactory;
import com.ibm.log4j.CategoryKey;
import com.ibm.log4j.LoggingEvent;
import com.ibm.log4j.Priority;
import com.ibm.log4j.ProvisionNode;
import com.ibm.log4j.RootCategory;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Category {
    static RootCategory root = new RootCategory(Priority.DEBUG);
    static boolean shippedCode = false;
    static boolean warnedOnce = false;
    String name;
    Priority priority;
    Category parent;
    Vector appenderList;
    boolean additive = true;

    public synchronized void addAppender(Appender appender) {
        if (appender == null) {
            return;
        }
        if (this.appenderList == null) {
            this.appenderList = new Vector(1);
        }
        if (!this.appenderList.contains(appender)) {
            this.appenderList.addElement(appender);
        }
    }

    public void assert(boolean bl, String string) {
        if (!bl) {
            this.error(string);
        }
    }

    static void clear() {
        CategoryFactory.ht.clear();
    }

    protected void callAppenders(Priority priority, String string, Throwable throwable) {
        Appender appender = null;
        LoggingEvent loggingEvent = new LoggingEvent(this, priority, string, throwable);
        Category category = this;
        while (category != null) {
            Category category2 = category;
            synchronized (category2) {
                if (category.appenderList != null) {
                    int n = category.appenderList.size();
                    int n2 = 0;
                    while (n2 < n) {
                        appender = (Appender)category.appenderList.elementAt(n2);
                        appender.doAppend(loggingEvent);
                        ++n2;
                    }
                    if (!category.additive) {
                        Object var9_10 = null;
                        break;
                    }
                }
            }
            category = category.parent;
        }
        if (!warnedOnce && appender == null) {
            System.err.println("No appenders could be found for category (" + (this.equals(root) ? "root" : this.getName()) + ").");
            System.err.println("Please initialize the log4j system properly.");
            warnedOnce = true;
        }
    }

    public void debug(Object object) {
        if (shippedCode) {
            return;
        }
        if (Priority.DEBUG.isAsSevereAs(this.getChainedPriority())) {
            this.callAppenders(Priority.DEBUG, String.valueOf(object), null);
        }
    }

    public void debug(String string) {
        if (shippedCode) {
            return;
        }
        if (Priority.DEBUG.isAsSevereAs(this.getChainedPriority())) {
            this.callAppenders(Priority.DEBUG, string, null);
        }
    }

    public void debug(String string, Throwable throwable) {
        if (shippedCode) {
            return;
        }
        if (Priority.DEBUG.isAsSevereAs(this.getChainedPriority())) {
            this.callAppenders(Priority.DEBUG, string, throwable);
        }
    }

    void dump() {
        System.out.println("Category " + this.name + " dump -----");
        Category category = this;
        while (category != null) {
            System.out.println("(" + category.name + ", " + category.priority + ") ->");
            category = category.parent;
        }
        System.out.println("---------------------------");
    }

    public void error(Object object) {
        if (this.isEnabledFor(Priority.ERROR)) {
            this.callAppenders(Priority.ERROR, String.valueOf(object), null);
        }
    }

    public void error(String string) {
        if (this.isEnabledFor(Priority.ERROR)) {
            this.callAppenders(Priority.ERROR, string, null);
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.isEnabledFor(Priority.ERROR)) {
            this.callAppenders(Priority.ERROR, string, throwable);
        }
    }

    static final void fullDump() {
        Enumeration enumeration = CategoryFactory.ht.keys();
        while (enumeration.hasMoreElements()) {
            CategoryKey categoryKey = (CategoryKey)enumeration.nextElement();
            Object v = CategoryFactory.ht.get(categoryKey);
            if (v instanceof Category) {
                ((Category)v).dump();
            }
            if (!(v instanceof ProvisionNode)) continue;
            ((ProvisionNode)v).dump(categoryKey.name);
        }
    }

    public Enumeration getAllAppenders() {
        if (this.appenderList == null) {
            return null;
        }
        return this.appenderList.elements();
    }

    public Appender getAppender(String string) {
        if (this.appenderList == null || string == null) {
            return null;
        }
        int n = this.appenderList.size();
        int n2 = 0;
        while (n2 < n) {
            Appender appender = (Appender)this.appenderList.elementAt(n2);
            if (string.equals(appender.getName())) {
                return appender;
            }
            ++n2;
        }
        return null;
    }

    public Priority getChainedPriority() {
        Category category = this;
        while (category != null) {
            if (category.priority != null) {
                return category.priority;
            }
            category = category.parent;
        }
        return null;
    }

    public static Enumeration getCurrentCategories() {
        Vector vector = new Vector(CategoryFactory.ht.size());
        Enumeration enumeration = CategoryFactory.ht.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof Category)) continue;
            vector.addElement(v);
        }
        return vector.elements();
    }

    public static Priority getRootPriority() {
        return Category.root.priority;
    }

    public static Category getInstance(String string) {
        return CategoryFactory.getInstance(string);
    }

    public final String getName() {
        return this.name;
    }

    public final Priority getPriority() {
        return this.priority;
    }

    public static final Category getRoot() {
        return root;
    }

    public void info(Object object) {
        if (shippedCode) {
            return;
        }
        if (Priority.INFO.isAsSevereAs(this.getChainedPriority())) {
            this.callAppenders(Priority.INFO, String.valueOf(object), null);
        }
    }

    public void info(String string) {
        if (shippedCode) {
            return;
        }
        if (Priority.INFO.isAsSevereAs(this.getChainedPriority())) {
            this.callAppenders(Priority.INFO, string, null);
        }
    }

    public void info(String string, Throwable throwable) {
        if (shippedCode) {
            return;
        }
        if (Priority.INFO.isAsSevereAs(this.getChainedPriority())) {
            this.callAppenders(Priority.INFO, string, throwable);
        }
    }

    public boolean isDebugEnabled() {
        if (shippedCode) {
            return false;
        }
        return Priority.DEBUG.isAsSevereAs(this.getChainedPriority());
    }

    public boolean isEnabledFor(Priority priority) {
        return priority.isAsSevereAs(this.getChainedPriority());
    }

    public boolean isInfoEnabled() {
        if (shippedCode) {
            return false;
        }
        return Priority.INFO.isAsSevereAs(this.getChainedPriority());
    }

    public void log(Priority priority, String string, Throwable throwable) {
        if (priority.isAsSevereAs(this.getChainedPriority())) {
            this.callAppenders(priority, string, throwable);
        }
    }

    public void log(Priority priority, String string) {
        if (priority.isAsSevereAs(this.getChainedPriority())) {
            this.callAppenders(priority, string, null);
        }
    }

    public synchronized void removeAppender(Appender appender) {
        if (appender == null || this.appenderList == null) {
            return;
        }
        this.appenderList.removeElement(appender);
    }

    public synchronized void removeAppender(String string) {
        if (string == null || this.appenderList == null) {
            return;
        }
        int n = this.appenderList.size();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(((Appender)this.appenderList.elementAt(n2)).getName())) {
                this.appenderList.removeElementAt(n2);
                break;
            }
            ++n2;
        }
    }

    public synchronized void removeAllAppenders() {
        this.appenderList = null;
    }

    public void setAdditivity(boolean bl) {
        this.additive = bl;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public static void setRootPriority(Priority priority) {
        root.setPriority(priority);
    }

    public void warn(Object object) {
        if (this.isEnabledFor(Priority.WARN)) {
            this.callAppenders(Priority.WARN, String.valueOf(object), null);
        }
    }

    public void warn(String string) {
        if (this.isEnabledFor(Priority.WARN)) {
            this.callAppenders(Priority.WARN, string, null);
        }
    }

    public void warn(String string, Throwable throwable) {
        if (this.isEnabledFor(Priority.WARN)) {
            this.callAppenders(Priority.WARN, string, throwable);
        }
    }

    Category(String string) {
        this.name = string;
    }
}

