/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log4j;

import com.ibm.log4j.Appender;
import com.ibm.log4j.Category;
import com.ibm.log4j.FileAppender;
import com.ibm.log4j.Layout;
import com.ibm.log4j.PatternLayout;
import com.ibm.log4j.helpers.LogLog;
import com.ibm.log4j.helpers.OptionConverter;

public class BasicConfigurator {
    public static final String SHIPPED_CODE_FLAG_OVERRIDE_KEY = "log4j.shippedCodeFlagOverride";
    public static final String INHERITED = "inherited";
    protected static boolean SCFOverride = false;

    public static void configure() {
        Category category = Category.getRoot();
        category.addAppender(new FileAppender((Layout)new PatternLayout("%-4r %-5p [%t] %30c - %m\n"), System.out));
    }

    public static void configure(Appender appender) {
        Category category = Category.getRoot();
        category.addAppender(appender);
    }

    public static void flagAsShippedCode() {
        Category.shippedCode = !SCFOverride;
    }

    protected static void overrideAsNeeded(String string) {
        if (string != null) {
            LogLog.debug("Handling non-null shipped code flag override directive: \"" + string + "\".");
            SCFOverride = OptionConverter.toBoolean(string, true);
            LogLog.debug("SCFOverride set to " + SCFOverride);
            if (SCFOverride) {
                Category.shippedCode = false;
            }
        }
    }

    static {
        String string = null;
        try {
            string = System.getProperty(SHIPPED_CODE_FLAG_OVERRIDE_KEY, string);
        }
        catch (SecurityException securityException) {
            LogLog.error("Could not read system property \"log4j.shippedCodeFlagOverride\".", securityException);
        }
        if (string != null) {
            SCFOverride = OptionConverter.toBoolean(string, true);
        }
    }
}

