/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.provider.cipher.DES;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public class DES_EDE3
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("DES-EDE3");
    private static final PrintWriter err = Debug.getOutput();
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 24;
    private static final int DES_KEY_LENGTH = 8;
    private Cipher des1 = new DES();
    private Cipher des2 = new DES();
    private Cipher des3 = new DES();

    private static void debug(String string) {
        err.println("DES-EDE3: " + string);
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws KeyException {
        Key[] keyArray = this.splitKey(key);
        this.des1.initEncrypt(keyArray[0]);
        this.des2.initDecrypt(keyArray[1]);
        this.des3.initEncrypt(keyArray[2]);
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        Key[] keyArray = this.splitKey(key);
        this.des1.initDecrypt(keyArray[2]);
        this.des2.initEncrypt(keyArray[1]);
        this.des3.initDecrypt(keyArray[0]);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = this.des1.update(byArray, n, n2);
        this.des2.update(byArray3, 0, byArray3.length, byArray3, 0);
        return this.des3.update(byArray3, 0, byArray3.length, byArray2, n3);
    }

    private Key[] splitKey(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 24) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        Key[] keyArray = new RawSecretKey[3];
        int n = 0;
        while (n < 3) {
            keyArray[n] = new RawSecretKey("DES", byArray, n * 8, 8);
            ++n;
        }
        return keyArray;
    }

    public DES_EDE3() {
        super(false, false, "Cryptix");
    }
}

