;; sample-keys.el
;; Here is a large collection of lightnifications and key bindings; 
;; these are part of my ordinary key bindings.  Use at your own risk. 
;;    John Palmieri, palmieri@math.mit.edu

(setq completions-map (make-sparse-keymap))
(define-key global-map "" completions-map)
(define-key completions-map "f" 'completing-insert-lisp-function)
(define-key completions-map "v" 'completing-insert-lisp-variable)
(define-key completions-map "o" 'completing-insert-lisp-object)
(define-key completions-map "F" 'completing-insert-file-name)
(define-key completions-map "u" 'completing-insert-according-to-mode)
(define-key completions-map "b" 'completing-insert-buffer-name)
(define-key completions-map "y" 'completing-insert-buffer-light)
(global-set-key "" 'completing-insert-according-to-mode)
(global-set-key "d" 'describe-function-light)
(global-set-key "f" 'describe-function-light)
(lightnify 'describe-function-light 'describe-function)
(global-set-key "v" 'describe-variable-light)
(lightnify 'describe-variable-light 'describe-variable)
(global-set-key "w" 'where-is-light)
(lightnify 'where-is-light 'where-is)
(global-set-key "" 'completing-insert-lisp-function)
(global-set-key "" 'completing-insert-lisp-variable)
(global-set-key "" 'completing-insert-lisp-object)
(global-set-key "" 'completing-insert-file-name)
(global-set-key "" 'completing-insert-buffer-name)
(global-set-key "" 'completing-insert-kill)
(global-set-key "" 'completing-insert-buffer-light)
(lightnify 'completing-insert-buffer-light 'completing-insert-buffer-contents)
(autoload 'completing-insert-buffer-contents "bufcomp" nil t)

(global-set-key "" 'eval-expression-light)
(lightnify 'eval-expression-light 'new-eval-expression
	   '(mapcar '(lambda (x) (list (prin1-to-string x)))
		    (apply 'append (mapcar 'sub-forms command-history)))
	   nil "command history")
(global-set-key "d" 'dired-light)
(global-set-key "" 'dired-light)
(lightnify 'dired-light 'dired)
(global-set-key "" 'find-file-light)
(global-set-key "f" 'find-file-light)
(lightnify 'find-file-light 'find-file)
(global-set-key "i" 'insert-file-light)
(lightnify 'insert-file-light 'insert-file)
(global-set-key "k" 'kill-buffer-light)
(global-set-key "" 'kill-buffer-light)
(lightnify 'kill-buffer-light 'kill-buffer)
(global-set-key "B" 'insert-buffer-light)
(lightnify 'insert-buffer-light 'insert-buffer)
(global-set-key "L" 'load-file-light)
(lightnify 'load-file-light 'load-file)
(global-set-key "" 'write-file-light)
(lightnify 'write-file-light 'write-file)
(global-set-key "b" 'switch-to-buffer-light)
(lightnify 'switch-to-buffer-light 'switch-to-buffer)
(global-set-key "" 'find-alternate-file-light)
(lightnify 'find-alternate-file-light 'find-alternate-file)

(global-set-key "%" 'query-replace-light)
(lightnify 'query-replace-light 'query-replace
	   '(quote buffer-completion-internal) '(current-buffer)
	   "buffer contents")
(autoload 'buffer-completion-internal "bufcomp")
(global-set-key "x" 'execute-extended-command-light)
(lightnify 'execute-extended-command-light 'execute-extended-command)

(global-set-key "4f" 'find-file-other-window-light)
(lightnify 'find-file-other-window-light 'find-file-other-window)
(global-set-key "4d" 'dired-other-window-light)
(global-set-key "4" 'dired-other-window-light)
(lightnify 'dired-other-window-light 'dired-other-window)
(global-set-key "4b" 'switch-to-buffer-other-window-light)
(lightnify 'switch-to-buffer-other-window-light 'switch-to-buffer-other-window)
(global-set-key "4m" nil)

(global-set-key "5f" 'find-file-other-frame-light)
(global-set-key "5f" 'find-file-other-frame-light)
(lightnify 'find-file-other-frame-light 'find-file-other-frame)
(global-set-key "5b" 'switch-to-buffer-other-frame-light)
(lightnify 'switch-to-buffer-other-frame-light
	   'switch-to-buffer-other-frame)
(global-set-key "5d" 'dired-other-frame-light)
(global-set-key "5" 'dired-other-frame-light)
(lightnify 'dired-other-frame-light 'dired-other-frame)
