;; lighthacks.el  Tue Oct  8 10:47:30 1991
;; Written by Mark Haiman and Nick Reingold.
;; Comments, suggestions, etc. should be sent to 
;; mhaiman@macaulay.ucsd.edu

;; Some tricks you can do with lightning completion.
;; You may wish to bind these lightnified functions
;; to convenient key sequences.  Be sure that light
;; gets loaded before these are evaluated.

(lightnify 'describe-function-light 'describe-function)
;; (global-set-key "\C-hd" 'describe-function-light)

(lightnify 'describe-variable-light 'describe-variable)
;; (global-set-key "\C-hv" 'describe-variable-light)

(lightnify 'dired-light 'dired)
;; (global-set-key "\C-xd" 'dired-light)

(lightnify 'find-alternate-file-light 'find-alternate-file)
;; (global-set-key "\C-x\C-v" 'find-alternate-file-light)

(lightnify 'find-file-light 'find-file)
;; (global-set-key "\C-x\C-f" 'find-file-light)

(lightnify 'find-file-other-window-light 'find-file-other-window)
;; (global-set-key "\C-x4\C-f" 'find-file-other-window-light)

(lightnify 'insert-file-light 'insert-file)
;; (global-set-key "\C-xi" 'insert-file-light)

(lightnify 'write-file-light 'write-file)
;; (global-set-key "\C-x\C-w" 'write-file-light)

(lightnify 'kill-buffer-light 'kill-buffer)
;; (global-set-key "\C-xk" 'kill-buffer-light)

(lightnify 'switch-to-buffer-light 'switch-to-buffer)
;; (global-set-key "\C-xb" 'switch-to-buffer-light)

(lightnify 'switch-to-buffer-other-window-light 'switch-to-buffer-other-window)
;; (global-set-key "\C-x4b" 'switch-to-buffer-other-window-light)

(lightnify 'execute-extended-command-light 'execute-extended-command)
;; (global-set-key "\M-x" 'execute-extended-command-light)


;; a non-trivial example:
;; replacement for repeat-complex-command
(defun sub-forms (x)
  (cons x (and (car (cdr x)) 
	       (symbolp (car x))
	       (listp (car (cdr x)))
	       (sub-forms (car (cdr x))))))

(lightnify 'eval-expression-light 'eval-expression
	   '(mapcar (function (lambda (x) (list (prin1-to-string x))))
		    (apply 'append (mapcar 'sub-forms command-history)))
	   nil "command history")
;; (global-set-key "\C-x\C-[" 'eval-expression-light)

;;; These require the buffer completion package (bufcomp.el), which is
;;; available on request.
;;;
;;; (autoload 'completing-insert-buffer-contents "bufcomp" nil t)
;;;
;;; (lightnify 'completing-insert-buffer-light
;;;            'completing-insert-buffer-contents)
;;; (lightnify 'query-replace-light 'query-replace
;;;            '(quote buffer-completion-internal) '(current-buffer)
;;;            "buffer contents")


