/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (options.h)
 *  
 *  It has been AutoGen-ed  Sunday June  1, 2003 at 11:40:48 AM PDT
 *  From the definitions    funcs.def
 *  and the template file   options_h
 *
 *  This file defines all the global structures and special values
 *  used in the automated option processing library.
 *
 *  Automated Options copyright 1992-Y Bruce Korb
 *
 *  AutoOpts is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  AutoOpts is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with AutoOpts; if not, write to:
 *             The Free Software Foundation, Inc.,
 *             59 Temple Place - Suite 330,
 *             Boston,  MA  02111-1307, USA.
 */
#ifndef AUTOOPTS_OPTIONS_H_GUARD
#define AUTOOPTS_OPTIONS_H_GUARD

/*
 *  PUBLIC DEFINES
 *
 *  The following defines may be used in applications that need to test
 *  the state of an option.  To test against these masks and values,
 *  a pointer to an option descriptor must be obtained.  There are two
 *  ways:  1.  inside an option processing procedure, it is the second
 *  argument, conventionally "tOptDesc* pOD".  2.  Outside of an option
 *  procedure (or to reference a different option descriptor), use
 *  either "&DESC( opt_name )" or "&pfx_DESC( opt_name )".  See the
 *  relevant generated header file to determine which and what values
 *  for "opt_name" are available.
 */

#define OPTST_INIT         0x00000  /* Initial compiled value            */
#define OPTST_SET          0x00001  /* Set via the "SET_OPT()" macro     */
#define OPTST_PRESET       0x00002  /* Set via an RC/INI file            */
#define OPTST_DEFINED      0x00004  /* Set via a command line option     */
#define OPTST_SET_MASK     0x0000F  /* mask of flags that show set state */

#define OPTST_EQUIVALENCE  0x00010  /* selected by equiv'ed option       */
#define OPTST_DISABLED     0x00020  /* option is in disabled state       */

#define OPTST_NO_INIT      0x00100  /* option cannot be preset           */
#define OPTST_NUMBER_OPT   0x00200  /* opt value (flag) is any digit     */
#define OPTST_STACKED      0x00400  /* opt uses stackOptArg procedure    */
#define OPTST_INITENABLED  0x00800  /* option defaults to enabled        */
#define OPTST_ENUMERATION  0x01000  /* opt arg is an enum (keyword list) */
#define OPTST_BOOLEAN      0x02000  /* opt arg is boolean-valued         */
#define OPTST_NUMERIC      0x04000  /* opt arg has numeric value         */
#define OPTST_DOCUMENT     0x08000  /* opt is for documentation only     */
#define OPTST_IMM          0x10000  /* process option on first pass      */
#define OPTST_DISABLE_IMM  0x20000  /* process disablement on first pass */
#define OPTST_OMITTED      0x40000  /* compiled out of program           */
#define OPTST_MUST_SET     0x80000  /* must be set or pre-set            */

#define OPTST_PERSISTENT  0xFFFF00  /* mask of flags that do not change  */

#define SELECTED_OPT( pod )  ( (pod)->fOptState & (OPTST_SET | OPTST_DEFINED))
#define UNUSED_OPT(   pod )  (((pod)->fOptState & OPTST_SET_MASK) == 0)
#define DISABLED_OPT( pod )  ( (pod)->fOptState & OPTST_DISABLED)
#define OPTION_STATE( pod )  ((pod)->fOptState)

/*
 *  PRIVATE INTERFACES
 *
 *  The following values are used in the generated code to communicate
 *  with the option library procedures.  They are not for public use
 *  and may be subject to change.
 */

/*
 *  Define any special processing flags
 */
#define OPTPROC_NONE        0x0000
#define OPTPROC_LONGOPT     0x0001 /* Process long style options      */
#define OPTPROC_SHORTOPT    0x0002 /* Process short style "flags"     */
#define OPTPROC_ERRSTOP     0x0004 /* Stop on argument errors         */
#define OPTPROC_DISABLEDOPT 0x0008 /* Current option is disabled      */
#define OPTPROC_NO_REQ_OPT  0x0010 /* no options are required         */
#define OPTPROC_NUM_OPT     0x0020 /* there is a number option        */
#define OPTPROC_INITDONE    0x0040 /* have initializations been done? */
#define OPTPROC_NEGATIONS   0x0080 /* any negation options?           */
#define OPTPROC_ENVIRON     0x0100 /* check environment?              */
#define OPTPROC_NO_ARGS     0x0200 /* Disallow remaining arguments    */
#define OPTPROC_ARGS_REQ    0x0400 /* Require arguments after options */
#define OPTPROC_REORDER     0x0800 /* reorder arguments after options */
#define OPTPROC_GNUUSAGE    0x1000 /* emit usage in GNU style         */

#define STMTS(s)  do { s; } while (0)

#define ARG_NONE  ' '
#define ARG_MUST  ':'
#define ARG_MAY   '?'

/*
 *  The following must be #defined instead of typedef-ed
 *  because "static const" cannot both be applied to a type,
 *  tho each individually can...so they all are
 */
#define tSCC      static const char
#define tSC       static char
#define tCUC      const unsigned char
#define tUC       unsigned char
#define tCC       const char
#define tUI       unsigned int
#define tUL       unsigned long

/*
 *  It is so disgusting that there must be so many ways
 *  of specifying TRUE and FALSE.
 */
typedef enum { AG_FALSE = 0, AG_TRUE } ag_bool;

/*
 *  Define a structure that describes each option and
 *  a pointer to the procedure that handles it.
 *  The argument is the count of this flag previously seen.
 */
typedef struct options  tOptions;
typedef struct optDesc  tOptDesc;
typedef struct optNames tOptNames;

/*
 *  The option procedures do the special processing for each
 *  option flag that needs it.
 */
typedef void (tOptProc)( tOptions*  pOpts, tOptDesc* pOptDesc );
typedef tOptProc*  tpOptProc;

/*
 *  The usage procedure will never return.  It calls "exit(2)"
 *  with the "exitCode" argument passed to it.
 */
typedef void (tUsageProc)( tOptions* pOpts, int exitCode );
typedef tUsageProc* tpUsageProc;

/*
 *  Special definitions.  "NOLIMIT" is the 'max' value to use when
 *  a flag may appear multiple times without limit.  "NO_EQUIVALENT"
 *  is an illegal value for 'optIndex' (option description index).
 */
#define NOLIMIT          ((tUC)~0)
#define OPTION_LIMIT     0x7F
#define NO_EQUIVALENT    (OPTION_LIMIT+1)

/*
 *  Special values for optValue.  It must not be generatable from the
 *  computation "optIndex +96".  Since "optIndex" is limited to 100, ...
 */
#define NUMBER_OPTION    '#'

typedef struct argList tArgList;
#define MIN_ARG_ALLOC_CT   6
#define INCR_ARG_ALLOC_CT  8
struct argList {
    int               useCt;
    int               allocCt;
    char*             apzArgs[ MIN_ARG_ALLOC_CT ];
};

/*
 *  Descriptor structure for each option.
 *  Only the fields marked "PUBLIC" are for public use.
 */
struct optDesc {
    tCUC              optIndex;         /* PUBLIC */
    tCUC              optValue;         /* PUBLIC */
    tUC               optActualIndex;   /* PUBLIC */
    tUC               optActualValue;   /* PUBLIC */

    tUC               optArgType;
    tCUC              optEquivIndex;    /* PUBLIC */
    tCUC              optMinCt;
    tCUC              optMaxCt;

    tUL               optOccCt;         /* PUBLIC */
    tUL               fOptState;        /* PUBLIC */
    char*             pzLastArg;        /* PUBLIC */
    void*             optCookie;        /* PUBLIC */

    const int *       pOptMust;
    const int *       pOptCant;
    tpOptProc         pOptProc;
    const char*       pzText;

    const char*       pz_NAME;
    const char*       pz_Name;
    const char*       pz_DisableName;
    const char*       pz_DisablePfx;
};

/*
 *  Some options need special processing, so we store their
 *  indexes in a known place:
 */
typedef struct specOptIndex tSpecOptIndex;
struct specOptIndex {
    tUC               more_help;
    tUC               save_opts;
    tUC               number_option;
    tUC               default_opt;
};

#define  OPTIONS_STRUCT_VERSION  77834
#define  OPTIONS_VERSION_STRING  "19:2:10"
#define  OPTIONS_MINIMUM_VERSION 36864
#define  OPTIONS_MIN_VER_STRING  "9:0:0"

struct options {
    const int         structVersion;
    const char*       pzProgPath;
    const char*       pzProgName;
    const char*       pzPROGNAME;
    const char*       pzRcName;
    const char*       pzCopyright;
    const char*       pzCopyNotice;
    const char*       pzFullVersion;
    const char**      papzHomeList;
    const char*       pzUsageTitle;
    const char*       pzExplain;
    const char*       pzDetail;
    void*             pSavedState;
    tpUsageProc       pUsageProc;
    tUI               fOptSet;
    tUI               curOptIdx;
    char*             pzCurOpt;
    tSpecOptIndex     specOptIdx;
    const int         optCt;
    const int         presetOptCt;
    tOptDesc*         pOptDesc;
    int               origArgCt;
    char**            origArgVect;
    const char*       pzBugAddr;
};

#if defined( __STDC__ ) || defined( __cplusplus )
#  ifndef PROTO
#    define PROTO(s) s
#  endif

#else
#  ifndef PROTO
#    define PROTO(s) ()
#  endif

#  ifndef void
#    define void int
#  endif

#  ifndef const
#    define const
#  endif
#endif

#ifdef  __cplusplus
extern "C" {
#endif

/* AutoOpts PRIVATE FUNCTION: */
void export_options_to_guile PROTO(( tOptions* ));


/* AutoOpts PRIVATE FUNCTION: */
char* optionEnumerationVal PROTO(( tOptions*, tOptDesc*, tCC**, unsigned int ));


/* From: restore.c line 130
 *
 * optionFree - free allocated option processing memory
 *
 * Arguments:
 *   pOpts        program options descriptor
 *
 *  AutoOpts sometimes allocates memory and puts pointers to it in the
 *  option state structures.  This routine deallocates all such memory.
 */
void optionFree PROTO(( tOptions* ));


/* From: autoopts.c line 1468
 *
 * optionLoadLine - process a string for an option name and value
 *
 * Arguments:
 *   pOpts        program options descriptor
 *   pzLine       NUL-terminated text
 *
 *  This is a user callable routine for setting options from, for
 *  example, the contents of a file that they read in.
 *  Only one option may appear in the text.  It will be treated
 *  as a normal (non-preset) option.
 *  
 *  When passed a pointer to the option struct and a string, it will
 *  find the option named by the first token on the string and set
 *  the option argument to the remainder of the string.  The caller must
 *  NUL terminate the string.  Any embedded new lines will be included
 *  in the option argument.
 */
void optionLoadLine PROTO(( tOptions*, const char* ));


/* From: autoopts.c line 1570
 *
 * optionProcess - this is the main option processing routine
 *
 * Arguments:
 *   pOpts        program options descriptor
 *   argc         program arg count
 *   argv         program arg vector
 *
 * Returns: int - the count of the arguments processed
 *
 *  This is the main entry point for processing options.  It is intended
 *  that this procedure be called once at the beginning of the execution of
 *  a program.  Depending on options selected earlier, it is sometimes
 *  necessary to stop and restart option processing, or to select completely
 *  different sets of options.  This can be done easily, but you generally
 *  do not want to do this.
 *  
 *  The number of arguments processed always includes the program name.
 *  If one of the arguments is "--", then it is counted and the
 *  processing stops.  If an error was encountered and errors are
 *  to be tolerated, then the returned value is the index of the
 *  argument causing the error.
 */
int optionProcess PROTO(( tOptions*, int, char** ));


/* From: restore.c line 95
 *
 * optionRestore - restore option state from memory copy
 *
 * Arguments:
 *   pOpts        program options descriptor
 *
 *  Copy back the option state from saved memory.
 *  The allocated memory is left intact, so this routine can be
 *  called repeatedly without having to call optionSaveState again.
 */
void optionRestore PROTO(( tOptions* ));


/* From: save.c line 305
 *
 * optionSaveFile - saves the option state to a file
 *
 * Arguments:
 *   pOpts        program options descriptor
 *
 *  This routine will save the state of option processing to a file.  The name
 *  of that file can be specified with the argument to the @code{--save-opts}
 *  option, or by appending the @code{rcfile} attribute to the last
 *  @code{homerc} attribute.  If no @code{rcfile} attribute was specified, it
 *  will default to @code{.@i{programname}rc}.  If you wish to specify another
 *  file, you should invoke the @code{SET_OPT_SAVE_OPTS( @i{filename} )} macro.
 */
void optionSaveFile PROTO(( tOptions* ));


/* From: restore.c line 53
 *
 * optionSaveState - saves the option state to memory
 *
 * Arguments:
 *   pOpts        program options descriptor
 *
 *  This routine will allocate enough memory to save the current
 *  option processing state.  If this routine has been called before,
 *  that memory will be reused.  You may only save one copy of the
 *  option state.  This routine may be called before optionProcess(3).
 */
void optionSaveState PROTO(( tOptions* ));


/* From: autoopts.c line 1550
 *
 * optionVersion - return the compiled AutoOpts version number
 *
 * Returns: const char* - the version string in constant memory
 *
 *  Returns the full version string compiled into the library.
 *  The returned string cannot be modified.
 */
const char* optionVersion PROTO(( void ));


/* AutoOpts PRIVATE FUNCTION: */
void putBourneShell PROTO(( tOptions* ));

/*
 *  These routines should only be called by code generated by AutoOpts.
 *  These are not user functions.
 */
tOptProc stackOptArg, unstackOptArg, optionBooleanVal, optionNumericVal;

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_OPTIONS_H_GUARD */
/*
 * Local Variables:
 * c-file-style: "stroustrup"
 * indent-tabs-mode: nil
 * End:
 * options.h ends here */
