
/*
 *  agUtils.h
 *  $Id: agUtils.h,v 1.11 2003/02/15 22:58:59 bkorb Exp $
 *  Utilitarian definitions for AutoGen
 */

/*
 *  AutoGen copyright 1992-2003 Bruce Korb
 *
 *  AutoGen is free software.
 *  You may redistribute it and/or modify it under the terms of the
 *  GNU General Public License, as published by the Free Software
 *  Foundation; either version 2, or (at your option) any later version.
 *
 *  AutoGen is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AutoGen.  See the file "COPYING".  If not,
 *  write to:  The Free Software Foundation, Inc.,
 *             59 Temple Place - Suite 330,
 *             Boston,  MA  02111-1307, USA.
 */
#ifndef AUTOGEN_UTILS_H
#define AUTOGEN_UTILS_H

#include "config.h"
#include "compat/compat.h"

#include <time.h>
#include <utime.h>
#include <sys/mman.h>

#include <guile/gh.h>

#include "opts.h"
#include "snprintfv/printf.h"

#ifndef STR
#  define _STR(s) #s
#  define STR(s)  _STR(s)
#endif

#define ISNAMECHAR( c ) (isalnum(c) || ((c) == '_') || ((c) == '-'))

#define STRSIZE( s )  (sizeof(s)-1)

#ifdef DEFINING
#  define VALUE( s )  = s
#  define MODE
#else
#  define VALUE( s )
#  define MODE extern
#endif

#define YYSTYPE t_word

/*
 *  Dual pipe opening of a child process
 */
typedef struct {
    int     readFd;
    int     writeFd;
}  tFdPair;

typedef struct {
    FILE*   pfRead;  /* parent read fp  */
    FILE*   pfWrite; /* parent write fp */
}  tpfPair;

#define NOPROCESS   ((pid_t)-1)
#define NULLPROCESS ((pid_t)0)

typedef char* tpChar;

#endif /* AUTOGEN_UTILS_H */
/*
 * Local Variables:
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * end of agUtils.h */
