//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef REGEXPSTATE_H
#define REGEXPSTATE_H

#include <boost/regex.hpp>
#include <deque>
#include "my_sstream.h"

struct RegExpState;

struct RegExpFormatter
{
  const std::string elem; // the element represented
  RegExpState *next_state;
  bool exit_state;
  bool exit_all;

  RegExpFormatter(const std::string &el, RegExpState *r = 0, bool exit = false, bool all = false);
};

typedef std::deque<RegExpFormatter *> format_vector;

/**
class representing a state for the regular expression engine

@author Lorenzo Bettini
 */
struct RegExpState
{
  boost::regex reg_exp;
  format_vector *formatters;
  int current_formatter;
  std::ostringstream buffer;
  
  RegExpState() :
      formatters(0), current_formatter(0) {}
  RegExpState(const boost::regex *r, format_vector &v, int form = 0) :
      reg_exp(*r), formatters(&v), current_formatter(form) {}

  const std::string &get_elem(int index = -1);
  void add_exp(const std::string &s, RegExpFormatter *f);
  void freeze() throw(boost::bad_expression);
  void add_normal_formatter(RegExpFormatter *f);
  RegExpFormatter *getLastFormatter() const { return (*formatters)[formatters->size()-1];}
};

#endif
