//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "regexpstate.h"

#include "keys.h"
#include "messages.h"

#include <stdlib.h>

using namespace std;

RegExpFormatter::RegExpFormatter(const string &el, RegExpState *r, bool exit, bool all) :
    elem(el), next_state(r), exit_state(exit), exit_all(all) 
{
}

// TODO destructor?

const string &
RegExpState::get_elem(int index) 
{
  return (*formatters)[(index<0 ? current_formatter : index)]->elem;  
}

void 
RegExpState::add_exp(const std::string &s, RegExpFormatter *f)
{
  const string &ex = buffer.str();
  if (ex.size())
    buffer << "|";
  
  buffer << s;
  
  if (! formatters)
    formatters = new format_vector(0);
    
  formatters->push_back(f);
}

void 
RegExpState::freeze() throw(boost::bad_expression)
{
  const string &buffered = buffer.str();
  try {
    reg_exp.assign(buffered);
  } catch (boost::bad_expression &e) {
    printError("bad expression: " + buffered);
    throw e;
  }
}

void 
RegExpState::add_normal_formatter(RegExpFormatter *f)
{
  if (! formatters)
    formatters = new format_vector(0);
  
  formatters->push_back(0); // make sure there's room  
  (*formatters)[0] = f;
}
