/*
  File autogenerated by gengetopt version 2.13rc1
  generated with the following command:
  /home/bettini/usr/local/bin/gengetopt --input cmdline.ggo --unamed-opts --no-handle-help --no-handle-version 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->input_given = 0 ;
  args_info->output_given = 0 ;
  args_info->src_lang_given = 0 ;
  args_info->lang_list_given = 0 ;
  args_info->out_format_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->doc_given = 0 ;
  args_info->no_doc_given = 0 ;
  args_info->css_given = 0 ;
  args_info->title_given = 0 ;
  args_info->tab_given = 0 ;
  args_info->header_given = 0 ;
  args_info->footer_given = 0 ;
  args_info->tags_file_given = 0 ;
  args_info->line_number_given = 0 ;
  args_info->line_number_ref_given = 0 ;
  args_info->output_dir_given = 0 ;
  args_info->gen_version_given = 0 ;
  args_info->lang_def_given = 0 ;
  args_info->lang_map_given = 0 ;
  args_info->data_dir_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->input_arg = NULL;
  args_info->output_arg = NULL;
  args_info->src_lang_arg = NULL;
  args_info->out_format_arg = gengetopt_strdup ("html");
  args_info->css_arg = NULL;
  args_info->title_arg = NULL;
  args_info->header_arg = NULL;
  args_info->footer_arg = NULL;
  args_info->tags_file_arg = gengetopt_strdup ("tags.j2h");
  args_info->output_dir_arg = NULL;
  args_info->gen_version_flag = 1;
  args_info->lang_def_arg = NULL;
  args_info->lang_map_arg = gengetopt_strdup ("lang.map");
  args_info->data_dir_arg = NULL;
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n%s\n", "Highlight the syntax of a source file (e.g. Java) into a specific format (e.g. \nHTML)");
  printf("\nUsage: %s [OPTIONS]... [FILES]...\n\n", CMDLINE_PARSER_PACKAGE);
  printf("%s\n","  -h, --help               Print help and exit");
  printf("%s\n","  -V, --version            Print version and exit");
  printf("%s\n","  -i, --input=STRING       input file. default std input");
  printf("%s\n","  -o, --output=STRING      output file. default std output");
  printf("%s\n","  -s, --src-lang=STRING    source language (use --lang-list to get the complete \n                             list).   If not specified, the source language \n                             will be guessed from the file extension.");
  printf("%s\n","      --lang-list          list all the supported language and associated \n                             language definition file");
  printf("%s\n","  -f, --out-format=STRING  output format (e.g. html, xhtml, esc)  \n                             (default=`html')");
  printf("%s\n","  -v, --verbose            verbose mode on");
  printf("%s\n","  -d, --doc                create html with title and header");
  printf("%s\n","      --no-doc             cancel the --doc option even if it is implied (e.g., \n                             when css is given)");
  printf("%s\n","  -c, --css=STRING         use a css for formatting. Implies --doc");
  printf("%s\n","  -T, --title=STRING       give a title to the html. Implies --doc");
  printf("%s\n","  -t, --tab=INT            specify tab length. default 8");
  printf("%s\n","  -H, --header=STRING      file to insert as header");
  printf("%s\n","  -F, --footer=STRING      file to insert as footer");
  printf("%s\n","      --tags-file=STRING   specify format options  (default=`tags.j2h')");
  printf("%s\n","  -n, --line-number        number all output lines");
  printf("%s\n","      --line-number-ref    number all output lines and generate an anchor that \n                             can be referred to from another document");
  printf("%s\n","      --output-dir=STRING  output directory");
  printf("%s\n","      --gen-version        put source-highlight version in the generated file  \n                             (default=on)");
  printf("%s\n","      --lang-def=STRING    language definition file");
  printf("%s\n","      --lang-map=STRING    language map file  (default=`lang.map')");
  printf("%s\n","      --data-dir=PATH      directory where language definition files and \n                             language map are searched for.  If not specified \n                             these files are searched for in the current \n                             directory and in the data dir installation \n                             directory");
  
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->input_arg)
    {
      free (args_info->input_arg); /* free previous argument */
      args_info->input_arg = 0;
    }
  if (args_info->output_arg)
    {
      free (args_info->output_arg); /* free previous argument */
      args_info->output_arg = 0;
    }
  if (args_info->src_lang_arg)
    {
      free (args_info->src_lang_arg); /* free previous argument */
      args_info->src_lang_arg = 0;
    }
  if (args_info->out_format_arg)
    {
      free (args_info->out_format_arg); /* free previous argument */
      args_info->out_format_arg = 0;
    }
  if (args_info->css_arg)
    {
      free (args_info->css_arg); /* free previous argument */
      args_info->css_arg = 0;
    }
  if (args_info->title_arg)
    {
      free (args_info->title_arg); /* free previous argument */
      args_info->title_arg = 0;
    }
  if (args_info->header_arg)
    {
      free (args_info->header_arg); /* free previous argument */
      args_info->header_arg = 0;
    }
  if (args_info->footer_arg)
    {
      free (args_info->footer_arg); /* free previous argument */
      args_info->footer_arg = 0;
    }
  if (args_info->tags_file_arg)
    {
      free (args_info->tags_file_arg); /* free previous argument */
      args_info->tags_file_arg = 0;
    }
  if (args_info->output_dir_arg)
    {
      free (args_info->output_dir_arg); /* free previous argument */
      args_info->output_dir_arg = 0;
    }
  if (args_info->lang_def_arg)
    {
      free (args_info->lang_def_arg); /* free previous argument */
      args_info->lang_def_arg = 0;
    }
  if (args_info->lang_map_arg)
    {
      free (args_info->lang_map_arg); /* free previous argument */
      args_info->lang_map_arg = 0;
    }
  if (args_info->data_dir_arg)
    {
      free (args_info->data_dir_arg); /* free previous argument */
      args_info->data_dir_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "input",	1, NULL, 'i' },
        { "output",	1, NULL, 'o' },
        { "src-lang",	1, NULL, 's' },
        { "lang-list",	0, NULL, 0 },
        { "out-format",	1, NULL, 'f' },
        { "verbose",	0, NULL, 'v' },
        { "doc",	0, NULL, 'd' },
        { "no-doc",	0, NULL, 0 },
        { "css",	1, NULL, 'c' },
        { "title",	1, NULL, 'T' },
        { "tab",	1, NULL, 't' },
        { "header",	1, NULL, 'H' },
        { "footer",	1, NULL, 'F' },
        { "tags-file",	1, NULL, 0 },
        { "line-number",	0, NULL, 'n' },
        { "line-number-ref",	0, NULL, 0 },
        { "output-dir",	1, NULL, 0 },
        { "gen-version",	0, NULL, 0 },
        { "lang-def",	1, NULL, 0 },
        { "lang-map",	1, NULL, 0 },
        { "data-dir",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVi:o:s:f:vdc:T:t:H:F:n", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (local_args_info.help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->help_given && ! override)
            continue;
          local_args_info.help_given = 1;
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          if (local_args_info.version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->version_given && ! override)
            continue;
          local_args_info.version_given = 1;
          args_info->version_given = 1;
          return 0;

        case 'i':	/* input file. default std input.  */
          if (local_args_info.input_given)
            {
              fprintf (stderr, "%s: `--input' (`-i') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->input_given && ! override)
            continue;
          local_args_info.input_given = 1;
          args_info->input_given = 1;
          if (args_info->input_arg)
            free (args_info->input_arg); /* free previous string */
          args_info->input_arg = gengetopt_strdup (optarg);
          break;

        case 'o':	/* output file. default std output.  */
          if (local_args_info.output_given)
            {
              fprintf (stderr, "%s: `--output' (`-o') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->output_given && ! override)
            continue;
          local_args_info.output_given = 1;
          args_info->output_given = 1;
          if (args_info->output_arg)
            free (args_info->output_arg); /* free previous string */
          args_info->output_arg = gengetopt_strdup (optarg);
          break;

        case 's':	/* source language (use --lang-list to get the complete list).   If not specified, the source language will be guessed from the file extension..  */
          if (local_args_info.src_lang_given)
            {
              fprintf (stderr, "%s: `--src-lang' (`-s') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->src_lang_given && ! override)
            continue;
          local_args_info.src_lang_given = 1;
          args_info->src_lang_given = 1;
          if (args_info->src_lang_arg)
            free (args_info->src_lang_arg); /* free previous string */
          args_info->src_lang_arg = gengetopt_strdup (optarg);
          break;

        case 'f':	/* output format (e.g. html, xhtml, esc).  */
          if (local_args_info.out_format_given)
            {
              fprintf (stderr, "%s: `--out-format' (`-f') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->out_format_given && ! override)
            continue;
          local_args_info.out_format_given = 1;
          args_info->out_format_given = 1;
          if (args_info->out_format_arg)
            free (args_info->out_format_arg); /* free previous string */
          args_info->out_format_arg = gengetopt_strdup (optarg);
          break;

        case 'v':	/* verbose mode on.  */
          if (local_args_info.verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->verbose_given && ! override)
            continue;
          local_args_info.verbose_given = 1;
          args_info->verbose_given = 1;
          break;

        case 'd':	/* create html with title and header.  */
          if (local_args_info.doc_given)
            {
              fprintf (stderr, "%s: `--doc' (`-d') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->doc_given && ! override)
            continue;
          local_args_info.doc_given = 1;
          args_info->doc_given = 1;
          break;

        case 'c':	/* use a css for formatting. Implies --doc.  */
          if (local_args_info.css_given)
            {
              fprintf (stderr, "%s: `--css' (`-c') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->css_given && ! override)
            continue;
          local_args_info.css_given = 1;
          args_info->css_given = 1;
          if (args_info->css_arg)
            free (args_info->css_arg); /* free previous string */
          args_info->css_arg = gengetopt_strdup (optarg);
          break;

        case 'T':	/* give a title to the html. Implies --doc.  */
          if (local_args_info.title_given)
            {
              fprintf (stderr, "%s: `--title' (`-T') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->title_given && ! override)
            continue;
          local_args_info.title_given = 1;
          args_info->title_given = 1;
          if (args_info->title_arg)
            free (args_info->title_arg); /* free previous string */
          args_info->title_arg = gengetopt_strdup (optarg);
          break;

        case 't':	/* specify tab length. default 8.  */
          if (local_args_info.tab_given)
            {
              fprintf (stderr, "%s: `--tab' (`-t') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->tab_given && ! override)
            continue;
          local_args_info.tab_given = 1;
          args_info->tab_given = 1;
          args_info->tab_arg = strtol (optarg,&stop_char,0);
          break;

        case 'H':	/* file to insert as header.  */
          if (local_args_info.header_given)
            {
              fprintf (stderr, "%s: `--header' (`-H') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->header_given && ! override)
            continue;
          local_args_info.header_given = 1;
          args_info->header_given = 1;
          if (args_info->header_arg)
            free (args_info->header_arg); /* free previous string */
          args_info->header_arg = gengetopt_strdup (optarg);
          break;

        case 'F':	/* file to insert as footer.  */
          if (local_args_info.footer_given)
            {
              fprintf (stderr, "%s: `--footer' (`-F') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->footer_given && ! override)
            continue;
          local_args_info.footer_given = 1;
          args_info->footer_given = 1;
          if (args_info->footer_arg)
            free (args_info->footer_arg); /* free previous string */
          args_info->footer_arg = gengetopt_strdup (optarg);
          break;

        case 'n':	/* number all output lines.  */
          if (local_args_info.line_number_given)
            {
              fprintf (stderr, "%s: `--line-number' (`-n') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->line_number_given && ! override)
            continue;
          local_args_info.line_number_given = 1;
          args_info->line_number_given = 1;
          break;


        case 0:	/* Long option with no short option */
          /* list all the supported language and associated language definition file.  */
          if (strcmp (long_options[option_index].name, "lang-list") == 0)
          {
            if (local_args_info.lang_list_given)
              {
                fprintf (stderr, "%s: `--lang-list' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->lang_list_given && ! override)
              continue;
            local_args_info.lang_list_given = 1;
            args_info->lang_list_given = 1;
            break;
          }
          /* cancel the --doc option even if it is implied (e.g., when css is given).  */
          else if (strcmp (long_options[option_index].name, "no-doc") == 0)
          {
            if (local_args_info.no_doc_given)
              {
                fprintf (stderr, "%s: `--no-doc' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->no_doc_given && ! override)
              continue;
            local_args_info.no_doc_given = 1;
            args_info->no_doc_given = 1;
            break;
          }
          /* specify format options.  */
          else if (strcmp (long_options[option_index].name, "tags-file") == 0)
          {
            if (local_args_info.tags_file_given)
              {
                fprintf (stderr, "%s: `--tags-file' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->tags_file_given && ! override)
              continue;
            local_args_info.tags_file_given = 1;
            args_info->tags_file_given = 1;
            if (args_info->tags_file_arg)
              free (args_info->tags_file_arg); /* free previous string */
            args_info->tags_file_arg = gengetopt_strdup (optarg);
          }
          /* number all output lines and generate an anchor that can be referred to from another document.  */
          else if (strcmp (long_options[option_index].name, "line-number-ref") == 0)
          {
            if (local_args_info.line_number_ref_given)
              {
                fprintf (stderr, "%s: `--line-number-ref' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->line_number_ref_given && ! override)
              continue;
            local_args_info.line_number_ref_given = 1;
            args_info->line_number_ref_given = 1;
            break;
          }
          /* output directory.  */
          else if (strcmp (long_options[option_index].name, "output-dir") == 0)
          {
            if (local_args_info.output_dir_given)
              {
                fprintf (stderr, "%s: `--output-dir' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->output_dir_given && ! override)
              continue;
            local_args_info.output_dir_given = 1;
            args_info->output_dir_given = 1;
            if (args_info->output_dir_arg)
              free (args_info->output_dir_arg); /* free previous string */
            args_info->output_dir_arg = gengetopt_strdup (optarg);
          }
          /* put source-highlight version in the generated file.  */
          else if (strcmp (long_options[option_index].name, "gen-version") == 0)
          {
            if (local_args_info.gen_version_given)
              {
                fprintf (stderr, "%s: `--gen-version' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->gen_version_given && ! override)
              continue;
            local_args_info.gen_version_given = 1;
            args_info->gen_version_given = 1;
            args_info->gen_version_flag = !(args_info->gen_version_flag);
          }
          /* language definition file.  */
          else if (strcmp (long_options[option_index].name, "lang-def") == 0)
          {
            if (local_args_info.lang_def_given)
              {
                fprintf (stderr, "%s: `--lang-def' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->lang_def_given && ! override)
              continue;
            local_args_info.lang_def_given = 1;
            args_info->lang_def_given = 1;
            if (args_info->lang_def_arg)
              free (args_info->lang_def_arg); /* free previous string */
            args_info->lang_def_arg = gengetopt_strdup (optarg);
          }
          /* language map file.  */
          else if (strcmp (long_options[option_index].name, "lang-map") == 0)
          {
            if (local_args_info.lang_map_given)
              {
                fprintf (stderr, "%s: `--lang-map' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->lang_map_given && ! override)
              continue;
            local_args_info.lang_map_given = 1;
            args_info->lang_map_given = 1;
            if (args_info->lang_map_arg)
              free (args_info->lang_map_arg); /* free previous string */
            args_info->lang_map_arg = gengetopt_strdup (optarg);
          }
          /* directory where language definition files and language map are searched for.  If not specified these files are searched for in the current directory and in the data dir installation directory.  */
          else if (strcmp (long_options[option_index].name, "data-dir") == 0)
          {
            if (local_args_info.data_dir_given)
              {
                fprintf (stderr, "%s: `--data-dir' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->data_dir_given && ! override)
              continue;
            local_args_info.data_dir_given = 1;
            args_info->data_dir_given = 1;
            if (args_info->data_dir_arg)
              free (args_info->data_dir_arg); /* free previous string */
            args_info->data_dir_arg = gengetopt_strdup (optarg);
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  return (EXIT_FAILURE);
}
