#! /bin/sh

TEMPDIR=/tmp/pspp-tst-$$
mkdir -p $TEMPDIR
trap 'cd /; rm -rf $TEMPDIR' 0

# ensure that top_builddir  are absolute
if [ -z "$top_builddir" ] ; then top_builddir=. ; fi
if [ -z "$top_srcdir" ] ; then top_srcdir=. ; fi
top_builddir=`cd $top_builddir; pwd`
PSPP=$top_builddir/src/ui/terminal/pspp

# ensure that top_srcdir is absolute
top_srcdir=`cd $top_srcdir; pwd`

STAT_CONFIG_PATH=$top_srcdir/config
export STAT_CONFIG_PATH

fail()
{
    echo $activity
    echo FAILED
    exit 1;
}


no_result()
{
    echo $activity
    echo NO RESULT;
    exit 2;
}

pass()
{
    exit 0;
}

cd $TEMPDIR

activity="write pspp syntax"
cat > date-out.pspp <<EOF
set epoch=1930.
data list /x 1-30 (datetime).
begin data.
10-6-1648 0:0:0
30-6-1680 4:50:38.12301
24-7-1716 12:31:35.23453
19-6-1768 12:47:53.34505
2-8-1819 1:26:0.45615
27-3-1839 20:58:11.56677
19-4-1903 7:36:5.18964
25-8-1929 15:43:49.83132
29-9-1941 4:25:9.01293
19-4-1943 6:49:27.52375
7-10-1943 2:57:52.01565
17-3-1992 16:45:44.86529
25-2-1996 21:30:57.82047
29-9-41 4:25:9.15395
19-4-43 6:49:27.10533
7-10-43 2:57:52.48229
17-3-92 16:45:44.65827
25-2-96 21:30:57.58219
10-11-2038 22:30:4.18347
18-7-2094 1:56:51.59319
end data.
print outfile='date-out.out'/x(date9) ' | ' x(date11).
print outfile='date-out.out'/x(adate8) ' | ' x(adate10).
print outfile='date-out.out'/x(edate8) ' | ' x(edate10).
print outfile='date-out.out'/x(jdate5) ' | ' x(jdate7).
print outfile='date-out.out'/x(sdate8) ' | ' x(sdate10).
print outfile='date-out.out'/x(qyr6) ' | ' x(qyr8).
print outfile='date-out.out'/x(moyr6) ' | ' x(moyr8).
print outfile='date-out.out'/x(wkyr8) ' | ' x(wkyr10).
print outfile='date-out.out'/x(datetime17).
print outfile='date-out.out'/x(datetime18).
print outfile='date-out.out'/x(datetime19).
print outfile='date-out.out'/x(datetime20).
print outfile='date-out.out'/x(datetime21).
print outfile='date-out.out'/x(datetime22).
print outfile='date-out.out'/x(datetime22.1).
print outfile='date-out.out'/x(datetime23.2).
print outfile='date-out.out'/x(datetime24.3).
print outfile='date-out.out'/x(datetime25.4).
print outfile='date-out.out'/x(datetime26.5).
execute.
EOF
if [ $? -ne 0 ] ; then no_result ; fi

activity="run program"
$SUPERVISOR $PSPP --testing-mode date-out.pspp
if [ $? -ne 0 ] ; then no_result ; fi

activity="compare output"
diff -u date-out.out - <<EOF 
 ********* | 10-JUN-1648
 ******** | 06/10/1648
 ******** | 10.06.1648
 ***** | 1648162
 ******** | 1648/06/10
 ****** | 2 Q 1648
 ****** | JUN 1648
 ******** | 24 WK 1648
 10-JUN-1648 00:00
  10-JUN-1648 00:00
   10-JUN-1648 00:00
 10-JUN-1648 00:00:00
  10-JUN-1648 00:00:00
   10-JUN-1648 00:00:00
 10-JUN-1648 00:00:00.0
 10-JUN-1648 00:00:00.00
 10-JUN-1648 00:00:00.000
 10-JUN-1648 00:00:00.0000
 10-JUN-1648 00:00:00.00000
 ********* | 30-JUN-1680
 ******** | 06/30/1680
 ******** | 30.06.1680
 ***** | 1680182
 ******** | 1680/06/30
 ****** | 2 Q 1680
 ****** | JUN 1680
 ******** | 26 WK 1680
 30-JUN-1680 04:50
  30-JUN-1680 04:50
   30-JUN-1680 04:50
 30-JUN-1680 04:50:38
  30-JUN-1680 04:50:38
   30-JUN-1680 04:50:38
 30-JUN-1680 04:50:38.1
 30-JUN-1680 04:50:38.12
 30-JUN-1680 04:50:38.123
 30-JUN-1680 04:50:38.1230
 30-JUN-1680 04:50:38.12301
 ********* | 24-JUL-1716
 ******** | 07/24/1716
 ******** | 24.07.1716
 ***** | 1716206
 ******** | 1716/07/24
 ****** | 3 Q 1716
 ****** | JUL 1716
 ******** | 30 WK 1716
 24-JUL-1716 12:31
  24-JUL-1716 12:31
   24-JUL-1716 12:31
 24-JUL-1716 12:31:35
  24-JUL-1716 12:31:35
   24-JUL-1716 12:31:35
 24-JUL-1716 12:31:35.2
 24-JUL-1716 12:31:35.23
 24-JUL-1716 12:31:35.235
 24-JUL-1716 12:31:35.2345
 24-JUL-1716 12:31:35.23453
 ********* | 19-JUN-1768
 ******** | 06/19/1768
 ******** | 19.06.1768
 ***** | 1768171
 ******** | 1768/06/19
 ****** | 2 Q 1768
 ****** | JUN 1768
 ******** | 25 WK 1768
 19-JUN-1768 12:47
  19-JUN-1768 12:47
   19-JUN-1768 12:47
 19-JUN-1768 12:47:53
  19-JUN-1768 12:47:53
   19-JUN-1768 12:47:53
 19-JUN-1768 12:47:53.3
 19-JUN-1768 12:47:53.35
 19-JUN-1768 12:47:53.345
 19-JUN-1768 12:47:53.3450
 19-JUN-1768 12:47:53.34505
 ********* | 02-AUG-1819
 ******** | 08/02/1819
 ******** | 02.08.1819
 ***** | 1819214
 ******** | 1819/08/02
 ****** | 3 Q 1819
 ****** | AUG 1819
 ******** | 31 WK 1819
 02-AUG-1819 01:26
  02-AUG-1819 01:26
   02-AUG-1819 01:26
 02-AUG-1819 01:26:00
  02-AUG-1819 01:26:00
   02-AUG-1819 01:26:00
 02-AUG-1819 01:26:00.5
 02-AUG-1819 01:26:00.46
 02-AUG-1819 01:26:00.456
 02-AUG-1819 01:26:00.4562
 02-AUG-1819 01:26:00.45615
 ********* | 27-MAR-1839
 ******** | 03/27/1839
 ******** | 27.03.1839
 ***** | 1839086
 ******** | 1839/03/27
 ****** | 1 Q 1839
 ****** | MAR 1839
 ******** | 13 WK 1839
 27-MAR-1839 20:58
  27-MAR-1839 20:58
   27-MAR-1839 20:58
 27-MAR-1839 20:58:11
  27-MAR-1839 20:58:11
   27-MAR-1839 20:58:11
 27-MAR-1839 20:58:11.6
 27-MAR-1839 20:58:11.57
 27-MAR-1839 20:58:11.567
 27-MAR-1839 20:58:11.5668
 27-MAR-1839 20:58:11.56677
 ********* | 19-APR-1903
 ******** | 04/19/1903
 ******** | 19.04.1903
 ***** | 1903109
 ******** | 1903/04/19
 ****** | 2 Q 1903
 ****** | APR 1903
 ******** | 16 WK 1903
 19-APR-1903 07:36
  19-APR-1903 07:36
   19-APR-1903 07:36
 19-APR-1903 07:36:05
  19-APR-1903 07:36:05
   19-APR-1903 07:36:05
 19-APR-1903 07:36:05.2
 19-APR-1903 07:36:05.19
 19-APR-1903 07:36:05.190
 19-APR-1903 07:36:05.1896
 19-APR-1903 07:36:05.18964
 ********* | 25-AUG-1929
 ******** | 08/25/1929
 ******** | 25.08.1929
 ***** | 1929237
 ******** | 1929/08/25
 ****** | 3 Q 1929
 ****** | AUG 1929
 ******** | 34 WK 1929
 25-AUG-1929 15:43
  25-AUG-1929 15:43
   25-AUG-1929 15:43
 25-AUG-1929 15:43:49
  25-AUG-1929 15:43:49
   25-AUG-1929 15:43:49
 25-AUG-1929 15:43:49.8
 25-AUG-1929 15:43:49.83
 25-AUG-1929 15:43:49.831
 25-AUG-1929 15:43:49.8313
 25-AUG-1929 15:43:49.83132
 29-SEP-41 | 29-SEP-1941
 09/29/41 | 09/29/1941
 29.09.41 | 29.09.1941
 41272 | 1941272
 41/09/29 | 1941/09/29
 3 Q 41 | 3 Q 1941
 SEP 41 | SEP 1941
 39 WK 41 | 39 WK 1941
 29-SEP-1941 04:25
  29-SEP-1941 04:25
   29-SEP-1941 04:25
 29-SEP-1941 04:25:09
  29-SEP-1941 04:25:09
   29-SEP-1941 04:25:09
 29-SEP-1941 04:25:09.0
 29-SEP-1941 04:25:09.01
 29-SEP-1941 04:25:09.013
 29-SEP-1941 04:25:09.0129
 29-SEP-1941 04:25:09.01293
 19-APR-43 | 19-APR-1943
 04/19/43 | 04/19/1943
 19.04.43 | 19.04.1943
 43109 | 1943109
 43/04/19 | 1943/04/19
 2 Q 43 | 2 Q 1943
 APR 43 | APR 1943
 16 WK 43 | 16 WK 1943
 19-APR-1943 06:49
  19-APR-1943 06:49
   19-APR-1943 06:49
 19-APR-1943 06:49:27
  19-APR-1943 06:49:27
   19-APR-1943 06:49:27
 19-APR-1943 06:49:27.5
 19-APR-1943 06:49:27.52
 19-APR-1943 06:49:27.524
 19-APR-1943 06:49:27.5238
 19-APR-1943 06:49:27.52375
 07-OCT-43 | 07-OCT-1943
 10/07/43 | 10/07/1943
 07.10.43 | 07.10.1943
 43280 | 1943280
 43/10/07 | 1943/10/07
 4 Q 43 | 4 Q 1943
 OCT 43 | OCT 1943
 40 WK 43 | 40 WK 1943
 07-OCT-1943 02:57
  07-OCT-1943 02:57
   07-OCT-1943 02:57
 07-OCT-1943 02:57:52
  07-OCT-1943 02:57:52
   07-OCT-1943 02:57:52
 07-OCT-1943 02:57:52.0
 07-OCT-1943 02:57:52.02
 07-OCT-1943 02:57:52.016
 07-OCT-1943 02:57:52.0156
 07-OCT-1943 02:57:52.01565
 17-MAR-92 | 17-MAR-1992
 03/17/92 | 03/17/1992
 17.03.92 | 17.03.1992
 92077 | 1992077
 92/03/17 | 1992/03/17
 1 Q 92 | 1 Q 1992
 MAR 92 | MAR 1992
 11 WK 92 | 11 WK 1992
 17-MAR-1992 16:45
  17-MAR-1992 16:45
   17-MAR-1992 16:45
 17-MAR-1992 16:45:44
  17-MAR-1992 16:45:44
   17-MAR-1992 16:45:44
 17-MAR-1992 16:45:44.9
 17-MAR-1992 16:45:44.87
 17-MAR-1992 16:45:44.865
 17-MAR-1992 16:45:44.8653
 17-MAR-1992 16:45:44.86529
 25-FEB-96 | 25-FEB-1996
 02/25/96 | 02/25/1996
 25.02.96 | 25.02.1996
 96056 | 1996056
 96/02/25 | 1996/02/25
 1 Q 96 | 1 Q 1996
 FEB 96 | FEB 1996
  8 WK 96 |  8 WK 1996
 25-FEB-1996 21:30
  25-FEB-1996 21:30
   25-FEB-1996 21:30
 25-FEB-1996 21:30:57
  25-FEB-1996 21:30:57
   25-FEB-1996 21:30:57
 25-FEB-1996 21:30:57.8
 25-FEB-1996 21:30:57.82
 25-FEB-1996 21:30:57.820
 25-FEB-1996 21:30:57.8205
 25-FEB-1996 21:30:57.82047
 29-SEP-41 | 29-SEP-1941
 09/29/41 | 09/29/1941
 29.09.41 | 29.09.1941
 41272 | 1941272
 41/09/29 | 1941/09/29
 3 Q 41 | 3 Q 1941
 SEP 41 | SEP 1941
 39 WK 41 | 39 WK 1941
 29-SEP-1941 04:25
  29-SEP-1941 04:25
   29-SEP-1941 04:25
 29-SEP-1941 04:25:09
  29-SEP-1941 04:25:09
   29-SEP-1941 04:25:09
 29-SEP-1941 04:25:09.2
 29-SEP-1941 04:25:09.15
 29-SEP-1941 04:25:09.154
 29-SEP-1941 04:25:09.1539
 29-SEP-1941 04:25:09.15395
 19-APR-43 | 19-APR-1943
 04/19/43 | 04/19/1943
 19.04.43 | 19.04.1943
 43109 | 1943109
 43/04/19 | 1943/04/19
 2 Q 43 | 2 Q 1943
 APR 43 | APR 1943
 16 WK 43 | 16 WK 1943
 19-APR-1943 06:49
  19-APR-1943 06:49
   19-APR-1943 06:49
 19-APR-1943 06:49:27
  19-APR-1943 06:49:27
   19-APR-1943 06:49:27
 19-APR-1943 06:49:27.1
 19-APR-1943 06:49:27.11
 19-APR-1943 06:49:27.105
 19-APR-1943 06:49:27.1053
 19-APR-1943 06:49:27.10533
 07-OCT-43 | 07-OCT-1943
 10/07/43 | 10/07/1943
 07.10.43 | 07.10.1943
 43280 | 1943280
 43/10/07 | 1943/10/07
 4 Q 43 | 4 Q 1943
 OCT 43 | OCT 1943
 40 WK 43 | 40 WK 1943
 07-OCT-1943 02:57
  07-OCT-1943 02:57
   07-OCT-1943 02:57
 07-OCT-1943 02:57:52
  07-OCT-1943 02:57:52
   07-OCT-1943 02:57:52
 07-OCT-1943 02:57:52.5
 07-OCT-1943 02:57:52.48
 07-OCT-1943 02:57:52.482
 07-OCT-1943 02:57:52.4823
 07-OCT-1943 02:57:52.48229
 17-MAR-92 | 17-MAR-1992
 03/17/92 | 03/17/1992
 17.03.92 | 17.03.1992
 92077 | 1992077
 92/03/17 | 1992/03/17
 1 Q 92 | 1 Q 1992
 MAR 92 | MAR 1992
 11 WK 92 | 11 WK 1992
 17-MAR-1992 16:45
  17-MAR-1992 16:45
   17-MAR-1992 16:45
 17-MAR-1992 16:45:44
  17-MAR-1992 16:45:44
   17-MAR-1992 16:45:44
 17-MAR-1992 16:45:44.7
 17-MAR-1992 16:45:44.66
 17-MAR-1992 16:45:44.658
 17-MAR-1992 16:45:44.6583
 17-MAR-1992 16:45:44.65827
 25-FEB-96 | 25-FEB-1996
 02/25/96 | 02/25/1996
 25.02.96 | 25.02.1996
 96056 | 1996056
 96/02/25 | 1996/02/25
 1 Q 96 | 1 Q 1996
 FEB 96 | FEB 1996
  8 WK 96 |  8 WK 1996
 25-FEB-1996 21:30
  25-FEB-1996 21:30
   25-FEB-1996 21:30
 25-FEB-1996 21:30:57
  25-FEB-1996 21:30:57
   25-FEB-1996 21:30:57
 25-FEB-1996 21:30:57.6
 25-FEB-1996 21:30:57.58
 25-FEB-1996 21:30:57.582
 25-FEB-1996 21:30:57.5822
 25-FEB-1996 21:30:57.58219
 ********* | 10-NOV-2038
 ******** | 11/10/2038
 ******** | 10.11.2038
 ***** | 2038314
 ******** | 2038/11/10
 ****** | 4 Q 2038
 ****** | NOV 2038
 ******** | 45 WK 2038
 10-NOV-2038 22:30
  10-NOV-2038 22:30
   10-NOV-2038 22:30
 10-NOV-2038 22:30:04
  10-NOV-2038 22:30:04
   10-NOV-2038 22:30:04
 10-NOV-2038 22:30:04.2
 10-NOV-2038 22:30:04.18
 10-NOV-2038 22:30:04.183
 10-NOV-2038 22:30:04.1835
 10-NOV-2038 22:30:04.18347
 ********* | 18-JUL-2094
 ******** | 07/18/2094
 ******** | 18.07.2094
 ***** | 2094199
 ******** | 2094/07/18
 ****** | 3 Q 2094
 ****** | JUL 2094
 ******** | 29 WK 2094
 18-JUL-2094 01:56
  18-JUL-2094 01:56
   18-JUL-2094 01:56
 18-JUL-2094 01:56:51
  18-JUL-2094 01:56:51
   18-JUL-2094 01:56:51
 18-JUL-2094 01:56:51.6
 18-JUL-2094 01:56:51.59
 18-JUL-2094 01:56:51.593
 18-JUL-2094 01:56:51.5932
 18-JUL-2094 01:56:51.59319
EOF
if [ $? -ne 0 ] ; then fail ; fi

activity="write pspp syntax"
cat > bad-date-out.pspp <<EOF
set epoch=1930.
set errors=none.
data list list /x.
begin data.
0
-1
3e11
end data.
print outfile='bad-date.out'/x(date9) ' | ' x(date11).
print outfile='bad-date.out'/x(adate8) ' | ' x(adate10).
print outfile='bad-date.out'/x(edate8) ' | ' x(edate10).
print outfile='bad-date.out'/x(jdate5) ' | ' x(jdate7).
print outfile='bad-date.out'/x(sdate8) ' | ' x(sdate10).
print outfile='bad-date.out'/x(qyr6) ' | ' x(qyr8).
print outfile='bad-date.out'/x(moyr6) ' | ' x(moyr8).
print outfile='bad-date.out'/x(wkyr8) ' | ' x(wkyr10).
print outfile='bad-date.out'/x(datetime17).
print outfile='bad-date.out'/x(datetime18).
print outfile='bad-date.out'/x(datetime19).
print outfile='bad-date.out'/x(datetime20).
print outfile='bad-date.out'/x(datetime21).
print outfile='bad-date.out'/x(datetime22).
print outfile='bad-date.out'/x(datetime22.1).
print outfile='bad-date.out'/x(datetime23.2).
print outfile='bad-date.out'/x(datetime24.3).
print outfile='bad-date.out'/x(datetime25.4).
print outfile='bad-date.out'/x(datetime26.5).
execute.
EOF
if [ $? -ne 0 ] ; then no_result ; fi

activity="run program"
$SUPERVISOR $PSPP --testing-mode bad-date-out.pspp
if [ $? -ne 0 ] ; then no_result ; fi

activity="compare output"
diff -u bad-date.out - <<EOF 
         . |           .
        . |          .
        . |          .
     . |       .
        . |          .
      . |        .
      . |        .
        . |          .
                 .
                  .
                   .
                    .
                     .
                      .
                     . 
                     .  
                     .   
                     .    
                     .     
         . |           .
        . |          .
        . |          .
     . |       .
        . |          .
      . |        .
      . |        .
        . |          .
                 .
                  .
                   .
                    .
                     .
                      .
                     . 
                     .  
                     .   
                     .    
                     .     
 ********* | ***********
 ******** | **********
 ******** | **********
 ***** | *******
 ******** | **********
 ****** | ********
 ****** | ********
 ******** | **********
 28-MAY-**** 05:20
  28-MAY-**** 05:20
   28-MAY-**** 05:20
 28-MAY-**** 05:20:00
  28-MAY-**** 05:20:00
   28-MAY-**** 05:20:00
 28-MAY-**** 05:20:00.0
 28-MAY-**** 05:20:00.00
 28-MAY-**** 05:20:00.000
 28-MAY-**** 05:20:00.0000
 28-MAY-**** 05:20:00.00000
EOF
if [ $? -ne 0 ] ; then fail ; fi

pass
