/* src/language/stats/correlations.c		-*- mode: c; buffer-read-only: t -*-

   Generated by q2c from ../src/language/stats/correlations.q.
   Do not modify!
 */
#line 1 "../src/language/stats/correlations.q"
/* PSPP - a program for statistical analysis.
   Copyright (C) 1997-9, 2000 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#include <config.h>

#include <stdlib.h>

#include <data/dictionary.h>
#include <data/file-handle-def.h>
#include <data/procedure.h>
#include <data/variable.h>
#include <language/command.h>
#include <language/data-io/file-handle.h>
#include <language/lexer/lexer.h>
#include <language/lexer/variable-parser.h>
#include <libpspp/compiler.h>

#include "xalloc.h"

#line 40 "src/language/stats/correlations.c"
#include <stdlib.h>
#include <libpspp/assertion.h>
#include <libpspp/message.h>
#include <language/lexer/lexer.h>
#include <language/lexer/variable-parser.h>
#include <data/settings.h>
#include <libpspp/str.h>
#include <language/lexer/subcommand-list.h>
#include <data/variable.h>

#include "xalloc.h"

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 34 "../src/language/stats/correlations.q"

struct cor_set
  {
    struct cor_set *next;
    const struct variable **v1, **v2;
    size_t nv1, nv2;
  };

static struct cor_set *cor_list, *cor_last;

static struct file_handle *matrix_file;

static void free_correlations_state (void);
static int internal_cmd_correlations (struct lexer *lexer, struct dataset *ds);

int
cmd_correlations (struct lexer *lexer, struct dataset *ds)
{
  int result = internal_cmd_correlations (lexer, ds);
  free_correlations_state ();
  return result;
}

#line 80 "src/language/stats/correlations.c"
#line 68 "../src/language/stats/correlations.q"
#line 82 "src/language/stats/correlations.c"
struct dataset;
/* Settings for subcommand specifiers. */
enum
  {
    COR_PAIRWISE = 1000,
    COR_LISTWISE,
    COR_INCLUDE,
    COR_EXCLUDE,
    COR_TWOTAIL,
    COR_ONETAIL,
    COR_SIG,
    COR_NOSIG,
    COR_MATRIX,
    COR_SERIAL
  };

#define MAXLISTS 10
/* Array indices for STATISTICS subcommand. */
enum
  {
    COR_ST_DESCRIPTIVES = 0,
    COR_ST_XPROD = 1,
    COR_ST_ALL = 2,
    COR_ST_count
  };

/* CORRELATIONS structure. */
struct cmd_correlations
  {
    /* VARIABLES subcommand. */
    int sbc_variables;
    
    /* MISSING subcommand. */
    int sbc_missing;
    long miss;
    long inc;
    
    /* PRINT subcommand. */
    int sbc_print;
    long tail;
    long sig;
    
    /* FORMAT subcommand. */
    int sbc_format;
    long fmt;
    
    /* MATRIX subcommand. */
    int sbc_matrix;
    
    /* STATISTICS subcommand. */
    int sbc_statistics;
    int a_statistics[COR_ST_count];
  };

/* Prototype for custom subcommands of CORRELATIONS. */
static int cor_custom_variables (struct lexer *, struct dataset *, struct cmd_correlations *, void *);
static int cor_custom_matrix (struct lexer *, struct dataset *, struct cmd_correlations *, void *);

/* Command parsing functions. */
static int parse_correlations (struct lexer *, struct dataset *, struct cmd_correlations *, void *);
static void free_correlations (struct cmd_correlations *);

#line 69 "../src/language/stats/correlations.q"
#line 146 "src/language/stats/correlations.c"
static int
parse_correlations (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_correlations *p, void *aux UNUSED)
{
  p->sbc_variables = 0;
  p->sbc_missing = 0;
  p->miss = COR_PAIRWISE;
  p->inc = -1;
  p->sbc_print = 0;
  p->tail = COR_TWOTAIL;
  p->sig = COR_SIG;
  p->sbc_format = 0;
  p->fmt = COR_MATRIX;
  p->sbc_matrix = 0;
  p->sbc_statistics = 0;
  memset (p->a_statistics, 0, sizeof p->a_statistics);
  for (;;)
    {
      switch (cor_custom_variables (lexer, ds, p, aux))
        {
        case 0:
          goto lossage;
        case 1:
          p->sbc_variables++;
          continue;
        case 2:
          break;
        default:
          NOT_REACHED ();
        }
      if (lex_match_id (lexer, "VARIABLES"))
        {
          lex_match (lexer, '=');
          p->sbc_variables++;
          if (p->sbc_variables > 1)
            {
              msg (SE, _("VARIABLES subcommand may be given only once."));
              goto lossage;
            }
          switch (cor_custom_variables (lexer, ds, p, aux))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (lexer, NULL);
              goto lossage;
            default:
              NOT_REACHED ();
            }
        }
      else if (lex_match_id (lexer, "MISSING"))
        {
          lex_match (lexer, '=');
          p->sbc_missing++;
          if (p->sbc_missing > 1)
            {
              msg (SE, _("MISSING subcommand may be given only once."));
              goto lossage;
            }
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if (lex_match_id (lexer, "PAIRWISE"))
                p->miss = COR_PAIRWISE;
              else if (lex_match_id (lexer, "LISTWISE"))
                p->miss = COR_LISTWISE;
              else if (lex_match_id (lexer, "INCLUDE"))
                p->inc = COR_INCLUDE;
              else if (lex_match_id (lexer, "EXCLUDE"))
                p->inc = COR_EXCLUDE;
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if (lex_match_id (lexer, "PRINT"))
        {
          lex_match (lexer, '=');
          p->sbc_print++;
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if (lex_match_id (lexer, "TWOTAIL"))
                p->tail = COR_TWOTAIL;
              else if (lex_match_id (lexer, "ONETAIL"))
                p->tail = COR_ONETAIL;
              else if (lex_match_id (lexer, "SIG"))
                p->sig = COR_SIG;
              else if (lex_match_id (lexer, "NOSIG"))
                p->sig = COR_NOSIG;
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if (lex_match_id (lexer, "FORMAT"))
        {
          lex_match (lexer, '=');
          p->sbc_format++;
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if (lex_match_id (lexer, "MATRIX"))
                p->fmt = COR_MATRIX;
              else if (lex_match_id (lexer, "SERIAL"))
                p->fmt = COR_SERIAL;
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if (lex_match_id (lexer, "MATRIX"))
        {
          lex_match (lexer, '=');
          p->sbc_matrix++;
          switch (cor_custom_matrix (lexer, ds, p, aux))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (lexer, NULL);
              goto lossage;
            default:
              NOT_REACHED ();
            }
        }
      else if (lex_match_id (lexer, "STATISTICS"))
        {
          lex_match (lexer, '=');
          p->sbc_statistics++;
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if (lex_match_id (lexer, "DESCRIPTIVES"))
                p->a_statistics[COR_ST_DESCRIPTIVES] = 1;
              else if (lex_match_id (lexer, "XPROD"))
                p->a_statistics[COR_ST_XPROD] = 1;
              else if (lex_match (lexer, T_ALL))
                p->a_statistics[COR_ST_ALL] = 1;
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if ( settings_get_syntax () != COMPATIBLE && lex_match_id(lexer, "ALGORITHM"))
        {
          lex_match (lexer, '=');
          if (lex_match_id(lexer, "COMPATIBLE"))
            settings_set_cmd_algorithm (COMPATIBLE);
          else if (lex_match_id(lexer, "ENHANCED"))
            settings_set_cmd_algorithm (ENHANCED);
          }
        if (!lex_match (lexer, '/'))
          break;
      }
    
    if (lex_token (lexer) != '.')
      {
        lex_error (lexer, _("expecting end of command"));
        goto lossage;
      }
      
  return true;
  
lossage:
  free_correlations (p);
  return false;
}

static void
free_correlations (struct cmd_correlations *p UNUSED)
{
}
#line 70 "../src/language/stats/correlations.q"

int
internal_cmd_correlations (struct lexer *lexer, struct dataset *ds)
{
  struct cmd_correlations cmd;

  cor_list = cor_last = NULL;
  matrix_file = NULL;

  if (!parse_correlations (lexer, ds, &cmd, NULL))
    {
      fh_unref (matrix_file);
      return CMD_FAILURE;
    }

  free_correlations (&cmd);
  fh_unref (matrix_file);

  return CMD_SUCCESS;
}

static int
cor_custom_variables (struct lexer *lexer, struct dataset *ds, struct cmd_correlations *cmd UNUSED, void *aux UNUSED)
{
  const struct variable **v1, **v2;
  size_t nv1, nv2;
  struct cor_set *cor;

  /* Ensure that this is a VARIABLES subcommand. */
  if (!lex_match_id (lexer, "VARIABLES")
      && (lex_token (lexer) != T_ID || dict_lookup_var (dataset_dict (ds), lex_tokid (lexer)) != NULL)
      && lex_token (lexer) != T_ALL)
    return 2;
  lex_match (lexer, '=');

  if (!parse_variables_const (lexer, dataset_dict (ds), &v1, &nv1,
			PV_NO_DUPLICATE | PV_NUMERIC))
    return 0;

  if (lex_match (lexer, T_WITH))
    {
      if (!parse_variables_const (lexer, dataset_dict (ds), &v2, &nv2,
			    PV_NO_DUPLICATE | PV_NUMERIC))
	{
	  free (v1);
	  return 0;
	}
    }
  else
    {
      nv2 = nv1;
      v2 = v1;
    }

  cor = xmalloc (sizeof *cor);
  cor->next = NULL;
  cor->v1 = v1;
  cor->v2 = v2;
  cor->nv1 = nv1;
  cor->nv2 = nv2;
  if (cor_list)
    cor_last = cor_last->next = cor;
  else
    cor_list = cor_last = cor;

  return 1;
}

static int
cor_custom_matrix (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_correlations *cmd UNUSED, void *aux UNUSED)
{
  if (!lex_force_match (lexer, '('))
    return 0;

  if (lex_match (lexer, '*'))
    matrix_file = NULL;
  else
    {
      fh_unref (matrix_file);
      matrix_file = fh_parse (lexer, FH_REF_FILE);
      if (matrix_file == NULL)
        return 0;
    }

  if (!lex_force_match (lexer, ')'))
    return 0;

  return 1;
}

static void
free_correlations_state (void)
{
  struct cor_set *cor, *next;

  for (cor = cor_list; cor != NULL; cor = next)
    {
      next = cor->next;
      if (cor->v1 != cor->v2)
	free (cor->v2);
      free (cor->v1);
      free (cor);
    }
}

/*
  Local Variables:
  mode: c
  End:
*/
