/*
CLASS:userauth_gssapi:userauth
*/
#ifndef GABA_DEFINE
struct userauth_gssapi
{
  struct userauth super;
  struct user_db *db;
};
extern struct lsh_class userauth_gssapi_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_userauth_gssapi_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct userauth_gssapi *i = (struct userauth_gssapi *) o;
  mark((struct lsh_object *) i->db);
}
struct lsh_class userauth_gssapi_class =
{
  STATIC_HEADER,
  &(userauth_class),
  "userauth_gssapi",
  sizeof(struct userauth_gssapi),
  do_userauth_gssapi_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:gssapi_server_instance:userauth_gssapi
*/
#ifndef GABA_DEFINE
struct gssapi_server_instance
{
  struct userauth_gssapi super;
  struct lsh_string *user;
  struct command_continuation *cont;
  struct user_db *db;
  struct exception_handler *e;
  gss_cred_id_t cred;
  gss_ctx_id_t ctx;
  gss_OID_desc mech;
  gss_name_t client;
};
extern struct lsh_class gssapi_server_instance_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_gssapi_server_instance_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct gssapi_server_instance *i = (struct gssapi_server_instance *) o;
  mark((struct lsh_object *) i->user);
  mark((struct lsh_object *) i->cont);
  mark((struct lsh_object *) i->db);
  mark((struct lsh_object *) i->e);
}
struct lsh_class gssapi_server_instance_class =
{
  STATIC_HEADER,
  &(userauth_gssapi_class),
  "gssapi_server_instance",
  sizeof(struct gssapi_server_instance),
  do_gssapi_server_instance_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:gssapi_finish_handler:packet_handler
*/
#ifndef GABA_DEFINE
struct gssapi_finish_handler
{
  struct packet_handler super;
  struct gssapi_server_instance *gssapi;
};
extern struct lsh_class gssapi_finish_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_gssapi_finish_handler_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct gssapi_finish_handler *i = (struct gssapi_finish_handler *) o;
  mark((struct lsh_object *) i->gssapi);
}
struct lsh_class gssapi_finish_handler_class =
{
  STATIC_HEADER,
  &(packet_handler_class),
  "gssapi_finish_handler",
  sizeof(struct gssapi_finish_handler),
  do_gssapi_finish_handler_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:gssapi_token_handler:packet_handler
*/
#ifndef GABA_DEFINE
struct gssapi_token_handler
{
  struct packet_handler super;
  struct gssapi_server_instance *gssapi;
};
extern struct lsh_class gssapi_token_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_gssapi_token_handler_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct gssapi_token_handler *i = (struct gssapi_token_handler *) o;
  mark((struct lsh_object *) i->gssapi);
}
struct lsh_class gssapi_token_handler_class =
{
  STATIC_HEADER,
  &(packet_handler_class),
  "gssapi_token_handler",
  sizeof(struct gssapi_token_handler),
  do_gssapi_token_handler_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

