# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002, 2003  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os.path, shutil, __main__
import src.configureoutput

def copy_rc_file():
    __main__.rc_copied = 0
    if src.configureoutput.WITH_GNOME:
        rc10 = os.path.expanduser("~/.gnome/solfege1.0")
        rc11 = os.path.expanduser("~/.gnome/solfege1.1")
        rc12 = os.path.expanduser("~/.gnome/solfege1.2")
    else:
        rc10 = os.path.expanduser("~/.solfegerc1.0")
        rc11 = os.path.expanduser("~/.solfegerc1.1")
        rc12 = os.path.expanduser("~/.solfegerc1.2")
    rc13 = os.path.expanduser("~/.solfegerc1.3")
    rc14 = os.path.expanduser("~/.solfegerc1.4")
    rc15 = os.path.expanduser("~/.solfegerc1.5")
    rc19 = os.path.expanduser("~/.solfegerc1.9")

    if not os.path.isfile(rc19):
        for rcfn in (rc15, rc14, rc13, rc12, rc11, rc10):
            if os.path.isfile(rcfn):
                print "rcfile: copy %s -> %s" % (rcfn, rc19)
                shutil.copy(rcfn, rc19)
                __main__.rc_copied = 1
                break
        if __main__.rc_copied:
            f = open(rc19, "r")
            s = f.read()
            f.close()
            s = s.replace('intervall', 'interval')
            f = open(rc19, "w")
            f.write(s)
            f.close()


