# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002, 2003  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

if __name__ == '__main__':
    import pygtk
    pygtk.require("2.0")
    import sys
    sys.path.append(".")

import gtk, gnome
import mpd, gu, cfg
import types

# FIXME This was not defined in gtk-types.defs yet
INPUT_ERROR=-1

class NotenameSpinButton(gtk.SpinButton):
    def __init__(self, default_value):
        #FIXME values are 10 too large to workaround problem with
        # spinbutton and input/output signals.
        adj = gtk.Adjustment(mpd.notename_to_int(default_value), 11.0, 137.0, 1.0, 12.0, 0.0)
        gtk.SpinButton.__init__(self, adj,  0, 0)
        self.set_update_policy(gtk.UPDATE_IF_VALID)
        self.connect('input', self.on_input_signal)
        self.connect('output', self.on_output_signal)
    def on_input_signal(self, spin, cob):
        valid_notename = None
        try:
            i = mpd.notename_to_int(spin.get_text())
            spin.set_value(i+10)
            return gtk.TRUE
        except:
            return INPUT_ERROR
    def on_output_signal(self, spin):
        n = spin.get_value_as_int()
        if 10 <= n <= 137:
            if spin.get_text() != mpd.int_to_notename(n-10):
                self.set_text(mpd.int_to_notename(n-10))
        return gtk.TRUE

class NotenameRangeController(object):
    def __init__(self, spin_low, spin_high, lowest_value, highest_value):
        self.g_spin_low = spin_low
        self.g_spin_low.connect('value-changed', self.on_low_changed)
        self.g_spin_high = spin_high
        self.g_spin_high.connect('value-changed', self.on_high_changed)
        self.m_lowest_value = mpd.notename_to_int(lowest_value)
        self.m_highest_value = mpd.notename_to_int(highest_value)
    def on_low_changed(self, widget):
        if widget.get_value() > self.g_spin_high.get_value():
            self.g_spin_low.set_value(self.g_spin_high.get_value())
        elif widget.get_value() < self.m_lowest_value:
            self.g_spin_low.set_value(self.m_lowest_value)
    def on_high_changed(self, widget):
        if widget.get_value() < self.g_spin_low.get_value():
            self.g_spin_high.set_value(self.g_spin_low.get_value())
        elif widget.get_value() > self.m_highest_value:
            self.g_spin_high.set_value(self.m_highest_value)

class nNotenameRangeController(NotenameRangeController, cfg.ConfigUtils):
    def __init__(self, spin_low, spin_high, lowest_value, highest_value,
                 exname, name_low, name_high):
        NotenameRangeController.__init__(self, spin_low, spin_high,
                lowest_value, highest_value)
        cfg.ConfigUtils.__init__(self, exname)
        self.m_name_low = name_low
        self.m_name_high = name_high
        self.g_spin_low.set_value(mpd.notename_to_int(self.get_string(self.m_name_low)))
        self.g_spin_high.set_value(mpd.notename_to_int(self.get_string(self.m_name_high)))
    def set_range(self, lowest_value, highest_value):
        """
        make a separate function for NotenameRangeController if we need it.
        """
        assert mpd.compare_notenames(lowest_value, highest_value) <= 0
        self.m_lowest_value = mpd.notename_to_int(lowest_value)
        self.m_highest_value = mpd.notename_to_int(highest_value)
        if self.m_lowest_value > self.g_spin_low.get_value():
            self.set_string(self.m_name_low, lowest_value)
            self.g_spin_low.set_value(self.m_lowest_value)
        if self.m_highest_value < self.g_spin_high.get_value():
            self.set_string(self.m_name_high, highest_value)
            self.g_spin_high.set_value(self.m_highest_value)

def _test():
    w = gtk.Window(gtk.WINDOW_TOPLEVEL)
    w.set_size_request(100, 100)
    vbox = gtk.VBox()
    w.add(vbox)
    adj = gtk.Adjustment(mpd.notename_to_int('c'), 1.0, 127.0, 1.0, 12.0, 0.0)
    n = NotenameSpinButton("d'")
    vbox.pack_start(n)

    hbox = gtk.HBox()
    vbox.pack_start(hbox)
    s1 = NotenameSpinButton("c")
    s2 = NotenameSpinButton("c'")
    hbox.pack_start(s1)
    hbox.pack_start(s2)
    con = NotenameRangeController(s1, s2, "c,", "c''")
    w.show_all()
    w.connect('destroy', gtk.mainquit)
    gtk.mainloop()
if __name__ == '__main__':
    _test()
