#!/usr/bin/python

# Warning: This setup.py script is *only* used to create the MS Windows
# installer. It will break on a real OS.

import glob
from distutils.core import setup
import py2exe
import src.configureoutput
import sys, os

def get_files(file_spec):
    path = os.path.normpath(file_spec)
    return filter(lambda x: not x.endswith('CVS'), glob.glob(path))

setup(name="solfege",
      version=src.configureoutput.VERSION_STRING,
      author="Tom Cato Amundsen",
      author_email="tca@gnu.org",
      url="http://www.solfege.org",
      data_files=[('graphics', get_files('graphics/*.png')),
                  ('soundcard', ['soundcard/winmidi.pyd']),
                  ('feta', get_files('feta/*.xpm')),
                  ('gnomeemu/xpm', get_files('gnomeemu/xpm/*.xpm')),
                  ('online-docs/C', get_files('online-docs/C/*.html')),
                  ('online-docs/no', get_files('online-docs/no/*.html')),
                  ('online-docs/nl', get_files('online-docs/nl/*.html')),
                  ('online-docs/png', get_files('online-docs/png/*.png')),
                  ('lesson-files', get_files('lesson-files/*')),
                  ('.', ['solfege.py', 'default.config', 'solfege.gtkrc',
                         'AUTHORS.txt', 'COPYING.txt', 'README.txt',
                         'INSTALL.txt', 'INSTALL.win32.txt', 'FAQ.txt',
                         'solfegewithconsole.bat', 'solfege.bat'])
      ],
      packages=['gnomeemu','mpd', 'src', 'soundcard'],
      scripts=["solfege.py"],
)
