dnl aclocal.m4 generated automatically by aclocal 1.4-p6

dnl Copyright (C) 1994, 1995-8, 1999, 2001 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.


# AM_PATH_PYTHON([MINIMUM-VERSION])

# tca: updated to check for python2.2

# Adds support for distributing Python modules and packages.  To
# install modules, copy them to $(pythondir), using the python_PYTHON
# automake variable.  To install a package with the same name as the
# automake package, install to $(pkgpythondir), or use the
# pkgpython_PYTHON automake variable.

# The variables $(pyexecdir) and $(pkgpyexecdir) are provided as
# locations to install python extension modules (shared libraries).
# Another macro is required to find the appropriate flags to compile
# extension modules.

# If your package is configured with a different prefix to python,
# users will have to add the install directory to the PYTHONPATH
# environment variable, or create a .pth file (see the python
# documentation for details).

# If the MINIUMUM-VERSION argument is passed, AM_PATH_PYTHON will
# cause an error if the version of python installed on the system
# doesn't meet the requirement.  MINIMUM-VERSION should consist of
# numbers and dots only.


AC_DEFUN([AM_PATH_PYTHON],
 [
  dnl Find a version of Python.  I could check for python versions 1.4
  dnl or earlier, but the default installation locations changed from
  dnl $prefix/lib/site-python in 1.4 to $prefix/lib/python1.5/site-packages
  dnl in 1.5, and I don't want to maintain that logic.

  AC_PATH_PROG(PYTHON, python2.2 python2.1 python2.0 python1.6 python1.5 python)

  dnl should we do the version check?
  ifelse([$1],[],,[
    AC_MSG_CHECKING(if Python version >= $1)
    changequote(<<, >>)dnl
    prog="
import sys, string
minver = '$1'
pyver = string.split(sys.version)[0]  # first word is version string
#minver = map(string.atoi, string.split(minver, '.'))
#pyver = map(string.atoi, string.split(pyver, '.'))
minver = string.split(minver, '.')
pyver = string.split(pyver, '.')
# we can now do comparisons on the two lists:
if pyver >= minver:
	sys.exit(0)
else:
	sys.exit(1)"
    changequote([, ])dnl
    if $PYTHON -c "$prog" 1>&AC_FD_CC 2>&AC_FD_CC
    then
      AC_MSG_RESULT(okay)
    else
      AC_MSG_ERROR(too old)
    fi
  ])

  AC_MSG_CHECKING([local Python configuration])

  dnl Query Python for its version number.  Getting [:3] seems to be
  dnl the best way to do this; it's what "site.py" does in the standard
  dnl library.  Need to change quote character because of [:3]

  AC_SUBST(PYTHON_VERSION)
  changequote(<<, >>)dnl
  PYTHON_VERSION=`$PYTHON -c "import sys; print sys.version[:3]"`
  changequote([, ])dnl


  dnl Use the values of $prefix and $exec_prefix for the corresponding
  dnl values of PYTHON_PREFIX and PYTHON_EXEC_PREFIX.  These are made
  dnl distinct variables so they can be overridden if need be.  However,
  dnl general consensus is that you shouldn't need this ability.

  AC_SUBST(PYTHON_PREFIX)
  PYTHON_PREFIX='${prefix}'

  AC_SUBST(PYTHON_EXEC_PREFIX)
  PYTHON_EXEC_PREFIX='${exec_prefix}'

  dnl At times (like when building shared libraries) you may want
  dnl to know which OS platform Python thinks this is.

  AC_SUBST(PYTHON_PLATFORM)
  PYTHON_PLATFORM=`$PYTHON -c "import sys; print sys.platform"`


  dnl Set up 4 directories:

  dnl pythondir -- where to install python scripts.  This is the
  dnl   site-packages directory, not the python standard library
  dnl   directory like in previous automake betas.  This behaviour
  dnl   is more consistent with lispdir.m4 for example.
  dnl
  dnl Also, if the package prefix isn't the same as python's prefix,
  dnl then the old $(pythondir) was pretty useless.

  AC_SUBST(pythondir)
  pythondir=$PYTHON_PREFIX"/lib/python"$PYTHON_VERSION/site-packages

  dnl pkgpythondir -- $PACKAGE directory under pythondir.  Was
  dnl   PYTHON_SITE_PACKAGE in previous betas, but this naming is
  dnl   more consistent with the rest of automake.
  dnl   Maybe this should be put in python.am?

  AC_SUBST(pkgpythondir)
  pkgpythondir=\${pythondir}/$PACKAGE

  dnl pyexecdir -- directory for installing python extension modules
  dnl   (shared libraries)  Was PYTHON_SITE_EXEC in previous betas.

  AC_SUBST(pyexecdir)
  pyexecdir=$PYTHON_EXEC_PREFIX"/lib/python"$PYTHON_VERSION/site-packages

  dnl pkgpyexecdir -- $(pyexecdir)/$(PACKAGE)
  dnl   Maybe this should be put in python.am?

  AC_SUBST(pkgpyexecdir)
  pkgpyexecdir=\${pyexecdir}/$PACKAGE

  AC_MSG_RESULT([looks good])
])


dnl AM_CHECK_PYMOD(MODNAME [,SYMBOL [,ACTION-IF-FOUND [,ACTION-IF-NOT-FOUND]]])
dnl Check if a module containing a given symbol is visible to python.
AC_DEFUN(AM_CHECK_PYMOD,
[AC_REQUIRE([AM_PATH_PYTHON])
py_mod_var=`echo $1['_']$2 | sed 'y%./+-%__p_%'`
AC_MSG_CHECKING(for ifelse([$2],[],,[$2 in ])python module $1)
AC_CACHE_VAL(py_cv_mod_$py_mod_var, [
ifelse([$2],[], [prog="
import sys
try:
        import $1
except ImportError:
        sys.exit(1)
except:
        sys.exit(0)
sys.exit(0)"], [prog="
import $1
$1.$2"])
if $PYTHON -c "$prog" 1>&AC_FD_CC 2>&AC_FD_CC
  then
    eval "py_cv_mod_$py_mod_var=yes"
  else
    eval "py_cv_mod_$py_mod_var=no"
  fi
])
py_val=`eval "echo \`echo '$py_cv_mod_'$py_mod_var\`"`
if test "x$py_val" != xno; then
  AC_MSG_RESULT(yes)
  ifelse([$3], [],, [$3
])dnl
else
  AC_MSG_RESULT(no)
  ifelse([$4], [],, [$4
])dnl
fi
])

dnl a macro to check for ability to create python extensions
dnl  AM_CHECK_PYTHON_HEADERS([ACTION-IF-POSSIBLE], [ACTION-IF-NOT-POSSIBLE])
dnl function also defines PYTHON_INCLUDES
AC_DEFUN([AM_CHECK_PYTHON_HEADERS],
[AC_REQUIRE([AM_PATH_PYTHON])
AC_MSG_CHECKING(for headers required to compile python extensions)
dnl deduce PYTHON_INCLUDES
py_prefix=`$PYTHON -c "import sys; print sys.prefix"`
py_exec_prefix=`$PYTHON -c "import sys; print sys.exec_prefix"`
PYTHON_INCLUDES="-I${py_prefix}/include/python${PYTHON_VERSION}"
if test "$py_prefix" != "$py_exec_prefix"; then
  PYTHON_INCLUDES="$PYTHON_INCLUDES -I${py_exec_prefix}/include/python${PYTHON_VERSION}"
fi
AC_SUBST(PYTHON_INCLUDES)
dnl check if the headers exist:
save_CPPFLAGS="$CPPFLAGS"
CPPFLAGS="$CPPFLAGS $PYTHON_INCLUDES"
AC_TRY_CPP([#include <Python.h>],dnl
[AC_MSG_RESULT(found)
$1],dnl
[AC_MSG_RESULT(not found)
$2])
CPPFLAGS="$save_CPPFLAGS"
])

AC_DEFUN([BUGGY_DISTRO_CHECK_PYGNOME2],
 [
   dnl We have to write this extra test because redhat 8.0 don't
   dnl include gnome-python-2.0.pc in the gnome-python2 package.
   dnl
   dnl Since there are not gnome.pygnome_version variable, we import
   dnl gtk and gnome, and test only gtk.pygtk_version.
   dnl Yes, I know this is stupid!
   AC_MSG_CHECKING(extra test for pygnome >= 1.99.11)
   changequote(<<, >>)dnl
   prog="
import sys
try:
    import pygtk
    pygtk.require('2.0')
except:
    pass
try:
    import gtk, gnome
except:
    sys.exit(1)
if gtk.pygtk_version < (1, 99, 11):
    sys.exit(1)
sys.exit(0)"
    changequote([, ])dnl
    if $PYTHON -c "$prog" 0>&AC_FD_CC 2>&AC_FD_CC
then
AC_MSG_RESULT([[okay. (At least pygtk look ok.)]])
$1
    else
AC_MSG_ERROR(cannot find usable gnome-python)
$2
    fi
  ])

AC_DEFUN([TEST_STYLESHEET],
 [
   dnl This test will check if xsltproc can scan the stylesheet
   dnl    xsltproc /path/to/stylesheet.xsl
   dnl and return 0.
   AC_MSG_CHECKING(if xsltproc likes the stylesheet)
   if $XSLTPROC $stylesheet_filename 0>&AC_FD_CC 2>&AC_FD_CC
then
AC_MSG_RESULT(okay)
$1
   else
AC_MSG_ERROR(parse error. 
$XSLTPROC is not able to parse the file '$stylesheet_filename'
We need a valid docbook XSL stylesheet to generate the users guide.
)
$2
   fi
 ])

dnl Not used since swigver.h is not available everywhere...
dnl How to use in configure.in :
dnl if test "$SWIG_VERSION" = "unknown"; then
dnl TEST_FOR_SWIG(1,3,SWIG_VERSION=1.3,SWIG_VERSION=unknown)
dnl fi

AC_DEFUN([TEST_FOR_SWIG],
  [
   AC_MSG_CHECKING(if swig version is $1.$2)
   AC_RUN_IFELSE(
    [AC_LANG_PROGRAM([[#include <swigver.h>]],
      [[
        if (SWIG_MAJOR_VERSION == $1 && SWIG_MINOR_VERSION == $2) {
          return 0;
        }
        return -1;
      ]]
     )
    ],
[AC_MSG_RESULT(yes)
$3],
[AC_MSG_RESULT(no)
$4])
]
)

AC_DEFUN([MY_PATH_PROG],
 [
  AC_PATH_PROG($1,$2)
if test -z $$1
then
  AC_MSG_ERROR([$2 not found. $3])
fi
 ]
)

dnl
dnl GNOME_CHECK_PKGCONFIG (script-if-enabled, [failflag])
dnl
AC_DEFUN([GNOME_CHECK_PKGCONFIG],[
	AC_PATH_PROG(PKG_CONFIG, pkg-config)
	have_pkgconfig=no
	if test -x "$PKG_CONFIG" ; then
	    have_pkgconfig=yes
	else
	    PKG_CONFIG=
	fi
	AC_MSG_CHECKING(for pkg-config)
	pkgconfig_required_version=0.8.0
	if test x$have_pkgconfig = xyes ; then
	    if ! $PKG_CONFIG --atleast-pkgconfig-version $pkgconfig_required_version; then
		echo "*** Your version of pkg-config is too old. You need version $pkgconfig_required_version or newer."
		echo "*** See http://www.freedesktop.org/software/pkgconfig"
		have_pkgconfig=no
	    fi
	fi
	if test x$have_pkgconfig = xyes ; then
	    AC_MSG_RESULT(yes)
	else
	    PKG_CONFIG=
	    AC_MSG_RESULT(not found)
 	    if test x$2 = xfail; then
		AC_MSG_ERROR([
*** You need the latest pkg-config (at least $pkgconfig_required_version).
*** Get the latest version of pkg-config from
*** http://www.freedesktop.org/software/pkgconfig.])
	    fi
	fi
	AC_SUBST(PKG_CONFIG)

	AC_PROVIDE([GNOME_REQUIRE_PKGCONFIG])
])

dnl
dnl GNOME_REQUIRE_PKGCONFIG
dnl
AC_DEFUN([GNOME_REQUIRE_PKGCONFIG],[
	GNOME_CHECK_PKGCONFIG([], fail)
])


dnl PKG_CHECK_MODULES(GSTUFF, gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
dnl defines GSTUFF_LIBS, GSTUFF_CFLAGS, see pkg-config man page
dnl also defines GSTUFF_PKG_ERRORS on error
AC_DEFUN(PKG_CHECK_MODULES, [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(for $2)

        if $PKG_CONFIG --exists "$2" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes

            AC_MSG_CHECKING($1_CFLAGS)
            $1_CFLAGS=`$PKG_CONFIG --cflags "$2"`
            AC_MSG_RESULT($$1_CFLAGS)

            AC_MSG_CHECKING($1_LIBS)
            $1_LIBS=`$PKG_CONFIG --libs "$2"`
            AC_MSG_RESULT($$1_LIBS)
        else
            $1_CFLAGS=""
            $1_LIBS=""
            ## If we have a custom action on failure, don't print errors, but 
            ## do set a variable so people can do so.
            $1_PKG_ERRORS=`$PKG_CONFIG --errors-to-stdout --print-errors "$2"`
            ifelse([$4], ,echo $$1_PKG_ERRORS,)
        fi

        AC_SUBST($1_CFLAGS)
        AC_SUBST($1_LIBS)
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$3], , :, [$3])
  else
     ifelse([$4], , AC_MSG_ERROR([Library requirements ($2) not met; consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a nonstandard prefix so pkg-config can find them.]), [$4])
  fi
])



