# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002, 2003  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk
import sys

class TracebackWindow(gtk.Dialog):
    def __init__(self):
        gtk.Dialog.__init__(self)
        self.set_default_size(630, 400)
        self.vbox.set_border_width(8)
        label = gtk.Label(_("Program error"))
        label.set_name('Heading1')
        self.vbox.pack_start(label, gtk.FALSE)
        label = gtk.Label(_("Hm... *something* is wrong. You should report this to bug-solfege@gnu.org or solfege-devel@lists.sourceforge.net if you think this is a bug in Solfege."))
        label.set_line_wrap(gtk.TRUE)
        self.vbox.pack_start(label, gtk.FALSE)
        scrollwin = gtk.ScrolledWindow()
        scrollwin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.vbox.pack_start(scrollwin)
        self.g_text = gtk.TextView()
        scrollwin.add(self.g_text)
        b = gtk.Button(stock='gtk-close')
        self.action_area.pack_start(b)
        b.connect('clicked', lambda w: self.hide())
    def write(self, txt):
        sys.stdout.write(txt)
        self.show_all()
        buffer = self.g_text.get_buffer()
        buffer.insert(buffer.get_end_iter(), txt)
    def flush(self, *v):
        pass
    def close(self, *v):
        pass
