# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

if __name__ == '__main__':
    import pygtk
    pygtk.require("2.0")
    import sys
    sys.path.append('src')


import sys
import gtk, pango

#gtkhtml2.gtk_html_context_get().set_property('debug-painting', 1)

import htmllib, formatter
import i18n

import string, re, os
import pyscript
import configureoutput
import cfg

class _HtmlWidgetCommon(object):
    def on_key_press_event(self, *argv):
        """
        Will be used to implement scrolling when HTML is available
        """
        pass
    def read_docfile(self, filename, locale=None):
        filefound = None
        if locale:
            languages = [locale]
        else:
            languages = i18n.langs()
        for lang in languages:
            if os.path.isfile(os.path.join('online-docs', lang, filename)):
                os.chdir(os.path.join("online-docs", lang))
                self.source(open(filename, 'r').read())
                filefound = 1
                os.chdir("../..")
                break
        if not filefound:
            for lang in languages:
                fn = os.path.join('online-docs', lang, 'missing-helpfile.html')
                if os.path.isfile(fn):
                    self.source(open(fn, 'r').read())
                    break


class Font:
    def __init__(self, *f):
        if f == None or f[0] == None or f[0][0] == None:
            self.m_size = self.m_italic = self.m_bold = self.m_teletype = None
        else:
            self.m_size, self.m_italic, self.m_bold, self.m_teletype = f[0][0]

class HTMLWriter(formatter.NullWriter):
    def __init__(self, html, activate_cb, anchor_track_cb):
        formatter.NullWriter.__init__(self)
        self.g_html = html
        self.activate_cb = activate_cb
        self.anchor_track_cb = anchor_track_cb
        self.m_font = Font(None)
        self.m_link = None
        self.m_li = None
        self.m_nesting = 0
        self.m_charset="ascii"
        self.m_ignore_flowing_data = 0
    def new_font(self, *f):
        self.m_font = Font(f)
    def send_flowing_data(self, txt):
        if self.m_ignore_flowing_data:
            return
        buffer = self.g_html.get_buffer()
        try:
            txt = unicode(txt, self.m_charset)
        except:#FIXME
            try:
                txt = unicode(txt, 'iso-8859-1')
            except:
                txt = '[unicode error]'
        if self.m_li:
            buffer.insert(buffer.get_end_iter(), '\n')
        if self.m_link:
            if txt[0] == ' ':
                txt = txt[1:]
                buffer.insert(buffer.get_end_iter(), ' ')
            anchor = buffer.create_child_anchor(buffer.get_end_iter())
            label = gtk.Label('<u><span size="12000" background="white" foreground="blue">%s</span></u>' % txt)
            label.set_use_markup(1)
            label.show()

            box = gtk.EventBox()
            box.add(label)
            box.show()
            box.connect('event', self.on_anchor_event, self.m_link)
            self.g_html.add_child_at_anchor(box, anchor)
        else:
            idx = buffer.get_end_iter().get_offset()
            if self.m_li:
                txt = unichr(0x25CF) + " " + txt
            buffer.insert(buffer.get_end_iter(), txt)
            it_a = buffer.get_iter_at_offset(idx)
            it_b = buffer.get_end_iter()
            if self.m_font.m_size in ('h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'h7'):
                for n in range(1, 4):
                    if self.m_font.m_size == 'h%i' % n:
                        buffer.apply_tag_by_name('h%i' %n, it_a, it_b)
            else:
                if self.m_nesting > 0:
                    if self.m_li:
                        buffer.apply_tag_by_name('indent%i' % self.m_nesting, it_a, it_b)
                    else:
                        # DL
                        buffer.apply_tag_by_name('indent%i' % (self.m_nesting+1), it_a, it_b)
                else:
                    buffer.apply_tag_by_name('normal', it_a, it_b)

            if self.m_font.m_italic:
                buffer.apply_tag_by_name('i', it_a, it_b)
            if self.m_font.m_teletype:
                buffer.apply_tag_by_name('tt', it_a, it_b)
            if self.m_font.m_bold:
                buffer.apply_tag_by_name('strong', it_a, it_b)
        self.m_li = None
    def on_anchor_event(self, eventbox, event, addr):
        if event.type == gtk.gdk.ENTER_NOTIFY:
            self.anchor_track_cb(addr)
        elif event.type == gtk.gdk.LEAVE_NOTIFY:
            self.anchor_track_cb('')
        if event.type == gtk.gdk.BUTTON_RELEASE:
            self.anchor_track_cb('')
            self.activate_cb(addr)
    def send_line_break(self):
        buffer = self.g_html.get_buffer()
        buffer.insert(buffer.get_end_iter(), "\n")
    def send_paragraph(self, n):
        buffer = self.g_html.get_buffer()
        buffer.insert(buffer.get_end_iter(), "\n")
    def do_br(self):
        buffer = self.g_html.get_buffer()
        buffer.insert(buffer.get_end_iter(), "\n")
    def do_hr(self):
        buffer = self.g_html.get_buffer()
        buffer.insert(buffer.get_end_iter(), "\n"+"-"*90+"\n")
    def do_img(self, src, alt):
        im = gtk.Image()
        im.set_from_file(src[1])
        im.show()
        buffer = self.g_html.get_buffer()
        anchor = buffer.create_child_anchor(buffer.get_end_iter())
        self.g_html.add_child_at_anchor(im, anchor)

class MyHTMLParser(htmllib.HTMLParser):
    def __init__(self, formatter):
        htmllib.HTMLParser.__init__(self, formatter)
        self.m_formatter = formatter
    def do_li(self, i):
        #print "DO_LI"
        self.m_formatter.writer.m_li = 1
    def start_ul(self, i):
        #print "START_UL", self.m_formatter.writer.m_nesting
        self.m_formatter.writer.m_nesting += 1
        #print "port-START_UL", self.m_formatter.writer.m_nesting
    def end_ul(self):
        #print "END_UL", self.m_formatter.writer.m_li
        self.m_formatter.writer.m_nesting -= 1
    def start_dd(self, i):
        #self.m_formatter.writer.do_br()
        self.m_formatter.writer.m_nesting += 1
    def end_dd(self):
        self.m_formatter.writer.m_nesting -= 1
    def start_dt(self, i):
        self.m_formatter.writer.do_br()
        self.m_formatter.writer.do_br()
    def end_dt(self):
        self.m_formatter.writer.do_br()
    def start_style(self, attributes):
        self.m_formatter.writer.m_ignore_flowing_data = 1
    def end_style(self):
        self.m_formatter.writer.m_ignore_flowing_data = 0
    def do_meta(self, attributes):
        http_equiv = None
        content = None
        for n, c in attributes:
            if n == 'http-equiv':
                http_equiv = c
            elif n == 'content':
                content = c
        if not http_equiv:
            return
        if http_equiv.upper() == 'CONTENT-TYPE':
            v = content.split()
            # UGH
            for s in v:
                v2 = s.split('=')
                if len(v2) == 2:
                    if v2[0].upper() == 'CHARSET':
                        self.m_formatter.writer.m_charset = v2[1]
                        break
    def do_br(self, x):
        self.m_formatter.writer.do_br()
    def do_hr(self, x):
        self.m_formatter.writer.do_hr()
    def start_td(self, *x):
        self.m_formatter.writer.do_br()
    def start_a(self, *v):
        if v[0][0][0] == 'href':
            self.m_formatter.writer.m_link = v[0][0][1]
    def end_a(self):
        self.m_formatter.writer.m_link = None
    def start_pre(self, *v):
        self.nofill=1
        self.save_bgn()
    def end_pre(self, *v):
        self.m_formatter.push_font(('', 0, 0, 1))
        self.m_formatter.writer.do_br()
        self.m_formatter.writer.send_flowing_data(self.save_end())
        self.m_formatter.pop_font()
        self.nofill=0
    def do_img(self, a):
        src, alt = a
        self.m_formatter.writer.do_img(src, alt)


class HtmlController:
    def __init__(self, html, activate_cb, anchor_track_cb):
        self.g_html = html
        self.setup_fonts()
        self.writer = HTMLWriter(html, activate_cb, anchor_track_cb)
        self.formatter = formatter.AbstractFormatter(self.writer)
        self.parser = MyHTMLParser(self.formatter)
    def source(self, html):
        buffer = self.g_html.get_buffer()
        it_a = buffer.get_start_iter()
        it_b = buffer.get_end_iter()
        buffer.delete(it_a, it_b)
        self.parser.feed(html)
    def setup_fonts(self):
        b = self.g_html.get_buffer()
        for n, fontsize in (1, 32), (2, 24), (3, 20), (4, 16), (5, 14):
            t = b.create_tag('h%i' % n)
            t.set_property('font', 'Sans %i' % fontsize)
        t = b.create_tag('i')
        t.set_property('style', pango.STYLE_ITALIC)
        t = b.create_tag('tt')
        t.set_property('font', 'Monospace 12')
        t = b.create_tag('strong')
        t.set_property('weight', pango.WEIGHT_BOLD)
        t = b.create_tag('normal')
        t.set_property('font', 'Sans 12')
        t = b.create_tag('indent1')
        t.set_property('left-margin', 10)
        t.set_property('indent', -12)
        #t.set_property('background', 'red')
        t = b.create_tag('indent2')
        t.set_property('left-margin', 20)
        t.set_property('indent', -12)
        #t.set_property('background', 'green')
        t = b.create_tag('indent3')
        t.set_property('left-margin', 30)
        t.set_property('indent', -12)
        #t.set_property('background', 'yellow')

class TextViewHtmlWidget(gtk.ScrolledWindow, _HtmlWidgetCommon):
    def __init__(self, activate_cb, anchor_track_cb):
        gtk.ScrolledWindow.__init__(self)
        self.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.g_tw = gtk.TextView()
        self.m_html = HtmlController(self.g_tw, activate_cb, anchor_track_cb)
        self.g_tw.set_editable(0)
        self.g_tw.set_cursor_visible(0)
        self.g_tw.set_left_margin(10)
        self.g_tw.set_right_margin(10)
        self.g_tw.set_wrap_mode(gtk.WRAP_WORD)
        self.add(self.g_tw)
        self.idx = 0
        self.m_pyscript = pyscript.PyScript()
        self.grab_focus = self.g_tw.grab_focus
    def source(self, txt):
        txt = self.m_pyscript.evaluate(txt)
        self.m_html.source(txt)
        buf = self.g_tw.get_buffer()
        buf.place_cursor(buf.get_start_iter())


class GtkHtml2Widget(gtk.ScrolledWindow, _HtmlWidgetCommon):
    def __init__(self, activate_cb, anchor_track_cb):
        gtk.ScrolledWindow.__init__(self)
        self.activate_cb = activate_cb
        self.anchor_track_cb = anchor_track_cb
        self.g_document = gtkhtml2.Document()
        self.g_view = gtkhtml2.View()
        self.set_hadjustment(self.g_view.get_hadjustment())
        self.set_vadjustment(self.g_view.get_vadjustment())
        self.add(self.g_view)
        self.g_view.set_document(self.g_document)
        self.g_document.connect('link_clicked',
                 lambda widget, url: self.activate_cb(url))
        self.g_document.connect('request_url', self.on_request_url)
        if self.anchor_track_cb:
            self.g_view.connect('on-url', lambda f, url: self.anchor_track_cb(url))
        self.grab_focus = self.g_view.grab_focus
    def on_request_url(self, document, url, stream):
        #if url == "style.css":
        #    stream.set_mime_type("text/css")
        #    print stream.get_mime_type()
        s = open(url, 'r').read()
        stream.write(s)
    def source(self, html):
        self.g_document.clear()
        self.g_document.open_stream("text/html")
        self.g_document.write_stream(html)
        self.g_document.close_stream()

def _test():
    import gettext
    gettext.install('solfege', 'share/locale', unicode=1)
    sys.path.insert(0, ".")
    import gtk
    w = gtk.Window()
    w.set_size_request(300, 300)
    def activate_cb(*v):
        print "ACTIVATE_CB", v
    def anchor_track_cb(*v):
        print "ANCHOR_TRACK_CB", v
    h = HtmlWidget(activate_cb, anchor_track_cb)
    h.source("""
<html>
<body>
<h1>Heading 1 <i>italic</i> <tt>teletype</tt></h1>
<h2>Heading 2 <i>italic</i> <tt>teletype</tt></h2>
<h3>Heading 3 <i>italic</i> <tt>teletype</tt></h3>
  This is a paragraph with a <a href="addr1">link</a> in the middle
  of a sentence.

<p>Definition list:</p>
<div class="val">
<dl>
<dt>Term 1</dt>
<dd><p>Definition data 1</p></dd>
<dt>Term 2</dt>
<dd>Definition data 2</dd>
<dt>Term 3</dt>
<dd>Definition data 3</dd>
</dl>
</div>
<p>paragraph</p>

<dl>
    <dt>Definition term 1</dt>

    <dd>Definition description 1</dd>
    <dt>Definition term 2</dt>
    <dd>
        <dl>
            <dt>Definition term 1 - 2</dt>
            <dd>Definition description 1 - 2</dd>
            <dt>Definition term 2 - 2</dt>
            <dd>Definition description 2 - 2</dd>
            <dt>Definition term 3 - 2</dt>
            <dd>Definition description 3 - 2</dd>
        </dl>
    </dd>
    <dt>Definition term 3</dt>
    <dd>Definition description 3</dd>
</dl> 

<p>This is a paragraph</p>  

<p>Simple bullet list:</p>
<ul><li>en alkdsj alksj dflkajsd lja dlkl kdalkdj alskd laksdj falksd flaksd 
 askldj falksjd flaksj laksj lkajd lfkald kfajldf
<li>to
<li>tre
</ul>

<p>Simple bullet list:</p>
<ul>
<li>ben</li>
<li>bto
    bla bla bla bla bla bla bla bla bla bla bla bla
    bla bla bla bla bla bla bla bla bla bla bla bla
</li>
<li>
    <ul>
        <li>bhei-1</li>
        <li>bhei-2
            bla bla bla bla bla bla bla bla bla bla bla bla
            bla bla bla bla bla bla bla bla bla bla bla bla
        <li>
            <ul>
                <li>btre-1</li>
                <li>btre-2 
                    bla bla bla bla bla bla bla bla bla bla bla bla
                    bla bla bla bla bla bla bla bla bla bla bla bla
                </li>
                <li>tre-3</li>
            </ul>
        </li>
    </ul>
<li>tre
</ul>

<p>Font styles: <i>italics</i>, <tt>tt (fixed)</tt>
</p>
<p>Another paragraph with another ABC<a href="addr2">link</a>DEF.</p>

</body></html>

""")
    w.add(h)
    w.show_all()
    w.connect('destroy', gtk.mainquit)
    gtk.mainloop()

if configureoutput.WITH_GTKHTML:
    import gtkhtml2
    HtmlWidget = GtkHtml2Widget
else:
    HtmlWidget = TextViewHtmlWidget

if __name__ == '__main__':
    _test()


