#!/usr/bin/python2.2

# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002, 2003  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This script is used to launch Solfege when running
# it from the source dir without installing.

import sys

if sys.version_info < (2, 2):
    print "********************************************************************"
    print "Solfege need Python 2.2 or newer. The configure script told you so!"
    print "********************************************************************"
    sys.exit(-1)

import src
import src.configureoutput

src.configureoutput.prefix = "."

import src.rcfile
src.rcfile.copy_rc_file()
import src.cfg

src.cfg.initialise(None, "default.config", "~/.solfegerc%i.%i" %
  (src.configureoutput.MAJOR_VERSION, src.configureoutput.MINOR_VERSION))

if '--txtui' in sys.argv:
    import src.txtui
else:
    import src.mainwin

