/* Functions to be called from Smalltalk */
/* This is your file, Mike */

#ifndef _GST_GTK_WIDGETS_H
#define _GST_GTK_WIDGETS_H

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef __cplusplus
}
#endif

#include <gtk/gtk.h>
#include "gstpub.h"

/*# include <glib-object.h>
# include "global.h"*/

/* Widgets */
void *gst_gtk_create_widget(OOP st_obj, char *aName, char *aType, void *aParent);
void gst_gtk_destroy_widget(void *aWidget);
void gst_gtk_destroy_window(void *aWidget);

/* Properties */
void gst_gtk_set_property(void *aObject, char *aProperty, OOP aValue);
OOP  gst_gtk_get_property(void *aObject, char *aProperty);

/* Containers */
void gst_gtk_container_add(void *aContainer, void *aWidget);
void gst_gtk_container_remove(void *aContainer, void *aWidget);
void gst_gtk_set_child_property(void *aContainer, void *aChild, char *aProperty, OOP aValue);
OOP  gst_gtk_get_child_property(void *aContainer, void *aChild, char *aProperty);

/* Signals */
void gst_gtk_signal_connect(void *widget, char *signal, OOP cb_obj);
void gst_gtk_signal_disconnect(void *widget, char *signal);
void gst_gtk_signal_abort(void *widget, char *signal);
void gst_gtk_signal_emit(void *widget, char *signal);

/* Unnecessary */
void gst_gtk_main(void); /* To prove that it can't be used */
void gst_gtk_test(void);
void gst_gtk_size_request(void *aWidget);
int  gst_gtk_test_oop(OOP aOop);

/* Private */
void _signal_connect(void *widget, char *signal, OOP cb_obj, GCallback cb_func);

#endif /* _GST_GTK_WIDGETS_H */

