/* A significant number of the functions used are Gtk 2.2 only */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include "global.h"
#include "callbacks.h"
#include "widgets.h"
#include "tree.h"

void        
gst_gtk_tree_view_set_model(void *view, void *model) 
{ 
  gtk_tree_view_set_model(GTK_TREE_VIEW(view), GTK_TREE_MODEL(model)); 
} 

/*void * 
  gst_gtk_create_tree_view(void *store) 
  { 
  GtkTreeView *result; 
  result = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store)); 
  return(result); 
  } */

void *
gst_gtk_create_list_store()
{
  GtkListStore* result;
  /* FIXME */
  result = gtk_list_store_new(1, G_TYPE_STRING);
  /* result has ref count of 1 */
  return(result);
}

void * 
gst_gtk_create_tree_store() 
{ 
  GtkTreeStore *result; 
  /* FIXME */
  result = gtk_tree_store_new (1, G_TYPE_STRING); 
  /* result has ref count of 1 */ 
  return(result); 
} 


OOP 
gst_gtk_tree_model_get(void *model, char *path, int col) 
{ 
  GtkTreeIter iter; 
  GValue val = { 0, }; 
  OOP result; 
  GtkTreeModel *mod;

  mod = GTK_TREE_MODEL(model);
  if (!gtk_tree_model_get_iter_from_string(mod, &iter, path)) return(NULL); 
  gtk_tree_model_get_value(mod, &iter, 0, &val); 
  result = _oop_from_value(&val);
  g_value_unset(&val); 
  return(result); 
} 


void 
gst_gtk_tree_store_insert(void *store, char *parent_path, int position) 
{ 
  GtkTreeIter parent; 
  GtkTreeIter *p_parent; 
  GtkTreeIter iter; 
  GtkTreeStore *st;

  st = GTK_TREE_STORE(store);
  if ((parent_path == NULL) || (strlen(parent_path) == 0)) {
    p_parent = NULL;
  } else {
    if (!gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(st), &parent, parent_path)) 
      return; 
    p_parent = &parent;
  }
  gtk_tree_store_insert(st, &iter, p_parent, position); 
} 
  
void 
gst_gtk_list_store_insert(void *store, int position) 
{ 
  GtkTreeIter iter; 
  gtk_list_store_insert(GTK_LIST_STORE(store), &iter, position); 
} 

void 
gst_gtk_tree_store_set(void *store, char *path, int col, OOP value) 
{ 
  GtkTreeIter iter; 
  GValue gval = { 0, }; 
  if (!gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(store), &iter, path)) 
    return; /* Needs error return? */ 
  _value_init_from_oop(&gval, value, G_TYPE_STRING /* FIXME */);
  gtk_tree_store_set_value (GTK_TREE_STORE(store), &iter, col, &gval); 
} 

void 
gst_gtk_list_store_set(void *store, int index, int col, OOP value) 
{ 
  GtkTreeIter iter; 
  GValue gval = { 0, };
  if (!gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(store), &iter, NULL, index)) 
    return; /* Needs error return? */ 
  _value_init_from_oop(&gval, value, G_TYPE_STRING /* FIXME */);
  gtk_list_store_set_value (GTK_LIST_STORE(store), &iter, col, &gval); 
} 

void * 
gst_gtk_create_tree_column( 
			   void *view, 
			   char *title, 
			   void *renderer, 
			   char *attr, 
			   int model_col 
			   ) 
{ 
  GtkTreeViewColumn *result; 
  result = gtk_tree_view_column_new_with_attributes ( 
						     title, GTK_CELL_RENDERER(renderer), attr, model_col, NULL 
						     ); 
  gtk_tree_view_append_column (GTK_TREE_VIEW (view), result); 
  return(result); 
} 

void * 
gst_gtk_create_cell_renderer(char *type) 
{ 
  /* renderer is controlled by properties */ 
  if (strcasecmp(type, "text") == 0) { 
    return(gtk_cell_renderer_text_new ()); 
  } 
  /* there are two other renderer types - ignore for now */ 
  return(NULL); /* error? */ 
}
   
void _row_activated_callback(GtkTreeView *treeview, GtkTreePath *arg1, GtkTreeViewColumn *arg2, gpointer callback);
void _row_activated_callback(
  GtkTreeView *treeview, GtkTreePath *arg1, GtkTreeViewColumn *arg2, gpointer callback
)
{
  /* FIXME - How to return the column to ST? */
  GstGtkCallback *cb;
  gchar *path;
 
  cb = (GstGtkCallback *) callback;

  path = gtk_tree_path_to_string(arg1);

  smalltalk_vm_proxy->strMsgSend(
    smalltalk_vm_proxy->idToOOP(cb->st_signal),
    "callbackWith:",
    smalltalk_vm_proxy->stringToOOP(path),
    NULL
  ); 

  g_free(path);
}

void gst_gtk_row_activated_callback_connect(void *treeview, char *signal, OOP cb_obj)
{
  if (strcmp(signal, "row-activated")) 
  {
    fprintf(stderr, "calling gst_gtk_row_activated_callback_connect with %s as the signal?!", signal);
  }
  _signal_connect(treeview, "row-activated", cb_obj, G_CALLBACK(_row_activated_callback));  
}

void _selection_changed_callback(GtkTreeSelection *selection, gpointer callback);
void _selection_changed_callback(GtkTreeSelection *selection, gpointer callback)
{
  GstGtkCallback *cb;
  gchar *path;
  OOP data;
  GtkTreeModel *model;
  GtkTreeIter iter;

  path = NULL; 
  if (gtk_tree_selection_get_mode(selection) == GTK_SELECTION_SINGLE) 
    {
      if (gtk_tree_selection_get_selected (selection, &model, &iter))
	{
	  path = gtk_tree_model_get_string_from_iter(model, &iter);
	  data = smalltalk_vm_proxy->stringToOOP(path);
	}
      else
	{
	  /* Don't know when this would occur */
	  data = smalltalk_vm_proxy->stringToOOP("");
	}
    }
  else
    {
      /* FIXME: Use gtk_tree_selection_get_selected_rows () and return
	 all of the rows */
      data = smalltalk_vm_proxy->stringToOOP("");
    } 

  cb = (GstGtkCallback *) callback;
  smalltalk_vm_proxy->strMsgSend(
    smalltalk_vm_proxy->idToOOP(cb->st_signal),
    "callbackWith:",
    data,
    NULL
  ); 

  if (path) 
    g_free(path);
}

void gst_gtk_selection_changed_callback_connect(void *treeview, char *signal, OOP cb_obj)
{
  if (strcmp(signal, "selection-changed")) 
  {
    fprintf(stderr, "calling gst_gtk_selection_changed_callback_connect with %s as the signal?!", signal);
  }

  _signal_connect (
    gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)),
    "changed",
    cb_obj,
    G_CALLBACK (_selection_changed_callback)
  );
}
