 
#ifndef _GST_GTK_TEXT_H
#define _GST_GTK_TEXT_H

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef __cplusplus
}
#endif

#include <gtk/gtk.h>

void *gst_gtk_create_textbuffer();
void  gst_gtk_textview_set_buffer(void *view, void *buffer);
void *gst_gtk_create_textmark(void *buffer, char *name, int position, int left_gravity);
void *gst_gtk_create_texttag(void *buffer, char *name);
void  gst_gtk_textbuffer_set_all_text(void *buffer, char *text);
char *gst_gtk_textbuffer_get_all_text(void *buffer);

void  gst_gtk_textbuffer_apply_tag(void *buffer, void *tag, int start, int end);
void  gst_gtk_textbuffer_remove_tag(void *buffer, void *tag, int start, int end);
void  gst_gtk_textbuffer_remove_all_tags(void *buffer, int start, int end);

int   gst_gtk_textbuffer_get_end(void *buffer);
char *gst_gtk_textbuffer_get_text(void *buffer, int start, int end);
char *gst_gtk_textbuffer_get_selection_text(void *buffer);

void  gst_gtk_insert_text_callback_connect(void *textbuffer, char *signal, OOP cb_obj);
void  gst_gtk_delete_range_callback_connect(void *textbuffer, char *signal, OOP cb_obj);

void *gst_gtk_textbuffer_get_mark_named(void *buffer, char *name);
int   gst_gtk_textmark_get_line(void *mark);
int   gst_gtk_textmark_get_offset(void *mark);

char *gst_gtk_textbuffer_get_current_line(void *buffer);
int   gst_gtk_textbuffer_get_line_offset(void *buffer, int line);

#endif /* _GST_GTK_TEXT_H */
