
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include "global.h"
#include "callbacks.h"
#include "widgets.h"
#include "text.h"

void *
gst_gtk_create_textbuffer()
{
  return(gtk_text_buffer_new(NULL));
}

void
gst_gtk_textview_set_buffer(void *view, void *buffer)
{
  gtk_text_view_set_buffer (GTK_TEXT_VIEW(view), GTK_TEXT_BUFFER(buffer));
}

void *
gst_gtk_create_textmark(void *buffer, char *name, int position, int left_gravity)
{
  GtkTextIter iter;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);

  gtk_text_buffer_get_iter_at_offset(buf, &iter, position);
  return(gtk_text_buffer_create_mark (buf, name, &iter, (gboolean)left_gravity));
}

void *
gst_gtk_create_texttag(void *buffer, char *name)
{
  return(gtk_text_buffer_create_tag (GTK_TEXT_BUFFER(buffer), name, NULL));
}

void
gst_gtk_textbuffer_set_all_text(void *buffer, char *text)
{
  /* Assumes text is 0-terminated */
  gtk_text_buffer_set_text (GTK_TEXT_BUFFER(buffer), text, -1);
}

char *
gst_gtk_textbuffer_get_all_text(void *buffer)
{
  GtkTextIter it_start;
  GtkTextIter it_end;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);

  /* gtk_text_buffer_get_start_iter(buf, &it_start);
     gtk_text_buffer_get_end_iter(buf, &it_end);
     gtk_text_buffer_get_text (buf, &it_start, &it_end, 0);*/
  gtk_text_buffer_get_bounds(buf, &it_start, &it_end); 
  return(gtk_text_buffer_get_text(buf, &it_start, &it_end, FALSE)); 
  /* Looking at the gtk-demo, doesn't seem like the result needs to be freed */
}

int
gst_gtk_textbuffer_get_end(void *buffer)
{
  GtkTextIter it_end;

  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer), &it_end);
  return(gtk_text_iter_get_offset(&it_end)); 
}

void 
gst_gtk_textbuffer_apply_tag(void *buffer, void *tag, int start, int end)
{
  GtkTextIter it_start;
  GtkTextIter it_end;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);
  gtk_text_buffer_get_iter_at_offset(buf, &it_start, start);
  gtk_text_buffer_get_iter_at_offset(buf, &it_end, end);
  gtk_text_buffer_apply_tag(buf, GTK_TEXT_TAG(tag), &it_start, &it_end);
}

void
gst_gtk_textbuffer_remove_tag(void *buffer, void *tag, int start, int end)
{
  GtkTextIter it_start;
  GtkTextIter it_end;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);
  gtk_text_buffer_get_iter_at_offset(buf, &it_start, start);
  gtk_text_buffer_get_iter_at_offset(buf, &it_end, end);
  gtk_text_buffer_remove_tag(buf, GTK_TEXT_TAG(tag), &it_start, &it_end);
}

void
gst_gtk_textbuffer_remove_all_tags(void *buffer, int start, int end)
{
  GtkTextIter it_start;
  GtkTextIter it_end;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);
  gtk_text_buffer_get_iter_at_offset(buf, &it_start, start);
  gtk_text_buffer_get_iter_at_offset(buf, &it_end, end);
  gtk_text_buffer_remove_all_tags(buf, &it_start, &it_end);
}

void
gst_gtk_textbuffer_insert(void *buffer, int position, char *text)
{
  GtkTextIter pos;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);
  gtk_text_buffer_get_iter_at_offset(buf, &pos, position);
  gtk_text_buffer_insert(buf, &pos, text, -1); /* -1 => nul-terminated */
}

void
gst_gtk_textbuffer_delete(void *buffer, int start, int end)
{
  GtkTextIter it_start;
  GtkTextIter it_end;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);
  gtk_text_buffer_get_iter_at_offset(buf, &it_start, start);
  gtk_text_buffer_get_iter_at_offset(buf, &it_end, end);
  gtk_text_buffer_delete(buf, &it_start, &it_end);
}

char *
gst_gtk_textbuffer_get_text(void *buffer, int start, int end)
{
  GtkTextIter it_start;
  GtkTextIter it_end;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);
  gtk_text_buffer_get_iter_at_offset(buf, &it_start, start);
  gtk_text_buffer_get_iter_at_offset(buf, &it_end, end);
  return(gtk_text_buffer_get_text(buf, &it_start, &it_end, FALSE));
  /* Looking at the gtk-demo, doesn't seem like the result needs to be freed */
}

char *
gst_gtk_textbuffer_get_selection_text(void *buffer)
{
  GtkTextIter it_start;
  GtkTextIter it_end;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);
  if (!gtk_text_buffer_get_selection_bounds(buf, &it_start, &it_end)) 
    return("");
  return(gtk_text_buffer_get_text(buf, &it_start, &it_end, FALSE));
}  

void 
_insert_text_callback(GtkTextBuffer *buffer, GtkTextIter *arg1, gchar *arg2, gint arg3, gpointer user_data);
void 
_insert_text_callback(
  GtkTextBuffer *buffer, GtkTextIter *arg1, gchar *arg2, gint arg3, gpointer user_data
)
{
  /* arg1 = position, arg2 = text, arg3 = length of arg2 */

  GstGtkCallback *cb;
  gint offset;
 
  cb = (GstGtkCallback *) user_data;
  offset = gtk_text_iter_get_offset(arg1);

  smalltalk_vm_proxy->strMsgSend(
    smalltalk_vm_proxy->idToOOP(cb->st_signal),
    "callbackWith:with:",
    smalltalk_vm_proxy->stringToOOP(arg2),
    smalltalk_vm_proxy->intToOOP(offset),
    NULL
  ); 
}

void gst_gtk_insert_text_callback_connect(void *buffer, char *signal, OOP cb_obj)
{
  if (strcmp(signal, "insert-text")) 
  {
    fprintf(stderr, "calling gst_gtk_text_insert_callback_connect with %s as the signal?!", signal);
  }
  _signal_connect(buffer, "insert-text", cb_obj, G_CALLBACK(_insert_text_callback));  
}

void _delete_range_callback(GtkTextBuffer *buffer,  GtkTextIter *arg1, GtkTextIter *arg2, gpointer user_data);
void 
_delete_range_callback(
  GtkTextBuffer *buffer,  GtkTextIter *arg1, GtkTextIter *arg2, gpointer user_data
)
{
  GstGtkCallback *cb;
  gint start;
  gint end;
 
  cb = (GstGtkCallback *) user_data;
  start = gtk_text_iter_get_offset(arg1);
  end = gtk_text_iter_get_offset(arg2);

  smalltalk_vm_proxy->strMsgSend(
    smalltalk_vm_proxy->idToOOP(cb->st_signal),
    "callbackWith:with:",
    smalltalk_vm_proxy->intToOOP(start),
    smalltalk_vm_proxy->intToOOP(end),
    NULL
  ); 
}

void gst_gtk_delete_range_callback_connect(void *buffer, char *signal, OOP cb_obj)
{
  if (strcmp(signal, "delete-range")) 
  {
    fprintf(stderr, "calling gst_gtk_delete_range_callback_connect with %s as the signal?!", signal);
  }
  _signal_connect(buffer, "delete-range", cb_obj, G_CALLBACK(_delete_range_callback));  
}

void *
gst_gtk_textbuffer_get_mark_named(void *buffer, char *name)
{
  return(gtk_text_buffer_get_mark(GTK_TEXT_BUFFER(buffer), name));
}

int 
gst_gtk_textmark_get_line(void *mark)
{
  GtkTextIter iter;
  GtkTextBuffer *buf;
  GtkTextMark *mk;

  mk = GTK_TEXT_MARK(mark);
  buf = gtk_text_mark_get_buffer(mk);
  gtk_text_buffer_get_iter_at_mark(buf, &iter, mark);
  return(gtk_text_iter_get_line(&iter));
}

int 
gst_gtk_textmark_get_offset(void *mark)
{
  GtkTextIter iter;
  GtkTextBuffer *buf;
  GtkTextMark *mk;

  mk = GTK_TEXT_MARK(mark);
  buf = gtk_text_mark_get_buffer(mk);
  gtk_text_buffer_get_iter_at_mark(buf, &iter, mark);
  return(gtk_text_iter_get_offset(&iter));
}

char *
_get_text_line(GtkTextIter *line)
{
  GtkTextIter start;
  GtkTextIter end;
  int n;
  
  /* There doesn't seem to be a less complex way of doing this!? */
  /* Get the start of the line */
  start = *line;
  gtk_text_iter_set_line_offset(&start, 0); 
  /* Get the start of the next line (or the buffer end) */
  end = start;
  gtk_text_iter_forward_line(&end);
  /* Move backwards past the paragraph markers */
  n = 3;
  while (!gtk_text_iter_ends_line(&end) && (n > 0))
    {
      gtk_text_iter_backward_char(&end);
      n--;
    }
  if (n <= 0) 
    {
      fprintf(stderr, "gst_gtk_textbuffer_get_current_line: failed to find line end");
    }
  /* Phew. Now we can return the line! */
  return(gtk_text_buffer_get_text(gtk_text_iter_get_buffer(line), &start, &end, FALSE));
}

char *
gst_gtk_textbuffer_get_current_line(void *buffer)
{
  GtkTextIter iter;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);
  gtk_text_buffer_get_iter_at_mark(buf, &iter, gtk_text_buffer_get_insert(buf));  
  return(_get_text_line(&iter));
}

int
gst_gtk_textbuffer_get_line_offset(void *buffer, int line)
{
  GtkTextIter iter;
  GtkTextBuffer *buf;

  buf = GTK_TEXT_BUFFER(buffer);
  gtk_text_buffer_get_iter_at_line(buf, &iter, line);
  return(gtk_text_iter_get_offset(&iter));
}
