#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>

#define NO_FILES 10

int main(void)
{
  void *handle[NO_FILES];
  void (*testfn)(void);
  const char *errmsg;
  int i;

  const char *libs[NO_FILES] = {
    "/usr/lib/libpango-1.0.so",
    "/usr/lib/libpangox-1.0.so",
    "/usr/lib/libgdk_pixbuf-2.0.so",
    "/usr/lib/libatk-1.0.so",
    "/usr/lib/libgobject-2.0.so",
    "/usr/lib/libgmodule-2.0.so",
    "/usr/lib/libglib-2.0.so",
    "/usr/lib/libgdk-x11-2.0.so",
    "/usr/lib/libgtk-x11-2.0.so",
    "/usr/local/lib/smalltalk/gst-gtk.so"
  };

  for (i = 0; i < NO_FILES; i++) {
      handle[i] = dlopen(libs[i], RTLD_NOW);
      if (handle[i] == NULL) {
	fprintf(stderr, "Failed to load %s: %s\n", libs[i], dlerror());
	exit(EXIT_FAILURE);
      }
  }
  
  dlerror();
  testfn = dlsym(handle[NO_FILES - 1], "gst_gtk_test");
  if((errmsg = dlerror()) != NULL) {
    fprintf(stderr, "Didn't find gst_gtk_test: %s\n", errmsg);
    exit(EXIT_FAILURE);
  }
  
  testfn();

  for (i = 0; i < NO_FILES; i++) {
    dlclose(handle[i]);
  }
  exit(EXIT_SUCCESS);
}
