Gtk GtkObject initializeGtk !

Gtk.Window subclass: #WindowInspector
	instanceVariableNames: 'window tree text label selection'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

!WindowInspector class methodsFor: 'experimentation'!

for: aObject
  ^(self new: ('WI', self instanceCount printString)) window: aObject; buildWindow; yourself.
!

forItself
  | wnd |
  wnd := self new: ('WI', self instanceCount printString).
  ^wnd buildWindow; window: wnd; yourself.
!

!

!WindowInspector methodsFor: 'experimentation'!

buildNode: aPath for: aWidget
    | i |
    
    tree path: aPath column: 0 put: aWidget name.

    aWidget isContainer ifTrue: [
	i := 0.
	aWidget children do: [ :each |
	    tree path: aPath insertAt: i.
	    self buildNode: (aPath, ':', i printString) for: each.
	    i := i + 1.
	]
    ].
!

buildTree
    tree path: '' insertAt: 0.
    self buildNode: '0' for: window.
!

buildTreeViewIn: aContainer
    | tv col rend |
    tv := TreeView new: 'tv' in: aContainer.
    col := TreeViewColumn 
	newIn: tv 
	title: 'Widget' 
	renderer: (TextCellRenderer new).
    ^tv.
!


buildWindow

 | btn vbox treeView textView lbl hbox frame |
  
    Transcript print: 'Building window...'; cr.

    self property: 'border-width' value: 9.

    vbox := Gtk.VBox new: 'vbox1' in: self.

    label := Gtk.Label new: 'lblTop' in: vbox.
    window notNil ifTrue: [ label label: window printString ].
    vbox child: label property: 'expand' value: false.

    frame := Gtk.Frame new: 'frame1' in: vbox.

    treeView := self buildTreeViewIn: frame.
    treeView model: (tree := Gtk.TreeStore new).

    frame := Gtk.Frame new: 'frame2' in: vbox.

    text := Gtk.TextBuffer new.

    textView := Gtk.TextView new: 'text1' in: frame.
    textView buffer: text.

    hbox := Gtk.HBox new: 'hbox1' in: vbox.
    vbox child: hbox property: 'expand' value: false.

    btn := Gtk.Button new: 'btnEval' in: hbox.
    btn label: 'Evaluate'.
    btn connectSignal: 'clicked' to: self send: #evaluateCallback:.

    btn := Gtk.Button new: 'btnTest1' in: hbox.
    btn label: 'Test'.
    btn connectSignal: 'clicked' to: self send: #testCallback: .


    btn := Gtk.Button new: 'btnClose' in: hbox.
    btn label: 'Close'.
    btn connectSignal: 'clicked' to: self send: #close:.

    treeView connectSignal: 'row-activated' to: self send: #rowActivatedCallback:path: .
    treeView connectSignal: 'selection-changed' to: self send: #selectionChangedCallback:path: .

!

testCallback: aSender
  Transcript print: 'testCallback:'.
!

evaluateCallback: aSender
  | result toEval wgt |
  toEval := text getText.
  Transcript print: 'Evaluating: ', toEval, ' to ', selection.
  wgt := window findWidget: selection.
  result := Behavior 
    evaluate: toEval
    to: wgt
    ifError: [ :fname :line :msg | Transcript print: msg. ^self ].
  InspectorWindow for: result.
!

snapshotCallback: aSender
  ObjectMemory snapshot: 'WindowInspector.im'.
!

selectionChangedCallback: aSender path: aPath
  selection := tree path: aPath column: 0.
  Transcript print: '#selectionChangedCallback:path: ', selection.
!

rowActivatedCallback: aSender path: aPath
  Transcript print: '#rowActivatedCallback:path: ', aPath printString.
!

window: aWindow
    window := aWindow.
    self buildTree.
    self label: aWindow name.
!

onYourself
  self window: self
!

label: aLabel
    label label: aLabel.
!

!
