PackageLoader fileInPackage: 'GstGtk'!

Gtk GtkObject initializeGtk !

Gtk.Window subclass: #TestTextWindow
	instanceVariableNames: 'object text'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

!TestTextWindow class methodsFor: 'experimentation'!

testWindow
  | wnd |
  wnd := self new: ('T', self instanceCount printString).
  ^wnd buildWindow; yourself.
!

!

!TestTextWindow methodsFor: 'experimentation'!

buildWindow

 | btn vbox textView lbl hbox frame |
  
    Transcript print: 'Building window...'; cr.

    self property: 'border-width' value: 9.

    vbox := Gtk.VBox new: 'vbox1' in: self.

    lbl := Gtk.Label new: 'lblTop' in: vbox.
    lbl label: object printString.
    vbox child: lbl property: 'expand' value: false.

    frame := Gtk.Frame new: 'frame1' in: vbox.
    "frame property: 'shadow' value: 'in'."

    text := Gtk.TextBuffer new.
    text connectSignal: 'insert-text' to: self send: #textInsertedCallback:text:at:.
    text connectSignal: 'delete-range' to: self send: #rangeDeletedCallback:from:to:.

    textView := Gtk.TextView new: 'text1' in: frame.
    "frame child: textView property: 'expand' value: true."
    "frame child: textView property: 'padding' value: 9."
    textView buffer: text.

    hbox := Gtk.HBox new: 'hbox1' in: vbox.
    vbox child: hbox property: 'expand' value: false.

    btn := Gtk.Button new: 'btnSet' in: hbox.
    btn label: 'Set'.
    btn connectSignal: 'clicked' to: self send: #setCallback:.

    btn := Gtk.Button new: 'btnGet' in: hbox.
    btn label: 'Get'.
    btn connectSignal: 'clicked' to: self send: #getCallback:.

    btn := Gtk.Button new: 'btnTag' in: hbox.
    btn label: 'Tag'.
    btn connectSignal: 'clicked' to: self send: #tagCallback:.

    btn := Gtk.Button new: 'btnClose' in: hbox.
    btn label: 'Close'.
    btn connectSignal: 'clicked' to: self send: #close:.
!

textInsertedCallback: aSender text: aText at: aPosition
    Transcript print: 'Text: "', aText, '" at: ', aPosition printString; cr.
!

rangeDeletedCallback: aSender from: aStart to: aEnd
    Transcript print: 'Delete from: ', aStart printString, ' to: ', aEnd printString; cr.
!

setCallback: aSender
  | result toEval |
  text setText: 'The cat sat on the mat'.
!

getCallback: aSender
  Transcript cr; print: (text getText); cr; print: (text getSelection).
!

tagCallback: aSender
  | tag | 
  tag := Gtk.TextTag new: 'tagRed' in: text.
  tag property: 'foreground' value: 'red'.
  text applyTag: tag from: 5 to: 15.
!

onYourself
  self object: self
!

!

TestTextWindow testWindow!

Gtk GtkObject enterEventLoop; finalizeGtk!