PackageLoader fileInPackage: 'GstGtk'!

Gtk GtkObject initializeGtk !

Gtk.Window subclass: #ListTestWindow
	instanceVariableNames: 'object text'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

!ListTestWindow class methodsFor: 'experimentation'!

for: aObject
  ^(self new: ('T', self instanceCount printString)) object: aObject; buildWindow; yourself.
!

forItself
  | wnd |
  wnd := self new: ('T', self instanceCount printString).
  ^wnd object: wnd; buildWindow; yourself.
!

!

!ListTestWindow methodsFor: 'experimentation'!

buildModel
	| model |
	model := ListStore new.
	model 
		insertAt: 0;
		at: 0 column: 0 put: 'one';
		insertAt: 1;
		at: 1 column: 0 put: 'two';
		insertAt: 2;
		at: 2 column: 0 put: 'three'.
	^model
!

buildTreeViewIn: aContainer
	| tv col rend |
	tv := TreeView new: 'tv' in: aContainer.
	col := TreeViewColumn 
		newIn: tv 
		title: 'col1' 
		renderer: (TextCellRenderer new).
	^tv
!

buildWindow
	| btn vbox tv lbl hbox frame |
  
    Transcript print: 'Building window...'; cr.

    self property: 'border-width' value: 9.

    vbox := Gtk.VBox new: 'vbox1' in: self.

    lbl := Gtk.Label new: 'lblTop' in: vbox.
    lbl label: object printString.
    vbox child: lbl property: 'expand' value: false.

    frame := Gtk.Frame new: 'frame1' in: vbox.
    "frame property: 'shadow' value: 'in'."

    tv := self buildTreeViewIn: frame.
    tv model: self buildModel.

    hbox := Gtk.HBox new: 'hbox1' in: vbox.
    vbox child: hbox property: 'expand' value: false.

    btn := Gtk.Button new: 'btnEval' in: hbox.
    btn label: 'Evaluate'.
    btn connectSignal: 'clicked' to: self send: #evaluateCallback:.

    btn := Gtk.Button new: 'btnSnapshot' in: hbox.
    btn label: 'Save snapshot'.
    btn connectSignal: 'clicked' to: self send: #snapshotCallback:.

    btn := Gtk.Button new: 'btnClose' in: hbox.
    btn label: 'Close'.
    btn connectSignal: 'clicked' to: self send: #close:.
!

evaluateCallback: aSender
  | result toEval |
  toEval := text getText.
  Transcript print: 'Evaluating: ', toEval.
  result := Behavior 
    evaluate: toEval
    to: object 
    ifError: [ :fname :line :msg | Transcript print: msg. ^self ].
  InspectorWindow for: result.
!

snapshotCallback: aSender
  ObjectMemory snapshot: 'reload.im'.
!

object: aObject
  object := aObject.
!

onYourself
  self object: self
!

!

ListTestWindow for: nil!

Gtk GtkObject enterEventLoop; finalizeGtk!
