
PackageLoader fileInPackages: #('GstGtk' 'Parser')!

FileStream fileIn: 'CodeBuffer.st'!

Gtk.GtkObject initializeGtk!

Gtk.Window subclass: #TestCodeBufferWindow
	instanceVariableNames: 'object text fileEntry'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

!TestCodeBufferWindow class methodsFor: 'experimentation'!

testWindow
  | wnd |
  wnd := self new: ('T', self instanceCount printString).
  ^wnd buildWindow; yourself.
!

!

!TestCodeBufferWindow methodsFor: 'experimentation'!

buildWindow

 | btn vbox textView lbl hbox frame entry scroll |
  
    Transcript print: 'Building window...'; cr.

    self property: 'border-width' value: 9.

    vbox := Gtk.VBox new: 'vbox1' in: self.

    lbl := Gtk.Label new: 'lblTop' in: vbox.
    lbl label: object printString.
    vbox child: lbl property: 'expand' value: false.

    frame := Gtk.Frame new: 'frame1' in: vbox.
    "frame property: 'shadow' value: 'in'."

    scroll := Gtk.ScrolledWindow new: 'scroll' in: frame.
    scroll policy: 'automatic'.

    text := Gtk.CodeBuffer new.
    text class highlight: true.
    text inClass: UndefinedObject.
    text connectSignal: 'insert-text' to: self send: #textInsertedCallback:text:at:.
    text connectSignal: 'delete-range' to: self send: #rangeDeletedCallback:from:to:.

    textView := Gtk.TextView new: 'text1' in: scroll.
    "frame child: textView property: 'expand' value: true."
    "frame child: textView property: 'padding' value: 9."
    textView buffer: text.

    hbox := Gtk.HBox new: 'hbox0' in: vbox.
    vbox child: hbox property: 'expand' value: false.

    lbl := Gtk.Label new: 'lblFile' in: hbox label: 'File:'.
    hbox child: lbl property: 'expand' value: false.

    fileEntry := Gtk.Entry new: 'fileEntry' in: hbox.

    btn := Gtk.Button new: 'btnLoad' in: hbox.
    btn label: 'Load'.
    btn connectSignal: 'clicked' to: self send: #loadCallback:.

    hbox := Gtk.HBox new: 'hbox1' in: vbox.
    vbox child: hbox property: 'expand' value: false.

    btn := Gtk.Button new: 'btnSet' in: hbox.
    btn label: 'Set'.
    btn connectSignal: 'clicked' to: self send: #setCallback:.

    btn := Gtk.Button new: 'btnGet' in: hbox.
    btn label: 'Get'.
    btn connectSignal: 'clicked' to: self send: #getCallback:.

    btn := Gtk.Button new: 'btnHighlight' in: hbox.
    btn label: 'Highlight'.
    btn connectSignal: 'clicked' to: self send: #highlightCallback:.

    btn := Gtk.Button new: 'btnClose' in: hbox.
    btn label: 'Close'.
    btn connectSignal: 'clicked' to: self send: #close:.
!

textInsertedCallback: aSender text: aText at: aPosition
    Transcript print: 'Text: "', aText, '" at: ', aPosition printString; cr.
!

rangeDeletedCallback: aSender from: aStart to: aEnd
    Transcript print: 'Delete from: ', aStart printString, ' to: ', aEnd printString; cr.
!

setCallback: aSender
  | result toEval |
  text setText: 'Smalltalk at: #testing put: [ 1 + 2 + 3 ] value.'.
!

getCallback: aSender
  Transcript cr; print: (text getText); cr; print: (text getSelection).
!

loadCallback: aSender
  | filename file |
  filename := fileEntry getText.
  Transcript cr; print: 'Loading: ', filename; cr.
  file := (File name: filename) contents.
  Transcript print: file; cr.
  text setText: file.
!

highlightCallback: aSender
  text rehighlight.
!

onYourself
  self object: self
!

!

TestCodeBufferWindow testWindow!

Gtk GtkObject enterEventLoop; finalizeGtk!
