Gtk GtkObject initializeGtk !

Gtk.Window subclass: #InspectorWindow
	instanceVariableNames: 'object text'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

!InspectorWindow class methodsFor: 'experimentation'!

for: aObject
  ^(self new: ('IW', self instanceCount printString)) object: aObject; buildWindow; yourself.
!

forItself
  | wnd |
  wnd := self new: ('E', self instanceCount printString).
  ^wnd object: wnd; buildWindow; yourself.
!

!

!InspectorWindow methodsFor: 'experimentation'!

buildWindow

 | btn vbox textView lbl hbox frame |
  
    Transcript print: 'Building window...'; cr.

    self property: 'border-width' value: 9.

    vbox := Gtk.VBox new: 'vbox1' in: self.

    lbl := Gtk.Label new: 'lblTop' in: vbox.
    lbl label: object printString.
    vbox child: lbl property: 'expand' value: false.

    frame := Gtk.Frame new: 'frame1' in: vbox.
    "frame property: 'shadow' value: 'in'."

    text := Gtk.TextBuffer new.

    textView := Gtk.TextView new: 'text1' in: frame.
    "frame child: textView property: 'expand' value: true."
    "frame child: textView property: 'padding' value: 9."
    textView buffer: text.

    hbox := Gtk.HBox new: 'hbox1' in: vbox.
    vbox child: hbox property: 'expand' value: false.

    btn := Gtk.Button new: 'btnEval' in: hbox.
    btn label: 'Evaluate'.
    btn connectSignal: 'clicked' to: self send: #evaluateCallback:.

    btn := Gtk.Button new: 'btnSnapshot' in: hbox.
    btn label: 'Save snapshot'.
    btn connectSignal: 'clicked' to: self send: #snapshotCallback:.

    btn := Gtk.Button new: 'btnClose' in: hbox.
    btn label: 'Close'.
    btn connectSignal: 'clicked' to: self send: #close:.
!

evaluateCallback: aSender
  | result toEval |
  toEval := text getText.
  Transcript print: 'Evaluating: ', toEval.
  result := Behavior 
    evaluate: toEval
    to: object 
    ifError: [ :fname :line :msg | Transcript print: msg. ^self ].
  InspectorWindow for: result.
!

snapshotCallback: aSender
  ObjectMemory snapshot: 'reload.im'.
!

object: aObject
  object := aObject.
!

onYourself
  self object: self
!

!
