Gtk GtkObject initializeGtk !

Gtk.Window subclass: #EvaluatorWindow
	instanceVariableNames: 'object buffers bufferLabel currentBuffer text textView list map'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Browser-Windows'!

!EvaluatorWindow class methodsFor: 'experimentation'!

for: aObject
  ^(self new: ('E', self instanceCount printString)) object: aObject; buildWindow; yourself.
!

forItself
  | wnd |
  wnd := self new: ('E', self instanceCount printString).
  ^wnd object: wnd; buildWindow; yourself.
!

!

!EvaluatorWindow methodsFor: 'experimentation'!

map
    map isNil ifTrue: [ map := Dictionary new ].
    ^map.
!

keyStringFor: aObject
    ^aObject printString, ' (', aObject class printString, ')'.
!

text: aBuffer
    text := aBuffer.
    textView buffer: text.
    ^text.
!

textInsertedCallback: aSender text: aText at: aPosition
    Transcript print: 'Text: "', aText, '" at: ', aPosition printString; cr.
!

rangeDeletedCallback: aSender from: aStart to: aEnd
    Transcript print: 'Delete from: ', aStart printString, ' to: ', aEnd printString; cr.
!

newBuffer
    | buf |
    buf := Gtk.TextBuffer new.
    buf connectSignal: 'insert-text' to: self send: #textInsertedCallback:text:at:.
    buf connectSignal: 'delete-range' to: self send: #rangeDeletedCallback:from:to:.
    buffers add: buf.
    ^self currentBuffer: buffers size.
!

currentBuffer: aIndex
    | buf |
    buf := buffers at: aIndex.
    currentBuffer := aIndex.
    bufferLabel label: aIndex printString.
    ^self text: buf.
!

nextBuffer 
    (currentBuffer = buffers size) ifTrue: [ ^self newBuffer ].
    ^self currentBuffer: currentBuffer + 1.
!

prevBuffer 
    (currentBuffer = 1) ifTrue: [ ^text ].
    ^self currentBuffer: (currentBuffer - 1).
!

addToList: aObject
    | str i |
    str := self keyStringFor: aObject.
    "i := map size.
    list 
	 insertAt: i; 
	 at: i column: 0 put: str."
    list
	insertAt: 0; 
	at: 0 column: 0 put: str.
    self map at: str put: aObject.
    self object: aObject.
!

buildWindow

 | btn vbox treeView lbl hbox frame scroll mb mnu mi |
  
    Transcript print: 'Building window...'; cr.

    self property: 'border-width' value: 9.

    vbox := Gtk.VBox new: 'vbox1' in: self.

    hbox := Gtk.HBox new: 'hbox2' in: vbox.
    vbox child: hbox property: 'expand' value: false.

    lbl := Gtk.Label new: 'lblTop' in: hbox.
    lbl label: 'Evaluate'.
    "vbox child: lbl property: 'expand' value: false."

    btn := Gtk.Button new: 'btnBack' in: hbox.
    btn label: '<'.
    "btn property: 'relief' value: (btn class enum: 'GtkReliefStyle' value: 'none')."
    btn connectSignal: 'clicked' to: self send: #backCallback:.
    hbox child: btn property: 'expand' value: false.

    bufferLabel := Gtk.Label new: 'lblBuffer' in: hbox.
    bufferLabel label: '1'.
    hbox child: bufferLabel property: 'expand' value: false.
    hbox child: bufferLabel property: 'padding' value: 6.

    btn := Gtk.Button new: 'btnFwd' in: hbox.
    btn label: '>'.
    "btn property: 'relief' value: (btn class enum: 'GtkReliefStyle' value: 'none')."
    btn connectSignal: 'clicked' to: self send: #forwardCallback:.
    hbox child: btn property: 'expand' value: false.

    frame := Gtk.Frame new: 'frame1' in: vbox.
    "frame property: 'shadow' value: 'in'."

    textView := Gtk.TextView new: 'text1' in: frame.

    buffers := OrderedCollection new.
    self newBuffer.
   
    lbl := Gtk.Label new: 'lblResults' in: vbox.
    lbl label: 'Results'.
    vbox child: lbl property: 'expand' value: false.

    frame := Gtk.Frame new: 'frameList' in: vbox.

    scroll := Gtk.ScrolledWindow new: 'scroll1' in: frame.
    scroll
	property: 'hscrollbar-policy' 
	value: (self class enum: 'GtkPolicyType' value: 'automatic').
    scroll
	property: 'vscrollbar-policy' 
	value: (self class enum: 'GtkPolicyType' value: 'automatic').

    list := Gtk.ListStore new.

    treeView := Gtk.TreeView new: 'tv' in: scroll.
    TreeViewColumn newIn: treeView title: 'self' renderer: (Gtk.TextCellRenderer new).
    treeView property: 'headers-visible' value: false.
    treeView model: list.

    treeView connectSignal: 'row-activated' to: self send: #rowActivatedCallback:path: .
    treeView connectSignal: 'selection-changed' to: self send: #selectionChangedCallback:path: .

    hbox := Gtk.HBox new: 'hbox1' in: vbox.
    vbox child: hbox property: 'expand' value: false.

    btn := Gtk.Button new: 'btnEval' in: hbox.
    btn label: 'Evaluate'.
    btn connectSignal: 'clicked' to: self send: #evaluateCallback:.

    btn := Gtk.Button new: 'btnSnapshot' in: hbox.
    btn label: 'Save snapshot'.
    btn connectSignal: 'clicked' to: self send: #snapshotCallback:.

    btn := Gtk.Button new: 'btnClose' in: hbox.
    btn label: 'Close'.
    btn connectSignal: 'clicked' to: self send: #close:.

    mb := self addMenuBar.
    mnu := Gtk.Menu new: 'mSmalltalk' label: 'Smalltalk' inMenuBar: mb.
    mnu addItem: (Gtk.MenuItem new: 'miSnapshot' label: 'Snapshot').
    Gtk.MenuItem new: 'miCloseAll' label: 'Close All' in: mnu.
!

backCallback: aSender
    self prevBuffer.
!

forwardCallback: aSender
    self nextBuffer.
!

selectionChangedCallback: aSender path: aPath
    | sel |
    sel := list path: aPath column: 0.
    self object: (map at: sel).
!

rowActivatedCallback: aSender path: aPath
    EvaluatorWindow for: object.
!

evaluateCallback: aSender
  | result toEval |
  toEval := text getText.
  Transcript print: 'Evaluating: ', toEval.
  result := Behavior 
    evaluate: toEval
    to: object 
    ifError: [ :fname :line :msg | Transcript print: msg. ^self ].
  self addToList: result.
  self newBuffer.
!

snapshotCallback: aSender
  ObjectMemory snapshot: 'reload.im'.
!

object: aObject
  object := aObject.
!

onYourself
  self object: self
!

!

