/* gst-gtk module */
/* Functions to be called from Smalltalk */

#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include "gstpub.h"
#include "global.h"

VMProxy *smalltalk_vm_proxy;

extern int
gst_gtk_enum_get_value(char *enum_name, char *enum_nick)
{
  GType enum_type;
  GEnumClass *enum_class;
  GEnumValue *enum_value;

  enum_type = gtk_type_from_name(enum_name);
  if (!G_TYPE_IS_ENUM (enum_type)) {
    fprintf(stderr, "'%s' is not a recognized enumeration type.", enum_name);
    return(-1);
  }
  enum_class = gtk_type_class (enum_type);
  enum_value = g_enum_get_value_by_nick(enum_class, enum_nick);
  if (!enum_value) {
    fprintf(stderr, "'%s' is not a recognized nick for enumeration %s.", enum_nick, enum_name);
    return(-1);
  }
  return(enum_value->value);
}

void
_value_init_from_oop(GValue *value, OOP oop, GType type)
{
  GType parent_type;
  gboolean value_set;

  /* Initialize value. Avoid GLib warning if initialized value is passed in */
  if (!G_IS_VALUE(value))
    g_value_init(value, type);
  parent_type = type;
  /* Set value. May need to work up type hierarchy to find a type we can set as */
  do {
    value_set = TRUE;
    switch ((int)parent_type)
    {
      case G_TYPE_STRING:
        g_value_set_string(value, smalltalk_vm_proxy->OOPToString(oop));
        break;
      case G_TYPE_BOOLEAN:
        g_value_set_boolean(value, smalltalk_vm_proxy->OOPToBool(oop));
        break;
      case G_TYPE_INT:
        g_value_set_int(value, (gint)smalltalk_vm_proxy->OOPToInt(oop));
        break;
      case G_TYPE_UINT:
        g_value_set_uint(value, (gint)smalltalk_vm_proxy->OOPToInt(oop));
        break;
      case G_TYPE_LONG:
        g_value_set_ulong(value, smalltalk_vm_proxy->OOPToInt(oop));
        break;
      case G_TYPE_ULONG:
        g_value_set_long(value, smalltalk_vm_proxy->OOPToInt(oop));
        break;
      case G_TYPE_FLOAT:
        g_value_set_float(value, (gfloat)smalltalk_vm_proxy->OOPToFloat(oop));
        break;
      case G_TYPE_DOUBLE:
        g_value_set_float(value, smalltalk_vm_proxy->OOPToFloat(oop));
        break;
      case G_TYPE_ENUM:
        g_value_set_enum(value, smalltalk_vm_proxy->OOPToInt(oop));
        break;
      /* pointers and objects? */
      /* default: some error handling */
      default:
        /* Try parent type (for eg. enums) */
        value_set = FALSE;
        parent_type = g_type_parent(parent_type);
    }
  } while ((!value_set) && (parent_type));
  if (!value_set)
    fprintf(stderr, "GValue (type %s), initialized but not set.\n", g_type_name(type));
}

OOP
_oop_from_value(GValue *value)
{
  GType parent_type;
  GType type;
  OOP result;

  result = NULL;
  parent_type = type = G_VALUE_TYPE(value);
  /* Get value. May need to work up type hierarchy to find a type we can get as */
  do {
    switch ((int)parent_type)
    {
      case G_TYPE_STRING:
        result = smalltalk_vm_proxy->stringToOOP(g_value_get_string(value));
        break;
      case G_TYPE_BOOLEAN:
        result = smalltalk_vm_proxy->boolToOOP(g_value_get_boolean(value));
        break;
      case G_TYPE_INT:
        result = smalltalk_vm_proxy->intToOOP(g_value_get_int(value));
        break;
      case G_TYPE_UINT:
        result = smalltalk_vm_proxy->intToOOP(g_value_get_uint(value));
        break;
      case G_TYPE_LONG:
        result = smalltalk_vm_proxy->intToOOP(g_value_get_long(value));
        break;
      case G_TYPE_ULONG:
        result = smalltalk_vm_proxy->intToOOP(g_value_get_ulong(value));
        break;
      case G_TYPE_FLOAT:
        result = smalltalk_vm_proxy->floatToOOP(g_value_get_float(value));
        break;
      case G_TYPE_DOUBLE:
        result = smalltalk_vm_proxy->floatToOOP(g_value_get_double(value));
        break;
      case G_TYPE_ENUM:
        result = smalltalk_vm_proxy->intToOOP(g_value_get_enum(value));
        break;
      /* pointers and objects? */
      /* default: some error handling */
      default:
        /* Try parent type (for eg. enums) */
        parent_type = g_type_parent(parent_type);
    }
  } while ((result == NULL) && (parent_type));
  if (!result)
    fprintf(stderr, "Could not convert GValue (type %s) to an OOP.\n", g_type_name(type));
  return(result);
}
