#include <stdlib.h>
#include <glib-object.h>
#include "global.h"
#include "callbacks.h" 

GHashTable *_callbacks;

void _cleanup_callback_key(gpointer data);
void _cleanup_callback_value(gpointer data);

void _initialize_callbacks()
{
  _callbacks = g_hash_table_new_full(
    g_str_hash,
    g_str_equal,
    _cleanup_callback_key,
    _cleanup_callback_value
  );
}

void _add_callback(char *key, GstGtkCallback *cb) 
{
  g_hash_table_insert(_callbacks, key, cb);
}

void _remove_callback(char *key)
{
  g_hash_table_remove(_callbacks, key);
}

GstGtkCallback *_get_callback(char *key)
{
  return(g_hash_table_lookup(_callbacks, key));
}

void
_cleanup_callbacks(void)
{
  /* Notify functions free keys and values */
  g_hash_table_destroy(_callbacks);
}

void 
_cleanup_callback_key(gpointer data)
{
  free(data);
}

void 
_cleanup_callback_value(gpointer data)
{
  GstGtkCallback *cb;

  cb = (GstGtkCallback *)data;
  smalltalk_vm_proxy->unregisterOOP (smalltalk_vm_proxy->idToOOP(cb->st_signal));
  free(cb);
}
