/* gst-gtk module */
/* Functions to be called from Smalltalk */

#include <stdlib.h>
#include <stdio.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "gstpub.h"
#include "global.h"
#include "callbacks.h"
#include "basic.h"
#include "widgets.h"
#include "text.h"
#include "tree.h"
#include "menus.h"

void _gst_gtk_ref_all_types(void);

void
gst_initModule(VMProxy *proxy)
{
  smalltalk_vm_proxy = proxy;
#include "definecfuncs.inc"
  /*#include "widgets.inc"
#include "text.inc"
#include "tree.inc"
#include "menus.inc"*/
}

void
gst_gtk_initialize(void)
{
  int argc = 1;
  gchar *argvArray[] = { "gst", NULL };
  gchar **argv = argvArray;
  gtk_init (&argc, &argv);
  g_type_init();
  _gst_gtk_ref_all_types();
  _initialize_callbacks();
}

void
gst_gtk_finalize(void)
{
  _cleanup_callbacks();
}

void
gst_gtk_dispatch_events(void)
{
  /* Call main loop repeatedly */
  while (gtk_events_pending())
    gtk_main_iteration();
}

void
_gst_gtk_ref_all_types(void)
{
  /* This should be an exhaustive list of all of the non-abstract Gtk widget types.
     It's not terribly elegant to do it this way, but YAGNI */

  g_type_class_ref(GTK_TYPE_WIDGET);
  g_type_class_ref(GTK_TYPE_WINDOW);
  g_type_class_ref(GTK_TYPE_BUTTON);
  g_type_class_ref(GTK_TYPE_LABEL);
  g_type_class_ref(GTK_TYPE_VBOX);
  g_type_class_ref(GTK_TYPE_HBOX);

  /*g_type_class_ref(GTK_TYPE_MISC);*/
  g_type_class_ref(GTK_TYPE_LABEL);
  g_type_class_ref(GTK_TYPE_ACCEL_LABEL);
  g_type_class_ref(GTK_TYPE_TIPS_QUERY);
  g_type_class_ref(GTK_TYPE_ARROW);
  g_type_class_ref(GTK_TYPE_IMAGE);
  g_type_class_ref(GTK_TYPE_PIXMAP);
  /*g_type_class_ref(GTK_TYPE_CONTAINER);
  g_type_class_ref(GTK_TYPE_BIN);*/
  g_type_class_ref(GTK_TYPE_ALIGNMENT);
  g_type_class_ref(GTK_TYPE_FRAME);
  g_type_class_ref(GTK_TYPE_ASPECT_FRAME);
  g_type_class_ref(GTK_TYPE_BUTTON);
  g_type_class_ref(GTK_TYPE_TOGGLE_BUTTON);
  g_type_class_ref(GTK_TYPE_CHECK_BUTTON);
  g_type_class_ref(GTK_TYPE_RADIO_BUTTON);
  g_type_class_ref(GTK_TYPE_OPTION_MENU);
  /*g_type_class_ref(GTK_TYPE_ITEM);*/
  g_type_class_ref(GTK_TYPE_MENU_ITEM);
  g_type_class_ref(GTK_TYPE_CHECK_MENU_ITEM);
  g_type_class_ref(GTK_TYPE_RADIO_MENU_ITEM);
  g_type_class_ref(GTK_TYPE_IMAGE_MENU_ITEM);
  g_type_class_ref(GTK_TYPE_SEPARATOR_MENU_ITEM);
  g_type_class_ref(GTK_TYPE_TEAROFF_MENU_ITEM);
  g_type_class_ref(GTK_TYPE_LIST_ITEM);
  /*g_type_class_ref(GTK_TYPE_TREE_ITEM);*/
  g_type_class_ref(GTK_TYPE_WINDOW);
  g_type_class_ref(GTK_TYPE_DIALOG);
  g_type_class_ref(GTK_TYPE_COLOR_SELECTION_DIALOG);
  g_type_class_ref(GTK_TYPE_FILE_SELECTION);
  g_type_class_ref(GTK_TYPE_FONT_SELECTION_DIALOG);
  g_type_class_ref(GTK_TYPE_INPUT_DIALOG);
  g_type_class_ref(GTK_TYPE_MESSAGE_DIALOG);
  g_type_class_ref(GTK_TYPE_PLUG);
  g_type_class_ref(GTK_TYPE_EVENT_BOX);
  g_type_class_ref(GTK_TYPE_HANDLE_BOX);
  g_type_class_ref(GTK_TYPE_SCROLLED_WINDOW);
  g_type_class_ref(GTK_TYPE_VIEWPORT);
  /*g_type_class_ref(GTK_TYPE_BOX);
  g_type_class_ref(GTK_TYPE_BUTTON_BOX);*/
  g_type_class_ref(GTK_TYPE_HBUTTON_BOX);
  g_type_class_ref(GTK_TYPE_VBUTTON_BOX);
  g_type_class_ref(GTK_TYPE_VBOX);
  g_type_class_ref(GTK_TYPE_COLOR_SELECTION);
  g_type_class_ref(GTK_TYPE_FONT_SELECTION);
  g_type_class_ref(GTK_TYPE_GAMMA_CURVE);
  g_type_class_ref(GTK_TYPE_HBOX);
  g_type_class_ref(GTK_TYPE_COMBO);
  g_type_class_ref(GTK_TYPE_STATUSBAR);
  g_type_class_ref(GTK_TYPE_CLIST);
  g_type_class_ref(GTK_TYPE_CTREE);
  g_type_class_ref(GTK_TYPE_FIXED);
  /*g_type_class_ref(GTK_TYPE_PANED);*/
  g_type_class_ref(GTK_TYPE_HPANED);
  g_type_class_ref(GTK_TYPE_VPANED);
  g_type_class_ref(GTK_TYPE_LAYOUT);
  g_type_class_ref(GTK_TYPE_LIST);
  g_type_class_ref(GTK_TYPE_MENU_SHELL);
  g_type_class_ref(GTK_TYPE_MENU_BAR);
  g_type_class_ref(GTK_TYPE_MENU);
  g_type_class_ref(GTK_TYPE_NOTEBOOK);
  g_type_class_ref(GTK_TYPE_SOCKET);
  g_type_class_ref(GTK_TYPE_TABLE);
  g_type_class_ref(GTK_TYPE_TEXT_VIEW);
  g_type_class_ref(GTK_TYPE_TOOLBAR);
  /*g_type_class_ref(GTK_TYPE_TREE);*/
  g_type_class_ref(GTK_TYPE_TREE_VIEW);
  g_type_class_ref(GTK_TYPE_CALENDAR);
  g_type_class_ref(GTK_TYPE_DRAWING_AREA);
  g_type_class_ref(GTK_TYPE_CURVE);
  g_type_class_ref(GTK_TYPE_ENTRY);
  g_type_class_ref(GTK_TYPE_SPIN_BUTTON);
  /*g_type_class_ref(GTK_TYPE_RULER);*/
  g_type_class_ref(GTK_TYPE_HRULER);
  g_type_class_ref(GTK_TYPE_VRULER);
  g_type_class_ref(GTK_TYPE_RANGE);
  /*g_type_class_ref(GTK_TYPE_SCALE);*/
  g_type_class_ref(GTK_TYPE_HSCALE);
  g_type_class_ref(GTK_TYPE_VSCALE);
  /*g_type_class_ref(GTK_TYPE_SCROLLBAR);*/
  g_type_class_ref(GTK_TYPE_HSCROLLBAR);
  g_type_class_ref(GTK_TYPE_VSCROLLBAR);
  /*g_type_class_ref(GTK_TYPE_SEPARATOR);*/
  g_type_class_ref(GTK_TYPE_HSEPARATOR);
  g_type_class_ref(GTK_TYPE_VSEPARATOR);
  /*g_type_class_ref(GTK_TYPE_INVISIBLE);
  g_type_class_ref(GTK_TYPE_OLDEDITABLE);*/
  /*g_type_class_ref(GTK_TYPE_TEXT);*/
  g_type_class_ref(GTK_TYPE_PREVIEW);
  g_type_class_ref(GTK_TYPE_PROGRESS);
  g_type_class_ref(GTK_TYPE_PROGRESS_BAR);
  g_type_class_ref(GTK_TYPE_ADJUSTMENT);
  /*g_type_class_ref(GTK_TYPE_CELLRENDERER);
  g_type_class_ref(GTK_TYPE_CELLRENDERERPIXBUF);
  g_type_class_ref(GTK_TYPE_CELLRENDERERTEXT);
  g_type_class_ref(GTK_TYPE_CELLRENDERERTOGGLE);
  g_type_class_ref(GTK_TYPE_ITEMFACTORY);*/
  g_type_class_ref(GTK_TYPE_TOOLTIPS);
  g_type_class_ref(GTK_TYPE_TREE_VIEW_COLUMN);
}

