"----- Class declarations -----"

Widget subclass: #Container
	instanceVariableNames: 'children childProperties'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Container subclass: #Bin
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Bin subclass: #Window
	instanceVariableNames: ''
	classVariableNames: 'windows'
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Bin subclass: #Button
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Button subclass: #ToggleButton
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Button subclass: #RadioButton
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Button subclass: #CheckButton
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Bin subclass: #Alignment
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Container subclass: #Box
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Box subclass: #HBox
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Box subclass: #VBox
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Bin subclass: #ScrolledWindow
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Bin subclass: #Viewport
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Widget subclass: #Label
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Bin subclass: #Frame
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

Widget subclass: #Entry
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

!"----- Container -----"

"void gst_gtk_container_add(void *aContainer, void *aWidget);"
Container class
        defineCFunc: 'gst_gtk_container_add'
        withSelectorArgs: 'cContainer: aContainer add: aWidget'
        returning: #void
        args: #(#cObject #cObject)
!

"void gst_gtk_container_remove(void *aContainer, void *aWidget);"
Container class
        defineCFunc: 'gst_gtk_container_remove'
        withSelectorArgs: 'cContainer: aContainer remove: aWidget'
        returning: #void
        args: #(#cObject #cObject)
!

"void gst_gtk_set_child_property(void *aContainer, void *aChild, char *aProperty, OOP aValue);"
Container class
        defineCFunc: 'gst_gtk_set_child_property'
        withSelectorArgs: 'cContainer: aWidget child: aChild property: aProperty value: aValue'
        returning: #void
        args: #(#cObject #cObject #string #smalltalk)
!

"OOP gst_gtk_get_child_property(void *aContainer, void *aChild, char *aProperty);"
Container class
        defineCFunc: 'gst_gtk_get_child_property'
        withSelectorArgs: 'cContainer: aWidget child: aChild property: aProperty'
        returning: #smalltalk
        args: #(#cObject #cObject #string)
!

!Container methodsFor: 'initialization' !

restoreGtkLinks
  "Restores child properties. Called when the image is reloaded."
  | toRestore |

  super restoreGtkLinks.

  self children do: [ :each | self class cContainer: self gtk add: each gtk ].

  "Set any child properties that are not the defaults"
  childProperties isNil 
    ifFalse: [
      Transcript print: 'Restoring ', childProperties size printString,
        ' childrens'' properties for ', self name, '.'.
      toRestore := childProperties.
      childProperties := Dictionary new.
      toRestore keysAndValuesDo: [ :child :props |
        props keysAndValuesDo: [ :prop :value |
          self child: child property: prop value: value
        ]
      ].
    ].
!

restoreAllGtkLinks
  self restoreGtkLinks.
  self children do: [ :each | each restoreAllGtkLinks ].
!
!

!Container methodsFor: 'containers'!

children
  ^children ifNil: [ children := Set new ].
!

add: aWidget
  self class cContainer: self gtk add: aWidget gtk.
  (self children includes: aWidget) ifFalse: [ self children add: aWidget ].
  ^aWidget.
!

remove: aWidget
  self children remove: aWidget ifAbsent: [ nil ].
  self class cContainer: self gtk remove: aWidget gtk.
  ^aWidget.
!

removeNamed: aName
  | wgt |
  wgt := self children detect: [ :each | each name = aName ] ifNone: [ ^nil ].
  ^self remove: wgt.
!

childNamed: aName
  ^self children detect: [ :each |  each name = aName ] ifNone: [ nil ].
!

findChild: aName
  ^self allChildrenDo: [ :each | 
    each name = aName ifTrue: [ ^each ] 
  ].
!

findWidget: aName
  self name = aName ifTrue: [ ^self ].
  ^self findChild: aName.
!

child: aChild property: aProperty value: aValue
  childProperties isNil ifTrue: [childProperties := Dictionary new].
  (childProperties at: aChild ifAbsentPut: [Dictionary new])
    at: aProperty put: aValue.
  self class cContainer: self gtk child: aChild gtk property: aProperty value: aValue.
!

child: aChild property: aProperty
  ^self class cContainer: self gtk child: aChild gtk property: aProperty.
!

child: aChild expand: aValue
  self child: aChild property: 'expand' value: aValue.
!

child: aChild fill: aValue
  self child: aChild property: 'fill' value: aValue.
!

child: aChild padding: aValue
  self child: aChild property: 'padding' value: aValue.
!

childrenDo: aBlock
  self children do: aBlock.
!

allChildrenDo: aBlock
  | todo |
  todo := OrderedCollection new.
  todo add: self.
  [ todo isEmpty ] whileFalse: [ | first |
    first := todo removeFirst.
    aBlock value: first.
    first isContainer ifTrue: [ first childrenDo: [ :each | todo add: each ] ].
  ]
!

!Container methodsFor: 'testing'!

isContainer
  ^true.
!

!"----- Bin -----"

!Bin methodsFor: 'containers'!

hasChild
    children isNil ifTrue: [ ^false ].
    children isEmpty ifTrue: [ ^false ].
    ^true.
!

child
    children isNil ifTrue: [ ^nil ].
    children isEmpty ifTrue: [ ^nil ].
    ^children anyOne.
!

child: aChild
    self child ifNotNil: [ :ch | 
	Transcript print: 'removing: ', ch printString.
	self remove: ch 
    ].
    Transcript print: 'adding: ', aChild printString.    
    ^self add: aChild.
!
!
  
!"----- Window -----"
"----- Window CFuncs -----"

"void *gst_gtk_destroy_window(void *aWidget);"
Window class
        defineCFunc: 'gst_gtk_destroy_window'
        withSelectorArgs: 'cDestroyWindow: aWidget'
        returning: #void
        args: #(#cObject)
!

!Window class methodsFor: 'instance creation'!

new: aName
  (self windows includesKey: aName) ifTrue:
    [ self error: 'A window named ''', aName, ''' already exists' ].
  ^windows at: aName put: (super new: aName).
!

widgetType
  ^'GtkWindow'.
!

windows
  ^(windows ifNil: [windows := Dictionary new])
!
!

!Window methodsFor: 'destruction'!

destroyWidget
  gtk isNil ifFalse: [ self class cDestroyWindow: gtk ].
!

destroy
  "Is it necessary to hide the window? 
  self visible: false."
  "Calls destroyWidget, which results in widgetDestroyed, which will stop the 
   event loop, if no more windows exist"
  super destroy.
!

widgetDestroyed
  "Callback from gtk when widget destroyed (eg. window closed)"
  self class windows removeKey: self name.
  self class windows isEmpty ifTrue: [ GtkObject stopEventLoop ].
!
!

!Window class  methodsFor: 'loading and saving'!

registerInitEvents
  self == Window ifFalse: [ ^self ].
  GtkObject registerInitEvent: (DirectedMessage selector: #restoreAllGtkLinks arguments: #() receiver: self)
	    priority: 3.
!

restoreAllGtkLinks
  self windows do: [ :wnd | wnd restoreAllGtkLinks ].
!
!

!Window class methodsFor: 'window list'!

windowNamed: aName
  ^self windows at: aName
!

allWindowNames
  ^self windows keys
!

allWindows
  ^self windows values
!
!

!Window methodsFor: 'common properties'!

title: aTitle
  self property: 'title' value: aTitle.
!

!Window methodsFor: 'convenience events'!

close: aSender
  Transcript print: 'Closing window'. "DEBUG"
  self destroy.
!

!Window methodsFor: 'testing'!

isWindow
  ^true.
!
!

!Window methodsFor: 'menus'!

addMenuBar: aMenuBar
    | ch client bw |
    "For convenience inserts a VBox as the direct child of the window, adds
     a MenuBar, and then the previous window child."
    ch := self child.
    client := self child: (Gtk.VBox new: self name, '_clientarea').
    bw := self property: 'border-width'.
    self property: 'border-width' value: 0.
    client add: aMenuBar.
    client child: aMenuBar property: 'expand' value: false.
    ch notNil ifTrue: [ 
	client add: ch.  
	ch isContainer ifTrue: [ ch property: 'border-width' value: bw ].
    ].
    ^aMenuBar
!

addMenuBar
    ^self addMenuBar: (Gtk.MenuBar new: self name, '_menubar').
!

clientArea
    ^self childNamed: self name, '_clientarea'.
!
!

!"----- Button -----"
!Button class methodsFor: 'instance creation'!

widgetType
  ^'GtkButton'.
!

!Button methodsFor: 'common properties'!

label: aLabel
  self property: 'label' value: aLabel.
!

label
  ^self property: 'label'.
!

!"----- ToggleButton -----"
ToggleButton class methodsFor: 'instance creation'!

widgetType
  ^'GtkToggleButton'.
!

!"----- RadioButton -----"
RadioButton class methodsFor: 'instance creation'!

widgetType
  ^'GtkRadioButton'.
!

!"----- CheckButton -----"
CheckButton class methodsFor: 'instance creation'!

widgetType
  ^'GtkCheckButton'.
!

!"----- Alignment -----"
Alignment class methodsFor: 'instance creation'!

widgetType
  ^'GtkAlignment'.
! !

Alignment methodsFor: 'geometry management'!

x: xalign y: yalign
  self
    property: 'xalign' value: xalign;
    property: 'yalign' value: yalign.
!

xscale: xscale yscale: yscale
  self
    property: 'xscale' value: xscale;
    property: 'yscale' value: yscale.
!

centre
  self x: 0.5 y: 0.5.
!

normal
  self xscale: 0.0 yscale: 0.0.
!

left
  self x: 0.0 y: 0.5
!

right
  self x: 1.0 y: 0.5
!

top
  self x: 0.5 y: 0.0
!

bottom
  self x: 0.5 y: 1.0
!

!"----- Box -----"

!Box methodsFor: 'containers'!

children
  ^children ifNil: [ children := Set new ].
!

child: aChild position: aValue
  self child: aChild property: 'position' value: aValue.
!
!

!"----- HBox -----"
!HBox class methodsFor: 'instance creation'!

widgetType
  ^'GtkHBox'.
!

!"----- VBox -----"
!VBox class methodsFor: 'instance creation'!

widgetType
  ^'GtkVBox'.
!

!"----- ScrolledWindow -----"
!ScrolledWindow class methodsFor: 'instance creation'!

widgetType
  ^'GtkScrolledWindow'.
!

!ScrolledWindow methodsFor: 'common properties'!

policy: aPolicy
  | val |
  val := self class enum: 'GtkPolicyType' value: aPolicy.
  #('vscrollbar-policy' 'hscrollbar-policy') do: [ :each |
    self property: each value: val
  ]

!

!"----- Viewport -----"
!Viewport class methodsFor: 'instance creation'!

widgetType
  ^'GtkViewport'.
!

!"----- Label -----"
!Label class methodsFor: 'instance creation'!

new: aName in: aParent label: aLabel 
    ^(self new: aName in: aParent) label: aLabel; yourself.
!

new: aName label: aLabel
    ^(self new: aName) label: aLabel; yourself.
!

widgetType
  ^'GtkLabel'.
!

!Label methodsFor: 'common properties'!

label: aLabel
  self property: 'label' value: aLabel.
!

label
  ^self property: 'label'.
!

!"----- Frame -----"
Frame class methodsFor: 'instance creation'!

widgetType
  ^'GtkFrame'.
! !

Frame methodsFor: 'common properties'!

shadow: aShadow
  "Possible values are 'in', 'out', 'etched-in', 'etched-out'"
  | val |
  val := (aShadow isString)
    ifTrue: [self class enum: 'GtkShadowType' value: aShadow]
    ifFalse: [aShadow].
  self property: 'shadow' value: val.
!

shadow
  "Returned as integer - convert to string?"
  ^self property: 'shadow'.

! !

!"----- Entry -----"
Entry class methodsFor: 'instance creation'!

widgetType
  ^'GtkEntry'.
! !

Entry methodsFor: 'accessing'!

getText
  ^self property: 'text'.
! !
