Widget subclass: #TreeView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

GtkObject subclass: #TreeModel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

TreeModel subclass: #TreeStore
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

TreeModel subclass: #ListStore
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

GtkObject subclass: #TreeViewColumn
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

"CellRenderer is worth having as a distinct class, as there are many 
 properties that affect how the text is rendered" 
GtkObject subclass: #CellRenderer 
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

CellRenderer subclass: #TextCellRenderer 
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

Signal subclass: #RowActivatedSignal
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

Signal subclass: #SelectionChangedSignal
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

!"----- TreeView -----"
!TreeView class methodsFor: 'instance creation'!

widgetType
  ^'GtkTreeView'.
! !
                                             
TreeView  class defineCFunc: 'gst_gtk_tree_view_set_model' 
    withSelectorArgs: 'cTreeView: aView setModel: aModel' 
    returning: #void 
    args: #(#cObject #cObject)! 

!TreeView methodsFor: 'initializaton'!

model: aModel
  self class cTreeView: self gtk setModel: aModel gtk.
!
!

!TreeView methodsFor: 'signals'!

connectSignal: aSignal to: aReceiver send: aSelector
  (aSignal match: 'row-activated') ifTrue: [
    self addSignal: 
      (RowActivatedSignal new on: aSignal from: self send: aSelector asSymbol to: aReceiver).
    ^self.
  ].
  (aSignal match: 'selection-changed') ifTrue: [
    "Signal is actually 'changed' from the selection, not the view itself"
    self addSignal: 
      (SelectionChangedSignal new on: aSignal from: self send: aSelector asSymbol to: aReceiver).
    ^self.
  ].

  super connectSignal: aSignal to: aReceiver send: aSelector.
!
!

!"----- TreeModel -----"

TreeModel class defineCFunc: 'gst_gtk_tree_model_get' 
    withSelectorArgs: 'cTreeModel: aModel path: aPath column: aColumn' 
    returning: #smalltalk 
    args: #(#cObject #string #int)! 

!TreeModel class methodsFor: 'instance creation'!

new
  ^(self basicNew) createGtk; yourself.
!
!

!TreeModel methodsFor: 'accessing'!

path: aPath column: aColumn
    "Returns the value at the specified path and column"
    "paths are 0-based, colon-separated, column is 0-based"
    ^self class cTreeModel: self gtk path: aPath column: aColumn.
!
!

!"----- ListStore -----"

ListStore class defineCFunc: 'gst_gtk_create_list_store' 
    withSelectorArgs: 'cCreateListStore' 
    returning: #cObject 
    args: #(#void)!

ListStore class defineCFunc: 'gst_gtk_list_store_insert' 
    withSelectorArgs: 'cListStore: aStore insertAt: aIndex' 
    returning: #void 
    args: #(#cObject #int)! 
  
ListStore class defineCFunc: 'gst_gtk_list_store_set' 
    withSelectorArgs: 'cListStore: aStore index: aIndex column: aColumn value: aValue' 
    returning: #void 
    args: #(#cObject #int #int #smalltalk)! 

!ListStore methodsFor: 'initialization'!

createGtk
	Transcript print: 'creating liststore'.
	gtk := self class cCreateListStore.
!
!

!ListStore methodsFor: 'accessing'!

at: aIndex column: aColumn put: aValue
    "index is 0-based, column is 0-based"
    self class cListStore: self gtk index: aIndex column: aColumn value: aValue.
!

at: aIndex column: aColumn
    "index is 0-based, column is 0-based"
    ^self path: aIndex asString column: aColumn.
!

insertAt: aIndex
    "index is 0-based, column is 0-based"
    self class cListStore: self gtk insertAt: aIndex.
!

at: aIndex
    ^self at: aIndex column: 0
!

at: aIndex put: aValue
    ^self at: aIndex column: 0 put: aValue
!

!

!"----- TreeStore -----"

TreeStore class defineCFunc: 'gst_gtk_create_tree_store' 
    withSelectorArgs: 'cCreateTreeStore' 
    returning: #cObject 
    args: #(#void)!

TreeStore class defineCFunc: 'gst_gtk_tree_store_insert' 
    withSelectorArgs: 'cTreeStore: aStore path: aPath insertAt: aIndex' 
    returning: #void 
    args: #(#cObject #string #int)! 

TreeStore class defineCFunc: 'gst_gtk_tree_store_set' 
    withSelectorArgs: 'cTreeStore: aStore path: aPath column: aColumn value: aValue' 
    returning: #void 
    args: #(#cObject #string #int #smalltalk)! 

!TreeStore methodsFor: 'initialization'!

createGtk
	gtk := self class cCreateTreeStore.
!
!

!TreeStore methodsFor: 'accessing'!

path: aPath insertAt: aIndex
    "paths are 0-based, colon-separated, column is 0-based"
    self class cTreeStore: self gtk path: aPath insertAt: aIndex.
!

path: aPath column: aColumn put: aValue
    "paths are 0-based, colon-separated, column is 0-based"
    self class cTreeStore: self gtk path: aPath column: aColumn value: aValue
!
!

!"----- TreeViewColumn -----"

TreeViewColumn class defineCFunc: 'gst_gtk_create_tree_column' 
    withSelectorArgs: 'cTreeView: aView createColumn: aTitle renderer: aRenderer attribute: aAttribute column: aColumn' 
    returning: #cObject 
    args: #(#cObject #string #cObject #string #int)! 

!TreeViewColumn class methodsFor: 'instance creation'!

newIn: aView title: aTitle renderer: aRenderer
	^(self basicNew) 
		createGtkIn: aView title: aTitle renderer: aRenderer;
		yourself.
!
    
!TreeViewColumn methodsFor: 'initialization'!

createGtkIn: aView title: aTitle renderer: aRenderer
	gtk := self class 
 	   cTreeView: aView gtk
 	   createColumn: aTitle 
 	   renderer: aRenderer gtk
 	   attribute: 'text'
 	   column: 0.
!
!
   
    
!"----- CellRenderer -----"

CellRenderer class defineCFunc: 'gst_gtk_create_cell_renderer' 
    withSelectorArgs: 'cCreateCellRenderer: aType' 
    returning: #cObject 
    args: #(#string)! 


!CellRenderer class methodsFor: 'instance creation'!

new
  ^(self basicNew) createGtk; yourself.
!
!

!CellRenderer methodsFor: 'initialization'!

createGtk 
	gtk := self class cCreateCellRenderer: self rendererType 
! 

rendererType 
	self subclassResponsibility 
! 
!

!"----- TextCellRenderer -----"

!TextCellRenderer methodsFor: 'initialization'!

rendererType 
	^'text' 
! 
!

!"----- RowActivatedSignal -----"

RowActivatedSignal class
        defineCFunc: 'gst_gtk_row_activated_callback_connect'
        withSelectorArgs: 'cConnect: aWidget signal: aName callback: aSignal'
        returning: #void
        args: #(#cObject #string #smalltalk)
!

!"----- SelectionChangedSignal -----"

SelectionChangedSignal class
        defineCFunc: 'gst_gtk_selection_changed_callback_connect'
        withSelectorArgs: 'cConnect: aWidget signal: aName callback: aSignal'
        returning: #void
        args: #(#cObject #string #smalltalk)
!
!
