"grep defineCFunc GstGtkText.st | perl -pe ""s/.*'(.*)'.*/smalltalk_vm_proxy->defineCFunc\(\""\1\"", \1\);/"" > gst-gtk-text.inc"

Widget subclass: #TextView
       instanceVariableNames: 'buffer'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Graphics-Text'!

GtkObject subclass: #TextBuffer
       instanceVariableNames: 'tags marks'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Graphics-Text'!

GtkObject subclass: #TextTag
       instanceVariableNames: 'buffer name'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Graphics-Text'!

GtkObject subclass: #TextMark
       instanceVariableNames: 'buffer name position gravity builtin'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Graphics-Text'!

Signal subclass: #TextInsertedSignal
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

Signal subclass: #RangeDeletedSignal
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Trees'!

!"----- TextView -----"
TextView class
        defineCFunc: 'gst_gtk_textview_set_buffer'
        withSelectorArgs: 'cTextView: aView setBuffer: aBuffer'
        returning: #void
        args: #(#cObject #cObject)
!

!TextView class methodsFor: 'instance creation'!

widgetType
  ^'GtkTextView'.
!

!

!TextView methodsFor: 'loading and saving'!

restoreGtkLinks
  super restoreGtkLinks.
  self buffer: buffer.
!
!

!TextView methodsFor: 'buffers'!

buffer
  ^buffer.
!

buffer: aBuffer
  buffer := aBuffer.
  self class cTextView: self gtk setBuffer: aBuffer gtk.
!
!

!"----- TextBuffer -----"
TextBuffer class
        defineCFunc: 'gst_gtk_create_textbuffer'
        withSelectorArgs: 'cCreateBuffer'
        returning: #cObject
        args: #()
!

TextBuffer class
        defineCFunc: 'gst_gtk_create_textmark'
        withSelectorArgs: 'cTextBuffer: aBuffer createMark: aName at: aPosition leftGravity: aBoolean'
        returning: #cObject
        args: #(#cObject #string #int #boolean)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_get_mark_named'
        withSelectorArgs: 'cTextBuffer: aBuffer markNamed: aName'
        returning: #cObject
        args: #(#cObject #string)
!

TextBuffer class
        defineCFunc: 'gst_gtk_create_texttag'
        withSelectorArgs: 'cTextBuffer: aBuffer createTag: aName'
        returning: #cObject
        args: #(#cObject #string)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_set_all_text'
        withSelectorArgs: 'cTextBuffer: aBuffer setText: aString'
        returning: #void
        args: #(#cObject #string)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_get_all_text'
        withSelectorArgs: 'cTextBufferGetText: aBuffer'
        returning: #string
        args: #(#cObject)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_get_end'
        withSelectorArgs: 'cTextBufferGetEnd: aBuffer'
        returning: #int
        args: #(#cObject)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_get_text'
        withSelectorArgs: 'cTextBufferGetText: aBuffer from: aStart to: aEnd'
        returning: #string
        args: #(#cObject #int #int)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_get_selection_text'
        withSelectorArgs: 'cTextBufferGetSelectionText: aBuffer'
        returning: #string
        args: #(#cObject)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_apply_tag'
        withSelectorArgs: 'cTextBuffer: aBuffer applyTag: aTag from: aStart to: aEnd'
        returning: #void
        args: #(#cObject #cObject #int #int)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_remove_tag'
        withSelectorArgs: 'cTextBuffer: aBuffer removeTag: aTag from: aStart to: aEnd'
        returning: #void
        args: #(#cObject #cObject #int #int)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_remove_all_tags'
        withSelectorArgs: 'cTextBufferRemoveAllTags: aBuffer from: aStart to: aEnd'
        returning: #void
        args: #(#cObject #int #int)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_get_current_line'
        withSelectorArgs: 'cTextBufferGetCurrentLine: aBuffer'
        returning: #string
        args: #(#cObject)
!

TextBuffer class
        defineCFunc: 'gst_gtk_textbuffer_get_line_offset'
        withSelectorArgs: 'cTextBuffer: aBuffer getLineOffset: aLine'
        returning: #int
        args: #(#cObject #int)
!

!TextBuffer class methodsFor: 'instance creation' !

new
  | buf |
  buf := self basicNew createGtk; initialize; yourself.
  ^buf.
!

!TextBuffer methodsFor: 'initialization' !

initialize
  "tags := Dictionary new.
  marks := Dictionary new."
!

createGtk
  gtk := self class cCreateBuffer.  
  ^self.
!

recreateGtk
  self createGtk.
  self recreateTagsAndMarks
!

recreateTagsAndMarks
  tags notNil ifTrue: [ tags do: [ :each | each recreateGtk: self ] ].
  marks notNil ifTrue: [ marks do: [ :each | each recreateGtk: self ] ].
!

!TextBuffer methodsFor: 'loading and saving'!

update: aParameter
  | toRestore |
  super update: aParameter.

  "(#(#recreateWidget #recreateOtherWidgets) includes: aParameter) ifTrue: [
    self perform: aParameter
  ]."
!
!

!TextBuffer methodsFor: 'signals'!

connectSignal: aSignal to: aReceiver send: aSelector
  (aSignal match: 'insert-text') ifTrue: [
    self addSignal: 
      (TextInsertedSignal new on: aSignal from: self send: aSelector asSymbol to: aReceiver).
    ^self.
  ].
  (aSignal match: 'delete-range') ifTrue: [
    self addSignal: 
      (RangeDeletedSignal new on: aSignal from: self send: aSelector asSymbol to: aReceiver).
    ^self.
  ].

  super connectSignal: aSignal to: aReceiver send: aSelector.
!
!

!TextBuffer methodsFor: 'private'!

vivifyInternalMark: aName
    | mk |
    mk := self class cTextBuffer: self gtk markNamed: aName.
    mk isNil ifTrue: [ self error: 'There is no internal mark named: ', aName ].
    ^self addMark: (TextMark named: aName in: self gtk: mk).
!

!TextBuffer methodsFor: 'tags and marks'!

tags
  tags isNil ifTrue: [ tags := Dictionary new ].
  ^tags.
!

marks
  marks isNil ifTrue: [ marks := Dictionary new ].
  ^marks.
!

addTag: aTag
  ^self tags at: aTag name put: aTag.
!

addMark: aMark
  ^self marks at: aMark name put: aMark.
!

hasMarkNamed: aName
    marks isNil ifTrue: [ ^false ].
    ^marks includesKey: aName.  
!

markNamed: aName
    self marks at: aName ifPresent: [ :mk | ^mk ].
    "Could be an internal mark"
    ^self vivifyInternalMark: aName.
!

hasTagNamed: aName
    tags isNil ifTrue: [ ^false ].
    ^tags includesKey: aName.
!

tagNamed: aName
    ^self tags at: aName.
!

applyTag: aTag from: aStart to: aEnd
    self class cTextBuffer: self gtk applyTag: aTag gtk from: aStart to: aEnd.
    ^aTag.
!

removeTag: aTag from: aStart to: aEnd
    self class cTextBuffer: self gtk removeTag: aTag gtk from: aStart to: aEnd.
!

removeAllTagsFrom: aStart to: aEnd
    self class cTextBufferRemoveAllTags: self gtk from: aStart to: aEnd.
!

removeAllTags
    self removeAllTagsFrom: 0 to: self getEnd.
!

applyTagNamed: aName from: aStart to: aEnd
    ^self applyTag: (self tags at: aName) from: aStart to: aEnd.
!

removeTagNamed: aName from: aStart to: aEnd
    self removeTag: (self tags at: aName) from: aStart to: aEnd.
!
!

!TextBuffer methodsFor: 'text manipulation'!

setText: aString
    self class cTextBuffer: self gtk setText: aString.
!

getTextFrom: aStart to: aEnd
    ^self class cTextBufferGetText: self gtk fFrom: aStart to: aEnd.
!

getSelection
    ^self class cTextBufferGetSelectionText: self gtk.
!

getEnd
    "Returns an offset which is one past the last character in the buffer"
    ^self class cTextBufferGetEnd: self gtk.
!

getText
    ^self class cTextBufferGetText: self gtk.
!

getCurrentLine
    ^self class cTextBufferGetCurrentLine: self gtk.
!

currentLine
    ^(self markNamed: 'insert') line.
!

currentPosition
    ^(self markNamed: 'insert') position.
!

lineOffset: aLine
    ^self class cTextBuffer: self gtk getLineOffset: aLine.
!
!

!"----- TextTag -----"

!TextTag class methodsFor: 'instance creation'!

new: aName in: aBuffer
  | tag |
  (aBuffer tags includesKey: aName) ifTrue: [
    self error: 'Buffer already includes a tag named ', aName.
  ].
  tag := (self basicNew) 
    name: aName; 
    buffer: aBuffer; 
    recreateGtk; 
    yourself.
  aBuffer addTag: tag.
  ^tag.
!

!TextTag methodsFor: 'loading and saving'!

recreateGtk
  self gtk: (TextBuffer cTextBuffer: buffer gtk createTag: name).
!
!

!TextTag methodsFor: 'private'!

gtk: aGtk
  gtk := aGtk.
!

name: aName
  name := aName.
!

buffer: aBuffer
  buffer := aBuffer
!

!TextTag methodsFor: 'accessing'!
 
name
  ^name
!
!

!"----- TextMark -----"

TextMark class
        defineCFunc: 'gst_gtk_textmark_get_line'
        withSelectorArgs: 'cTextMarkGetLine: aMark'
        returning: #int
        args: #(#cObject)
!

TextMark class
        defineCFunc: 'gst_gtk_textmark_get_offset'
        withSelectorArgs: 'cTextMarkGetPosition: aMark'
        returning: #int
        args: #(#cObject)
!

!TextMark class methodsFor: 'instance creation'!

named: aName in: aBuffer gtk: aGtk
  "Used by TextBuffer - create a new ST object to contain the pre-existing mark named aName"
  | mark |
  mark := (self basicNew)
    name: aName;
    buffer: aBuffer;
    builtin: false;
    gtk: aGtk;
    yourself.
  ^mark.  
!

new: aName in: aBuffer at: aPosition
  ^self new: aName in: aBuffer at: aPosition leftGravity: true.
!

new: aName in: aBuffer at: aPosition leftGravity: aBoolean 
  | mark |
  mark := (self basicNew)
    name: aName;
    buffer: aBuffer;
    builtin: true;
    createdAt: aPosition;
    createdGravity: aBoolean;
    recreateGtk;
    yourself.
  aBuffer addMark: mark.
  ^mark.
!
!

!TextMark methodsFor: 'loading and saving'!

recreateGtk
    self isBuiltin 
        ifFalse:
	[
	    self gtk: (TextBuffer
	        cTextBuffer: buffer gtk 
		createMark: name
		at: position
		leftGravity: gravity
	    ).
        ]
        ifTrue: 
	[
	    self gtk: (TextBuffer
     	        cTextBuffer: buffer gtk
		markNamed: name
	    ).
	].
!
!

!TextMark methodsFor: 'private'!

gtk: aGtk
    gtk := aGtk.
!

createdAt: aPosition
  position := aPosition.
!

createdGravity: aGravity
  gravity := aGravity
!

buffer: aBuffer
  buffer := aBuffer
!

builtin: aBoolean
  builtin := aBoolean
!

name: aName
  name := aName.
!
!

!TextMark methodsFor: 'accessing'!
 
name
  ^name
!

isBuiltin
  ^builtin
!

position
    position := self class cTextMarkGetPosition: self gtk.
    ^position.
!

line
    ^self class cTextMarkGetLine: self gtk.
!
!

!"----- TextInsertedSignal -----"

TextInsertedSignal class
        defineCFunc: 'gst_gtk_insert_text_callback_connect'
        withSelectorArgs: 'cConnect: aWidget signal: aName callback: aSignal'
        returning: #void
        args: #(#cObject #string #smalltalk)
!

!"----- RangeDeletedSignal -----"

RangeDeletedSignal class
        defineCFunc: 'gst_gtk_delete_range_callback_connect'
        withSelectorArgs: 'cConnect: aWidget signal: aName callback: aSignal'
        returning: #void
        args: #(#cObject #string #smalltalk)
!
!
!



