Object subclass: #Signal
	instanceVariableNames: 'source signal receiver selector connected'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

!"----- Signal -----"
"void gst_gtk_signal_connect(void *widget, char *signal, OOP cb_obj, OOP cb_sel,
 OOP cb_src);"
Signal class
        defineCFunc: 'gst_gtk_signal_connect'
        withSelectorArgs: 'cConnect: aWidget signal: aName callback: aSignal'
        returning: #void
        args: #(#cObject #string #smalltalk)
!

"void gst_gtk_signal_disconnect(void *widget, char *signal);"
Signal class
        defineCFunc: 'gst_gtk_signal_disconnect'
        withSelectorArgs: 'cDisconnect: aWidget signal: aName'
        returning: #void
        args: #(#cObject #string)
!

Signal class
        defineCFunc: 'gst_gtk_signal_abort'
        withSelectorArgs: 'cAbort: aWidget signal: aName'
        returning: #void
        args: #(#cObject #string)
!

Signal class
        defineCFunc: 'gst_gtk_signal_emit'
        withSelectorArgs: 'cEmit: aWidget signal: aName'
        returning: #void
        args: #(#cObject #string)
!

"For debugging"
"int gst_gtk_test_oop(oop aOop)"
Signal
        defineCFunc: 'gst_gtk_test_oop'
        withSelectorArgs: 'testOOP'
        returning: #int
        args: #(#selfSmalltalk)
!

!Signal methodsFor: 'initialization'!

"checkNumberOfArgs
  (selector numArgs ~= 1) ifTrue: [ 
    self error: 'Can''t connect ''', signal, ''' to ',
      selector printString, '; it should have 1 argument.'
  ].
!"

on: aSignal from: aSource send: aSelector to: aReceiver
  source := aSource.
  signal := aSignal.
  receiver := aReceiver.
  selector := aSelector asSymbol.
  "self checkNumberOfArgs"
  self connect.
  ^self.
!

onST: aSignal from: aSource send: aSelector to: aReceiver
  source := aSource.
  signal := aSignal.
  receiver := aReceiver.
  selector := aSelector asSymbol.
  "Should there be self connect here?"
  ^self.
!
!

!Signal methodsFor: 'private'!

signal
  "Needed by Widget>>addSignal"
  ^signal.
!
!

!Signal methodsFor: 'callbacks'!

callback
  "Unary callback, ie. no arguments except the source"
  receiver perform: selector with: source.
!

callbackWith: aData
  "Binary callback - source and one data argument (registered by a subclass)"
  receiver perform: selector with: source with: aData.
!

callbackWith: aData1 with: aData2
  "Callback with source and two data arguments"
  receiver perform: selector with: source with: aData1 with: aData2.
!

!Signal methodsFor: 'control'!

connect
  self class cConnect: source gtk signal: signal callback: self.
  connected := true.
!

disconnect
  connected ifTrue: [
    self class cDisconnect: source gtk signal: signal.
    connected := false.
  ]
!

abort
  connected
    ifTrue: [
      self class cAbort: source gtk signal: signal.
  ]
!

emit
  connected
    ifTrue: [
      "This will additionally trigger any other signals that
      may be hooked up (in Gtk)."
      self class cEmit: source gtk signal: signal.
    ]
    ifFalse: [
      self callback.
    ]
!
!
