Widget subclass: #MenuShell
	instanceVariableNames: 'items'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Menus'!

MenuShell subclass: #MenuBar
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Menus'!

MenuShell subclass: #Menu
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Menus'!

Bin subclass: #Item
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Menus'!

Item subclass: #MenuItem
	instanceVariableNames: 'submenu'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Menus'!

!"----- MenuShell -----"
MenuShell class defineCFunc: 'gst_gtk_menu_insert_item' 
    withSelectorArgs: 'cMenuShell: aShell insert: aItem at: aPosition' 
    returning: #void 
    args: #(#cObject #cObject #int)! 

"!MenuShell methodsFor: 'initialization'!

packInto: aContainer
  parent notNil ifTrue: [parent remove: self].
  aContainer notNil ifTrue: [aContainer add: self].
  parent := aContainer.
!
!"

!MenuShell methodsFor: 'menu items'!

items
  items isNil ifTrue: [ items := OrderedCollection new ].
  ^items
!

insertItem: aItem at: aPosition
  self class cMenuShell: self gtk insert: aItem gtk at: aPosition.
  self items add: aItem beforeIndex: (aPosition + 1).
  ^aItem.
! 

addItem: aItem
  ^self insertItem: aItem at: (self items size).
!
!

!"----- MenuItem -----"

MenuItem class defineCFunc: 'gst_gtk_menu_set_submenu' 
    withSelectorArgs: 'cMenuItem: aItem addSubmenu: aMenu' 
    returning: #void 
    args: #(#cObject #cObject)! 

MenuItem class defineCFunc: 'gst_gtk_menu_remove_submenu' 
    withSelectorArgs: 'cMenuItemRemoveSubmenu: aItem' 
    returning: #void 
    args: #(#cObject)! 

MenuItem class methodsFor: 'instance creation'!

widgetType
  ^'GtkMenuItem'
!

new: aName label: aString
  ^(super new: aName) labelText: aString; yourself.
!

new: aName label: aString in: aMenu
  | mi |
  mi := self new: aName label: aString.
  aMenu addItem: mi.
  ^mi.
!

!
!

!MenuItem methodsFor: 'labels and submenus'!

label
    self child ifNotNil: [ :ch | ^ch ].
    ^(Gtk.Label new: self name, '_label' in: self)
	property: 'xalign' value: 0.0;
	yourself.
!

labelText: aString
    self label label: aString.
!

labelText
    ^self label label.
!

hasSubmenu
    ^submenu notNil.
!

submenu
    submenu isNil ifTrue: [ self addSubmenu ].
    ^submenu.
!

addSubmenu: aMenu
    submenu := aMenu.
    self class cMenuItem: self gtk addSubmenu: submenu gtk.
    ^submenu.
!

addSubmenu
    ^self addSubmenu: (Gtk.Menu new: self name, '_menu').
!

removeSubmenu
    self cMenuItemRemoveSubmenu: self gtk.
    submenu := nil.
!

addItem: aItem
    self submenu addItem: aItem.
!
!

!"----- MenuBar -----"

!MenuBar class methodsFor: 'instance creation'!

widgetType
  ^'GtkMenuBar'
!
!

!"----- Menu -----"

!Menu class methodsFor: 'instance creation'!

widgetType
  ^'GtkMenu'
!

new: aName label: aString inMenuBar: aMenuBar
  | mi menu |
  mi := MenuItem new: (aName, '_item') label: aString in: aMenuBar.
  menu := super new: aName.
  mi addSubmenu: menu.
  ^menu.
!
!

                                          
!
